/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.VoucherReport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import ui.DataDialog;
import ui.DateTextField;
import ui.TableLayout;
import util.TimeUtil;
import util.Validation;
import util.WinUtil;

public class VoucherReportDialog
extends DataDialog {
    private JTextField start_idTF;
    private JTextField end_idTF;
    private DateTextField start_dateDTF;
    private DateTextField end_dateDTF;
    private JRadioButton id_rangeRB;
    private JRadioButton date_rangeRB;
    private JButton printB;
    private JButton cancelB;

    public VoucherReportDialog(JFrame frame) {
        super(frame, "Voucher Report", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 370, 150, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 80;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30, 30});
        this.id_rangeRB = new JRadioButton("ID");
        this.date_rangeRB = new JRadioButton("Date");
        this.date_rangeRB.setSelected(true);
        ButtonGroup rangeBG = new ButtonGroup();
        rangeBG.add(this.id_rangeRB);
        rangeBG.add(this.date_rangeRB);
        this.start_idTF = new JTextField();
        this.end_idTF = new JTextField();
        this.start_idTF.setEnabled(false);
        this.end_idTF.setEnabled(false);
        this.start_dateDTF = new DateTextField(TimeUtil.getCurrentDate());
        this.end_dateDTF = new DateTextField(TimeUtil.getCurrentDate());
        this.printB = new JButton("Run");
        this.cancelB = new JButton("Cancel");
        int row = 0;
        t.getClass();
        t.addCell(this.date_rangeRB, 0, row, 20, 0);
        t.getClass();
        t.addCell(this.start_dateDTF, 1, row, 20, 0);
        JLabel jLabel = new JLabel("to");
        t.getClass();
        t.addCell(jLabel, 1, row, 115, 0);
        t.getClass();
        t.addCell(this.end_dateDTF, 1, row, 140, 0);
        t.getClass();
        t.addCell(this.id_rangeRB, 0, ++row, 20, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.start_idTF, 1, row, 20, 0, 100, -1);
        JLabel jLabel2 = new JLabel("to");
        t.getClass();
        t.addCell(jLabel2, 1, row, 135, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.end_idTF, 1, row, 160, 0, 100, -1);
        t.addYSpace(10);
        int[] nArray2 = new int[3];
        nArray2[0] = 165;
        nArray2[1] = 15;
        t.getClass();
        nArray2[2] = 0;
        t.addTable(nArray2, new int[]{30});
        row = 0;
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.printB, 0, 0, 1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0, 80, -1);
    }

    public void setEventHandler() {
        this.id_rangeRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherReportDialog.this.onSelectIDRange(evt);
            }
        });
        this.date_rangeRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherReportDialog.this.onSelectDateRange(evt);
            }
        });
        this.printB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherReportDialog.this.onPrint(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherReportDialog.this.onCancel(evt);
            }
        });
    }

    private void onSelectIDRange(ActionEvent evt) {
        this.start_idTF.setEnabled(true);
        this.end_idTF.setEnabled(true);
        this.start_dateDTF.setEnabled(false);
        this.end_dateDTF.setEnabled(false);
    }

    private void onSelectDateRange(ActionEvent evt) {
        this.start_idTF.setEnabled(false);
        this.end_idTF.setEnabled(false);
        this.start_dateDTF.setEnabled(true);
        this.end_dateDTF.setEnabled(true);
    }

    private void onPrint(ActionEvent evt) {
        Validation validation = new Validation();
        if (this.id_rangeRB.isSelected()) {
            validation.add(this.start_idTF.getText(), "Start ID", "R");
            validation.add(this.end_idTF.getText(), "End ID", "R");
        } else {
            validation.add(this.start_dateDTF.getText(), "Start date", "R,D");
            validation.add(this.end_dateDTF.getText(), "End date", "R,D");
        }
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Running report...");
        VoucherReport p = new VoucherReport(this.id_rangeRB.isSelected() ? this.start_idTF.getText() : "", this.id_rangeRB.isSelected() ? this.end_idTF.getText() : "", this.date_rangeRB.isSelected() ? this.start_dateDTF.getDate() : null, this.date_rangeRB.isSelected() ? this.end_dateDTF.getDate() : null);
        wait_dialog.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

