/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import account.Voucher;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelFormula;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class VoucherReport {
    private RecordList gVouchers;
    private RecordList gVoucherItems;

    public VoucherReport(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        this.gVouchers = VoucherReport.getVouchers(start_id, end_id, start_date, end_date);
        this.gVoucherItems = VoucherReport.getVoucherItems(start_id, end_id, start_date, end_date);
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4, new int[]{25, 22, 20, 20, 25, 26, 22, 22});
        String range = start_id.isEmpty() ? String.valueOf(Lang.set("Date: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" to ") + TimeUtil.getStringByDate(end_date) : String.valueOf(Lang.set("Voucher ID: ")) + start_id + Lang.set(" to ") + end_id;
        p.addHeader(Config.getS(Config.companyName), Lang.set("Voucher Report"), new String[]{range, Lang.set("*Exclude cancelled vouchers")});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("ID"), p.TL);
        p.addCell(1, row, Lang.set("Date"), p.TL);
        p.addCell(2, row, Lang.set("Status"), p.TL);
        p.addCell(3, row, Lang.set("A/C ID"), p.TL);
        p.addCell(4, row, Lang.set("Remark"), p.TL);
        p.addCell(5, row, Lang.set("Cheque/Ref#"), p.TL);
        p.addCell(6, row, String.valueOf(Lang.set("Debit(")) + Config.getS(Config.currencyCode) + ")", p.TR);
        p.addCell(7, row, String.valueOf(Lang.set("Credit(")) + Config.getS(Config.currencyCode) + ")", p.TR);
        int i = 0;
        while (i < this.gVouchers.size()) {
            this.gVouchers.setCurrentRow(i);
            RecordList items = this.gVoucherItems.getGroupItems("ac_doc_seq", this.gVouchers.getI("ac_doc_seq"));
            int j = 0;
            while (j < items.size()) {
                ExcelCellFormat strFormat = p.FORMAT_STRING;
                ExcelCellFormat numFormat = p.FORMAT_DOUBLE;
                if (j == items.size() - 1) {
                    strFormat = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BB);
                    numFormat = new ExcelCellFormat(ExcelCellFormat.DOUBLE, ExcelFormat.BB);
                }
                p.addCell(0, ++row, this.gVouchers.getS("id"), strFormat);
                p.addCell(1, row, TimeUtil.getStringByDate(this.gVouchers.getT("date")), strFormat);
                p.addCell(2, row, Tools.getStatusName(Voucher.STATUS_MAP, this.gVouchers.getS("status")), strFormat);
                items.setCurrentRow(j);
                p.addCell(3, row, items.getS("id"), strFormat);
                p.addCell(4, row, items.getS("remark").trim(), strFormat);
                p.addCell(5, row, items.getS("cheque_no"), strFormat);
                p.addCell(6, row, items.getD("debit"), numFormat);
                p.addCell(7, row, items.getD("credit"), numFormat);
                ++j;
            }
            ++i;
        }
        p.addCell(5, ++row, "Total Amount:", p.AR);
        if (this.gVoucherItems.isEmpty()) {
            p.addCell(6, row, 0, p.BTBD);
            p.addCell(7, row, 0, p.BTBD);
        } else {
            p.addCell(6, row, ExcelFormula.sum(6, row - this.gVoucherItems.size(), 6, row - 1), p.BTBD);
            p.addCell(7, row, ExcelFormula.sum(7, row - this.gVoucherItems.size(), 7, row - 1), p.BTBD);
        }
        p.addCell(5, ++row, "Total Vouchers:", p.AR);
        p.addCell(6, row, this.gVouchers.size());
        p.genPrintout();
    }

    private static RecordList getVouchers(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("where", new String[]{"id>=?", "id<=?", "date>=?", "date<?", "not status=?"}, new Object[]{start_id, end_id, start_date, TimeUtil.adjustDate(end_date, 1), Receipt.STATUS__CL});
        String sql = "select ac_doc_seq,id,date,status from voucher" + clause.getConds() + " order by date,id";
        return DBUtil.run(sql, clause.getPrepValues());
    }

    public static RecordList getVoucherItems(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"vo.id>=?", "vo.id<=?", "vo.date>=?", "vo.date<?", "not vo.status=?"}, new Object[]{start_id, end_id, start_date, TimeUtil.adjustDate(end_date, 1), Receipt.STATUS__CL});
        String sql = "select voi.ac_doc_seq,ac.id,voi.debit,voi.credit,voi.cheque_no,voi.remark from voucher as vo,voucher_item as voi,ac_master as ac where vo.ac_doc_seq=voi.ac_doc_seq and voi.ac_seq=ac.ac_seq" + clause.getConds();
        return DBUtil.run(sql, clause.getPrepValues());
    }
}

