/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.AccountMonth;
import account.TrialBalance;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import ui.DataDialog;
import ui.TableLayout;
import util.TimeUtil;
import util.WinUtil;

public class TrialBalanceDialog
extends DataDialog {
    private JCheckBox show_idCB;
    private JCheckBox show_group_totalCB;
    private JCheckBox show_zero_acCB;
    private JButton printB;
    private JButton cancelB;
    private int g_Start_acm_seq = -1;
    private int g_End_acm_seq = -1;

    public TrialBalanceDialog(DataDialog frame, int start_acm_seq, int end_acm_seq) {
        super(frame, "Trial Balance", false);
        this.g_Start_acm_seq = start_acm_seq;
        this.g_End_acm_seq = end_acm_seq;
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        AccountMonth start_month = new AccountMonth(this.g_Start_acm_seq);
        AccountMonth end_month = new AccountMonth(this.g_End_acm_seq);
        TableLayout t = new TableLayout(this, 295, 215, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 60;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30});
        JLabel jLabel = new JLabel("Period");
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel(String.valueOf(TimeUtil.getStringByDate(start_month.getStart_date())) + "-" + TimeUtil.getStringByDate(end_month.getEnd_date()));
        t.getClass();
        t.addCell(jLabel2, 1, 0, 20, 0);
        this.show_idCB = new JCheckBox("Show A/C ID", true);
        this.show_group_totalCB = new JCheckBox("Show group A/C balances", true);
        this.show_zero_acCB = new JCheckBox("Show A/C w/o transaction", true);
        t.getClass();
        t.addCell(this.show_idCB, 1, 1, 20, 0);
        t.getClass();
        t.addCell(this.show_group_totalCB, 1, 2, 20, 0);
        t.getClass();
        t.addCell(this.show_zero_acCB, 1, 3, 20, 0);
        t.addYSpace(10);
        int[] nArray2 = new int[3];
        nArray2[0] = 130;
        nArray2[1] = 15;
        t.getClass();
        nArray2[2] = 0;
        t.addTable(nArray2, new int[]{30});
        this.printB = new JButton("Run");
        this.cancelB = new JButton("Cancel");
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.printB, 0, 0, 1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0, 80, -1);
    }

    public void setEventHandler() {
        this.printB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrialBalanceDialog.this.onPrint(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrialBalanceDialog.this.onCancel(evt);
            }
        });
    }

    public void onPrint(ActionEvent evt) {
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Running report...");
        TrialBalance p = new TrialBalance(this.g_Start_acm_seq, this.g_End_acm_seq, this.show_idCB.isSelected(), this.show_group_totalCB.isSelected(), this.show_zero_acCB.isSelected());
        wait_dialog.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

