/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.AccountBalance;
import account.AccountMonth;
import java.math.BigDecimal;
import java.util.ArrayList;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import system.SystemCode;
import util.Arith;
import util.ArrayListCreator;
import util.ArrayUtil;
import util.TimeUtil;

public class TrialBalance {
    private ArrayList g_Accounts = null;
    private ExcelPrintout g_Printout = null;
    private ArrayList g_Bf_balances = null;
    private ArrayList g_Period_balances = null;
    private int g_Row = 0;
    private boolean g_Show_id = false;
    private boolean g_Show_group_total = false;
    private boolean g_Show_zero_ac = false;
    private double g_Ttl_bf_debit = 0.0;
    private double g_Ttl_bf_credit = 0.0;
    private double g_Ttl_month_debit = 0.0;
    private double g_Ttl_month_credit = 0.0;
    private static final String INDENT = "  ";

    public TrialBalance(int start_acm_seq, int end_acm_seq, boolean show_id, boolean show_group_total, boolean show_zero_ac) {
        this.g_Show_id = show_id;
        this.g_Show_group_total = show_group_total;
        this.g_Show_zero_ac = show_zero_ac;
        AccountMonth start_month = new AccountMonth(start_acm_seq);
        AccountMonth end_month = new AccountMonth(end_acm_seq);
        this.g_Accounts = Account.getAllAccounts();
        ArrayList ac_seqs = ArrayUtil.getCol(this.g_Accounts, "AC_SEQ");
        this.g_Bf_balances = AccountBalance.getBfBalances(TimeUtil.adjustDate(start_month.getStart_date(), -1), ac_seqs);
        this.g_Period_balances = AccountBalance.getPeriodBalances(start_month.getEnd_date(), end_month.getEnd_date(), ac_seqs);
        this.g_Printout = new ExcelPrintout(ExcelFormat.PA4, new int[]{42, 24, 24, 22, 22, 24, 24});
        this.g_Printout.addHeader(Config.getS(Config.companyName), Lang.set("Trial Balance"), new String[]{String.valueOf(Lang.set("Period: ")) + TimeUtil.getStringByDate(start_month.getStart_date()) + " - " + TimeUtil.getStringByDate(end_month.getEnd_date()), String.valueOf(Lang.set("Total A/C: ")) + this.g_Period_balances.size()});
        this.g_Row = this.g_Printout.getRowNumAfterHeader();
        this.g_Printout.addCell(0, this.g_Row, Lang.set("A/C"), this.g_Printout.TL);
        this.g_Printout.addCell(1, this.g_Row, String.valueOf(Lang.set("B/F Debit(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(2, this.g_Row, String.valueOf(Lang.set("B/F Credit(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(3, this.g_Row, String.valueOf(Lang.set("Cur. Debit(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(4, this.g_Row, String.valueOf(Lang.set("Cur. Credit(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(5, this.g_Row, String.valueOf(Lang.set("Ttl. Debit(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(6, this.g_Row, String.valueOf(Lang.set("Ttl. Credit(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.printTypeAccounts(this.g_Accounts);
        double ttl_all_debit = Arith.add(this.g_Ttl_bf_debit, this.g_Ttl_month_debit);
        double ttl_all_credit = Arith.add(this.g_Ttl_bf_credit, this.g_Ttl_month_credit);
        ++this.g_Row;
        this.g_Printout.addCell(0, this.g_Row, String.valueOf(Lang.set("Total(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.AR);
        this.g_Printout.addCell(1, this.g_Row, this.g_Ttl_bf_debit, this.g_Printout.BTBD);
        this.g_Printout.addCell(2, this.g_Row, this.g_Ttl_bf_credit, this.g_Printout.BTBD);
        this.g_Printout.addCell(3, this.g_Row, this.g_Ttl_month_debit, this.g_Printout.BTBD);
        this.g_Printout.addCell(4, this.g_Row, this.g_Ttl_month_credit, this.g_Printout.BTBD);
        this.g_Printout.addCell(5, this.g_Row, ttl_all_debit, this.g_Printout.BTBD);
        this.g_Printout.addCell(6, this.g_Row, ttl_all_credit, this.g_Printout.BTBD);
        this.g_Printout.genPrintout();
    }

    private void printTypeAccounts(ArrayList type_acs) {
        ArrayList first_level_acs = ArrayUtil.getGroupItems(type_acs, "PARENT_AC_SEQ", new Integer(-1));
        ++this.g_Row;
        ArrayList self_totals = this.getNewEmptyTotals();
        this.printGroupAccounts(0, first_level_acs, self_totals);
    }

    /*
     * Unable to fully structure code
     */
    private void printGroupAccounts(int level, ArrayList group_acs, ArrayList parent_totals) {
        i = 0;
        while (i < group_acs.size()) {
            block16: {
                block14: {
                    block15: {
                        ac_seq = ArrayUtil.getInt("AC_SEQ", i, group_acs);
                        is_parent = ArrayUtil.getString("IS_PARENT", i, group_acs);
                        id = ArrayUtil.getString("ID", i, group_acs);
                        name = ArrayUtil.getString("NAME", i, group_acs);
                        id_name = String.valueOf(this.getIndent(level)) + (this.g_Show_id != false ? String.valueOf(id) + " " : "") + name;
                        is_debit = this.isDebit(ArrayUtil.getString("TYPE", i, group_acs));
                        status = ArrayUtil.getString("STATUS", i, group_acs);
                        row = ++this.g_Row;
                        bf_bal = 0.0;
                        month_bal = 0.0;
                        all_bal = 0.0;
                        if (!is_parent.equals("N")) break block14;
                        k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), this.g_Bf_balances);
                        bf_bal = k != -1 ? ArrayUtil.getDouble("BALANCE", k, this.g_Bf_balances) : 0.0;
                        k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), this.g_Period_balances);
                        month_bal = k != -1 ? ArrayUtil.getDouble("BALANCE", k, this.g_Period_balances) : 0.0;
                        all_bal = Arith.add(bf_bal, month_bal);
                        if (is_debit) {
                            this.g_Ttl_bf_debit = Arith.add(this.g_Ttl_bf_debit, bf_bal);
                            this.g_Ttl_month_debit = Arith.add(this.g_Ttl_month_debit, month_bal);
                        } else {
                            this.g_Ttl_bf_credit = Arith.sub(this.g_Ttl_bf_credit, bf_bal);
                            this.g_Ttl_month_credit = Arith.sub(this.g_Ttl_month_credit, month_bal);
                        }
                        if (this.g_Show_zero_ac || bf_bal != 0.0 || month_bal != 0.0) break block15;
                        --this.g_Row;
                        break block16;
                    }
                    if (!status.equals(SystemCode.STATUS__D) || bf_bal != 0.0 || month_bal != 0.0) ** GOTO lbl-1000
                    --this.g_Row;
                    break block16;
                }
                next_level_acs = ArrayUtil.getGroupItems(this.g_Accounts, "PARENT_AC_SEQ", new Integer(ac_seq));
                self_totals = this.getNewEmptyTotals();
                this.printGroupAccounts(level + 1, next_level_acs, self_totals);
                bf_bal = ArrayUtil.getDouble("BF_BAL", 0, self_totals);
                month_bal = ArrayUtil.getDouble("MONTH_BAL", 0, self_totals);
                all_bal = Arith.add(bf_bal, month_bal);
                has_child = ArrayUtil.getString("HAS_CHILD", 0, self_totals);
                if (!this.g_Show_zero_ac && has_child.equals("N")) {
                    --this.g_Row;
                } else if (status.equals(SystemCode.STATUS__D) && has_child.equals("N")) {
                    --this.g_Row;
                } else lbl-1000:
                // 2 sources

                {
                    this.g_Printout.addCell(0, row, id_name);
                    if (is_parent.equals("N") || this.g_Show_group_total) {
                        if (is_debit && bf_bal != 0.0) {
                            this.g_Printout.addCell(1, row, bf_bal);
                        }
                        if (!is_debit && bf_bal != 0.0) {
                            this.g_Printout.addCell(2, row, Arith.mul(-1.0, bf_bal));
                        }
                        if (is_debit && month_bal != 0.0) {
                            this.g_Printout.addCell(3, row, month_bal);
                        }
                        if (!is_debit && month_bal != 0.0) {
                            this.g_Printout.addCell(4, row, Arith.mul(-1.0, month_bal));
                        }
                        if (is_debit && all_bal != 0.0) {
                            this.g_Printout.addCell(5, row, all_bal);
                        }
                        if (!is_debit && all_bal != 0.0) {
                            this.g_Printout.addCell(6, row, Arith.mul(-1.0, all_bal));
                        }
                    }
                    ArrayUtil.addDouble("BF_BAL", bf_bal, 0, parent_totals);
                    ArrayUtil.addDouble("MONTH_BAL", month_bal, 0, parent_totals);
                    ArrayUtil.setString("HAS_CHILD", "Y", 0, parent_totals);
                }
            }
            ++i;
        }
    }

    private ArrayList getNewEmptyTotals() {
        ArrayListCreator creator = new ArrayListCreator(new String[]{"bf_bal", "month_bal", "has_child"});
        creator.add(new Object[]{new BigDecimal(0), new BigDecimal(0), "N"});
        return creator.getArrayList();
    }

    private boolean isDebit(String type) {
        return type.equals("A") || type.equals("E");
    }

    private String getIndent(int level) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < level) {
            b.append(INDENT);
            ++i;
        }
        return b.toString();
    }
}

