/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import java.util.ArrayList;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import system.MasterCode;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;

public class ReceiptSummaryReport {
    private RecordList gSubTypes;
    private RecordList gPaymentMethods;
    private ExcelCellFormat IBTBD = new ExcelCellFormat(ExcelCellFormat.INT, String.valueOf(ExcelFormat.BT) + ExcelFormat.BD);

    public ReceiptSummaryReport(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        this.getSummary(start_id, end_id, start_date, end_date);
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4, new int[]{90, 30, 30, 30});
        String range = start_id.isEmpty() ? String.valueOf(Lang.set("Date: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" to ") + TimeUtil.getStringByDate(end_date) : String.valueOf(Lang.set("ID: ")) + start_id + Lang.set(" To ") + end_id;
        p.addHeader(Config.getS(Config.churchName), Lang.set("Receipt Summary Report"), new String[]{range, Lang.set("*Exclue cancelled receipts")});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("Item"), p.TL);
        p.addCell(1, row, Lang.set("Members"), p.TR);
        p.addCell(2, row, Lang.set("Counts"), p.TR);
        p.addCell(3, row, String.valueOf(Lang.set("Amount(")) + Config.getS(Config.currencyCode) + ")", p.TR);
        ArrayList codes = MasterCode.getCodes("RECEIPT_SUB_TYPE");
        int i = 0;
        while (i < codes.size()) {
            String code = ArrayUtil.getString("CODE", i, codes);
            String name = ArrayUtil.getString("NAME", i, codes);
            int k = this.gSubTypes.indexOf("sub_type", code);
            this.gSubTypes.setCurrentRow(k);
            p.addCell(0, ++row, name);
            p.addCell(1, row, k == -1 ? 0 : this.gSubTypes.getI("member"));
            p.addCell(2, row, k == -1 ? 0 : this.gSubTypes.getI("freq"));
            p.addCell(3, row, k == -1 ? 0.0 : this.gSubTypes.getD("amount"), p.FORMAT_DOUBLE);
            ++i;
        }
        p.addCell(0, ++row, "Total Amount:", p.AR);
        p.addCell(1, row, ArrayUtil.getIntSum(this.gSubTypes, "member"), this.IBTBD);
        p.addCell(2, row, ArrayUtil.getIntSum(this.gSubTypes, "freq"), this.IBTBD);
        p.addCell(3, row, ArrayUtil.getDoubleSum(this.gSubTypes, "amount"), p.BTBD);
        p.addCell(0, row += 3, Lang.set("Method"), p.TL);
        p.addCell(1, row, Lang.set("Members"), p.TR);
        p.addCell(2, row, Lang.set("Count"), p.TR);
        p.addCell(3, row, String.valueOf(Lang.set("Amount(")) + Config.getS(Config.currencyCode) + ")", p.TR);
        ArrayList methods = MasterCode.getCodes("PAYMENT_METHOD");
        int i2 = 0;
        while (i2 < methods.size()) {
            String code = ArrayUtil.getString("CODE", i2, methods);
            String name = ArrayUtil.getString("NAME", i2, methods);
            int k = this.gPaymentMethods.indexOf("payment_method", code);
            this.gPaymentMethods.setCurrentRow(k);
            p.addCell(0, ++row, name);
            p.addCell(1, row, k == -1 ? 0 : this.gPaymentMethods.getI("member"));
            p.addCell(2, row, k == -1 ? 0 : this.gPaymentMethods.getI("freq"));
            p.addCell(3, row, k == -1 ? 0.0 : this.gPaymentMethods.getD("amount"), p.FORMAT_DOUBLE);
            ++i2;
        }
        p.addCell(0, ++row, "Total Amount:", p.AR);
        p.addCell(1, row, ArrayUtil.getIntSum(this.gPaymentMethods, "member"), this.IBTBD);
        p.addCell(2, row, ArrayUtil.getIntSum(this.gPaymentMethods, "freq"), this.IBTBD);
        p.addCell(3, row, ArrayUtil.getDoubleSum(this.gPaymentMethods, "amount"), p.BTBD);
        p.genPrintout();
    }

    private void getSummary(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"rc.id>=?", "rc.id<=?", "rc.date>=?", "rc.date<?", "not rc.status=?"}, new Object[]{start_id, end_id, start_date, TimeUtil.adjustDate(end_date, 1), Receipt.STATUS__CL});
        String sql = "select rci.sub_type,count(distinct rc.offer_from) as member,count(rci.receipt_item_seq) as freq,sum(rci.amount) as amount from receipt rc,receipt_item rci  where rc.receipt_seq=rci.receipt_seq" + clause.getConds() + " group by rci.sub_type";
        this.gSubTypes = DBUtil.run(sql, clause.getPrepValues());
        sql = "select rc.payment_method,count(distinct rc.offer_from) as member,count(distinct rc.receipt_seq) as freq,sum(rci.amount) as amount from receipt rc,receipt_item rci  where rc.receipt_seq=rci.receipt_seq" + clause.getConds() + " group by rc.payment_method";
        this.gPaymentMethods = DBUtil.run(sql, clause.getPrepValues());
    }
}

