/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import java.util.ArrayList;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelFormula;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import system.MasterCode;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;

public class ReceiptNameListReport {
    private RecordList gItems;
    ExcelCellFormat WF = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.WF);

    public ReceiptNameListReport(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        this.gItems = this.getItems(start_id, end_id, start_date, end_date);
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4, new int[]{25, 30, 30, 35, 35, 25});
        String range = start_id.isEmpty() ? String.valueOf(Lang.set("Receipt Date: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" To ") + TimeUtil.getStringByDate(end_date) : String.valueOf(Lang.set("Receipt ID: ")) + start_id + Lang.set(" To ") + end_id;
        p.addHeader(Config.getS(Config.churchName), Lang.set("Receipt Name List"), new String[]{range, Lang.set("*Exclude cancelled receipts")});
        int row = p.getRowNumAfterHeader();
        ArrayList codes = MasterCode.getCodes("RECEIPT_SUB_TYPE");
        int i = 0;
        while (i < codes.size()) {
            String code = ArrayUtil.getString("CODE", i, codes);
            String name = ArrayUtil.getString("NAME", i, codes);
            RecordList items = this.gItems.getGroupItems("sub_type", code);
            p.addCell(0, row += 3, Lang.set("Item: " + name), this.WF);
            p.addCell(0, ++row, Lang.set("Date"), p.TL);
            p.addCell(1, row, Lang.set("Name1"), p.TL);
            p.addCell(2, row, Lang.set("Name2"), p.TL);
            p.addCell(3, row, Lang.set("Official Name"), p.TL);
            p.addCell(4, row, Lang.set("From"), p.TL);
            p.addCell(5, row, String.valueOf(Lang.set("Amount(")) + Config.getS(Config.currencyCode) + ")", p.TR);
            int j = 0;
            while (j < items.size()) {
                items.setCurrentRow(j);
                p.addCell(0, ++row, TimeUtil.getStringByDate(items.getT("date")));
                p.addCell(1, row, items.getS("name1"));
                p.addCell(2, row, items.getS("name2"));
                p.addCell(3, row, items.getS("official_name"));
                p.addCell(4, row, items.getS("offer_from"));
                p.addCell(5, row, items.getD("amount"), p.FORMAT_DOUBLE);
                ++j;
            }
            p.addCell(4, ++row, "Total Amount:", p.AR);
            if (items.isEmpty()) {
                p.addCell(5, row, 0, p.BTBD);
            } else {
                p.addCell(5, row, ExcelFormula.sum(5, row - items.size(), 5, row - 1), p.BTBD);
            }
            ++i;
        }
        p.genPrintout();
    }

    private RecordList getItems(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"rc.id>=?", "rc.id<=?", "rc.date>=?", "rc.date<?", "not rc.status=?"}, new Object[]{start_id, end_id, start_date, TimeUtil.adjustDate(end_date, 1), Receipt.STATUS__CL});
        String sql = "select rci.sub_type,rc.date,mb.name1,mb.name2,mb.official_name,rc.offer_from,rci.amount from receipt rc left join member mb on rc.member_seq=mb.member_seq,receipt_item rci where rc.receipt_seq=rci.receipt_seq" + clause.getConds() + " order by rci.sub_type,rc.date,rc.offer_from";
        return DBUtil.run(sql, clause.getPrepValues());
    }
}

