/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.ReceiptMonthlyReport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import member.MemberGroup;
import system.MasterCodeComboBoxCN;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.DateTextField;
import ui.TableLayout;
import util.RecordList;
import util.TimeUtil;
import util.Validation;
import util.WinUtil;

public class ReceiptMonthlyReportDialog
extends DataDialog {
    private DateTextField start_dateDTF;
    private DateTextField end_dateDTF;
    private JButton printB;
    private JButton cancelB;
    private JTextField remarkTF;
    ComboBoxCN sub_typeCN;
    ComboBoxNV member_groupNV;
    JRadioButton receipt_dateRB;
    JRadioButton target_dateRB;
    JCheckBox showZeroCB;

    public ReceiptMonthlyReportDialog(JFrame frame) {
        super(frame, "Receipt Monthly Report", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.remarkTF = new JTextField();
        this.showZeroCB = new JCheckBox("Include members without receipt");
        this.target_dateRB = new JRadioButton("Target Date");
        this.receipt_dateRB = new JRadioButton("Receipt Date");
        this.target_dateRB.setSelected(true);
        ButtonGroup date_typeBG = new ButtonGroup();
        date_typeBG.add(this.target_dateRB);
        date_typeBG.add(this.receipt_dateRB);
        RecordList mg = MemberGroup.getGroupNames(MemberGroup.getAllActiveGroups(-1), "name", "member_group_seq");
        this.member_groupNV = new ComboBoxNV((ArrayList)mg, "name", "member_group_seq", MemberGroup.ROOT_GROUP_SEQ);
        this.member_groupNV.hasNilItem(false);
        this.sub_typeCN = new MasterCodeComboBoxCN("RECEIPT_SUB_TYPE", "");
        TableLayout t = new TableLayout(this, 370, 270, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 80;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30, 30, 30});
        Timestamp d = TimeUtil.getMonthEndDay(TimeUtil.adjustMonth(TimeUtil.adjustDate(TimeUtil.getCurrentDate(), 1), -1));
        this.start_dateDTF = new DateTextField(TimeUtil.getMonthStartDay(d));
        this.end_dateDTF = new DateTextField(d);
        JLabel jLabel = new JLabel("Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDTF, 1, 0, 20, 0);
        JLabel jLabel2 = new JLabel("To");
        t.getClass();
        t.addCell(jLabel2, 1, 0, 110, 0);
        t.getClass();
        t.addCell(this.end_dateDTF, 1, 0, 130, 0);
        t.getClass();
        t.addCell(this.target_dateRB, 1, 1, 20, 0);
        t.getClass();
        t.addCell(this.receipt_dateRB, 1, 1, 130, 0);
        JLabel jLabel3 = new JLabel("Item");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        t.getClass();
        t.addCell(this.sub_typeCN, 1, 2, 20, 0);
        JLabel jLabel4 = new JLabel("Remark");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 3, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, 3, 20, 0, 200, -1);
        JLabel jLabel5 = new JLabel("Group");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 4, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.member_groupNV, 1, 4, 20, 0, 200, -1);
        t.getClass();
        t.addCell(this.showZeroCB, 1, 5, 20, 0);
        t.addYSpace(10);
        int[] nArray2 = new int[3];
        t.getClass();
        nArray2[0] = 0;
        nArray2[1] = 15;
        nArray2[2] = 100;
        t.addTable(nArray2, new int[]{30});
        this.printB = new JButton("Export");
        this.cancelB = new JButton("Cancel");
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.printB, 0, 0, 1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0, 80, -1);
    }

    public void setEventHandler() {
        this.printB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptMonthlyReportDialog.this.onPrint(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptMonthlyReportDialog.this.onCancel(evt);
            }
        });
    }

    public void onPrint(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.start_dateDTF.getText(), "Start Date", "R,D");
        validation.add(this.end_dateDTF.getText(), "End Date", "R,D");
        validation.add(this.sub_typeCN.getSelectedCode(), "Item", "R");
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Running report...");
        ReceiptMonthlyReport p = new ReceiptMonthlyReport(this.start_dateDTF.getDate(), this.end_dateDTF.getDate(), this.remarkTF.getText(), this.sub_typeCN.getSelectedCode(), this.member_groupNV.getSelectedIntValue(), this.receipt_dateRB.isSelected(), this.showZeroCB.isSelected());
        wait_dialog.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

