/*
 * Decompiled with CFR 0.152.
 */
package account;

import database.DBConn;
import database.DBUtil;
import util.RecordList;
import util.RecordListSet;

public class ReceiptItem {
    private int g_Receipt_seq = -1;
    private RecordList g_Items = null;
    public static String RECEIPT_ITEM_SEQ = "receipt_item_seq";
    public static String RECEIPT_SEQ = "receipt_seq";
    public static String TYPE = "type";
    public static String SUB_TYPE = "sub_type";
    public static String TARGET_DATE = "target_date";
    public static String NOTE = "note";
    public static String AMOUNT = "amount";

    public ReceiptItem(int receipt_seq) {
        this.g_Receipt_seq = receipt_seq;
        DBConn conn = new DBConn();
        this.g_Items = ReceiptItem.load(this.g_Receipt_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    private static RecordList load(int receipt_seq, DBConn conn) {
        String sql = "select * from receipt_item where receipt_seq=?";
        return DBUtil.run(sql, receipt_seq, conn);
    }

    public static void update(int receipt_seq, RecordList items, DBConn conn) {
        RecordList old_items = ReceiptItem.load(receipt_seq, conn);
        RecordListSet set = new RecordListSet(old_items, items, new String[]{RECEIPT_ITEM_SEQ});
        RecordList r = set.getLeftOnly();
        int i = 0;
        while (i < r.size()) {
            int seq = r.getI(RECEIPT_ITEM_SEQ, i);
            ReceiptItem.delete(seq, conn);
            ++i;
        }
        r = set.getIntersectOfRight();
        i = 0;
        while (i < r.size()) {
            ReceiptItem.update(r, i, conn);
            ++i;
        }
        r = set.getRightOnly();
        i = 0;
        while (i < r.size()) {
            ReceiptItem.insert(r, receipt_seq, i, conn);
            ++i;
        }
    }

    private static void insert(RecordList items, int receipt_seq, int i, DBConn conn) {
        String sql = "insert into receipt_item( receipt_item_seq,receipt_seq,type,sub_type,target_date,note,amount)values(?,?,?,?,?,?,?)";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{DBUtil.getNextValueFor(RECEIPT_ITEM_SEQ, conn), new Integer(receipt_seq), items.getS(TYPE), items.getS(SUB_TYPE), items.getT(TARGET_DATE), items.getS(NOTE), items.getBigDecimal(AMOUNT)};
        DBUtil.run("insert into receipt_item( receipt_item_seq,receipt_seq,type,sub_type,target_date,note,amount)values(?,?,?,?,?,?,?)", pvs, conn);
    }

    private static void update(RecordList items, int i, DBConn conn) {
        String sql = "update receipt_item set type=?,sub_type=?,target_date=?,note=?,amount=? where receipt_item_seq=?";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{items.getS(TYPE), items.getS(SUB_TYPE), items.getT(TARGET_DATE), items.getS(NOTE), items.getBigDecimal(AMOUNT), items.getInteger(RECEIPT_ITEM_SEQ)};
        DBUtil.run("update receipt_item set type=?,sub_type=?,target_date=?,note=?,amount=? where receipt_item_seq=?", pvs, conn);
    }

    private static void delete(int seq, DBConn conn) {
        String sql = "delete from receipt_item where receipt_item_seq=?";
        DBUtil.run("delete from receipt_item where receipt_item_seq=?", seq, conn);
    }
}

