/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import account.ReceiptPrintout;
import java.sql.Timestamp;
import java.util.ArrayList;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelFormula;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import system.MasterCode;
import system.SystemCode;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class ReceiptDetailReport {
    private RecordList gReceipts;
    private RecordList gReceiptItems;

    public ReceiptDetailReport(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        this.getReceipts(start_id, end_id, start_date, end_date);
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4R, new int[]{24, 22, 40, 22, 22, 22, 20, 16, 18, 25, 18, 35, 22});
        p.setPrintFitWidthToPage(1);
        String range = start_id.isEmpty() ? String.valueOf(Lang.set("Receipt Date: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" to ") + TimeUtil.getStringByDate(end_date) : String.valueOf(Lang.set("Receipt ID: ")) + start_id + Lang.set(" to ") + end_id;
        p.addHeader(Config.getS(Config.churchName), Lang.set("Receipt Detail Report"), new String[]{range, Lang.set("*Exclude cancelled receipts")});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("Receipt ID"), p.TL);
        p.addCell(1, row, Lang.set("Date"), p.TL);
        p.addCell(2, row, Lang.set("Donor"), p.TL);
        p.addCell(3, row, Lang.set("Method"), p.TL);
        p.addCell(4, row, Lang.set("Cheque/Ref#"), p.TL);
        p.addCell(5, row, Lang.set("Remark"), p.TL);
        p.addCell(6, row, Lang.set("Status"), p.TL);
        p.addCell(7, row, Lang.set("Need Receipt"), p.TL);
        p.addCell(8, row, Lang.set("Type"), p.TL);
        p.addCell(9, row, Lang.set("Item"), p.TL);
        p.addCell(10, row, Lang.set("Target"), p.TL);
        p.addCell(11, row, Lang.set("Remark"), p.TL);
        p.addCell(12, row, String.valueOf(Lang.set("Amount(")) + Config.getS(Config.currencyCode) + ")", p.TR);
        int i = 0;
        while (i < this.gReceipts.size()) {
            this.gReceipts.setCurrentRow(i);
            RecordList items = this.gReceiptItems.getGroupItems("receipt_seq", this.gReceipts.getI("receipt_seq"));
            int j = 0;
            while (j < items.size()) {
                ExcelCellFormat strFormat = p.FORMAT_STRING;
                ExcelCellFormat numFormat = p.FORMAT_DOUBLE;
                if (j == items.size() - 1) {
                    strFormat = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BB);
                    numFormat = new ExcelCellFormat(ExcelCellFormat.DOUBLE, ExcelFormat.BB);
                }
                p.addCell(0, ++row, this.gReceipts.getS("id"), strFormat);
                p.addCell(1, row, TimeUtil.getStringByDate(this.gReceipts.getT("date")), strFormat);
                p.addCell(2, row, this.gReceipts.getS("offer_from"), strFormat);
                p.addCell(3, row, this.gReceipts.getS("payment_method"), strFormat);
                p.addCell(4, row, this.gReceipts.getS("cheque_no"), strFormat);
                p.addCell(5, row, this.gReceipts.getS("remark"), strFormat);
                p.addCell(6, row, this.gReceipts.getS("status"), strFormat);
                p.addCell(7, row, this.gReceipts.getS("require_receipt"), strFormat);
                items.setCurrentRow(j);
                p.addCell(8, row, items.getS("type"), strFormat);
                p.addCell(9, row, items.getS("sub_type").trim(), strFormat);
                p.addCell(10, row, TimeUtil.getMonthYearByDate(items.getT("target_date")), strFormat);
                p.addCell(11, row, items.getS("note"), strFormat);
                p.addCell(12, row, items.getD("amount"), numFormat);
                ++j;
            }
            ++i;
        }
        p.addCell(11, ++row, "Total Amount:", p.AR);
        if (this.gReceiptItems.isEmpty()) {
            p.addCell(12, row, 0, p.BTBD);
        } else {
            p.addCell(12, row, ExcelFormula.sum(12, row - this.gReceiptItems.size(), 12, row - 1), p.BTBD);
        }
        p.addCell(11, ++row, "Total Receipts:", p.AR);
        p.addCell(12, row, this.gReceipts.size());
        p.genPrintout();
    }

    private void getReceipts(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        this.gReceipts = ReceiptPrintout.getReceipts(start_id, end_id, start_date, end_date, true, true);
        ArrayList payment_methods = MasterCode.getCodes("PAYMENT_METHOD");
        int i = 0;
        while (i < this.gReceipts.size()) {
            this.gReceipts.setCurrentRow(i);
            this.gReceipts.setS("status", Tools.getStatusName(Receipt.STATUS_MAP, this.gReceipts.getS("status")));
            this.gReceipts.setS("email_status", Tools.getStatusName(Receipt.EMAIL_STATUS_MAP, this.gReceipts.getS("email_status")));
            int k = ArrayUtil.indexOf("code", this.gReceipts.getS("payment_method"), payment_methods);
            this.gReceipts.setS("payment_method", k != -1 ? ArrayUtil.getString("name", k, payment_methods) : "");
            this.gReceipts.setS("require_receipt", SystemCode.getYN(this.gReceipts.getS("require_receipt")));
            ++i;
        }
        ArrayList sub_types = MasterCode.getCodes("RECEIPT_SUB_TYPE");
        this.gReceiptItems = ReceiptPrintout.getReceiptItems(start_id, end_id, start_date, end_date);
        int i2 = 0;
        while (i2 < this.gReceiptItems.size()) {
            this.gReceiptItems.setCurrentRow(i2);
            this.gReceiptItems.setS("type", Tools.getStatusName(Receipt.TYPE_MAP, this.gReceiptItems.getS("type")));
            int k = ArrayUtil.indexOf("code", this.gReceiptItems.getS("sub_type"), sub_types);
            this.gReceiptItems.setS("sub_type", k != -1 ? ArrayUtil.getString("name", k, sub_types) : "");
            ++i2;
        }
    }
}

