/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.AccountBalance;
import account.AccountMonth;
import database.DBConn;
import database.DBUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import util.Arith;
import util.ArrayUtil;
import util.RecordList;

public class AccountYear {
    private int g_Ac_year_seq = -1;
    private String g_Name = "";
    private int g_Plr_ac_seq = -1;
    private String g_Lock = "N";

    public AccountYear() {
    }

    public AccountYear(int ac_year_seq) {
        this.g_Ac_year_seq = ac_year_seq;
        this.load();
    }

    public int getAc_year_seq() {
        return this.g_Ac_year_seq;
    }

    public String getName() {
        return this.g_Name;
    }

    public int getPlr_ac_seq() {
        return this.g_Plr_ac_seq;
    }

    public String getLock() {
        return this.g_Lock;
    }

    private void load() {
        String sql = "select NAME,PLR_AC_SEQ,LOCK from ac_year where AC_YEAR_SEQ=?";
        RecordList v = DBUtil.select(new String[]{"NAME", "PLR_AC_SEQ", "LOCK"}, new int[]{12, 4, 12}, new Object[]{new Integer(this.g_Ac_year_seq)}, new int[]{4}, sql);
        if (!v.isEmpty()) {
            this.g_Name = ArrayUtil.getString("NAME", 0, v);
            this.g_Plr_ac_seq = ArrayUtil.getInt("PLR_AC_SEQ", 0, v);
            this.g_Lock = ArrayUtil.getString("LOCK", 0, v);
        }
    }

    public static int insert(String name, Timestamp start_date1, Timestamp start_date2, int ac_month_seq2, int plr_ac_seq) {
        String sql = "insert into ac_year( AC_YEAR_SEQ,NAME,PLR_AC_SEQ,LOCK)values(?,?,?,?)";
        DBConn conn = new DBConn();
        int ac_year_seq = DBUtil.getNextValueFor("ac_year_seq", conn);
        DBUtil.update(new Object[]{new Integer(ac_year_seq), name, new Integer(plr_ac_seq), "N"}, new int[]{4, 12, 4, 12}, sql, conn);
        AccountYear.post(ac_year_seq, start_date1, start_date2, ac_month_seq2, plr_ac_seq, conn);
        conn.commit();
        return conn.isSuccessful() ? ac_year_seq : -1;
    }

    public static int update(int ac_year_seq, String name, Timestamp start_date1, Timestamp start_date2, int ac_month_seq2, int plr_ac_seq) {
        String sql = "update ac_year set NAME=?,PLR_AC_SEQ=? where AC_YEAR_SEQ=?";
        DBConn conn = new DBConn();
        DBUtil.update(new Object[]{name, new Integer(plr_ac_seq), new Integer(ac_year_seq)}, new int[]{12, 4, 4}, sql, conn);
        AccountYear.post(ac_year_seq, start_date1, start_date2, ac_month_seq2, plr_ac_seq, conn);
        conn.commit();
        return conn.isSuccessful() ? ac_year_seq : -1;
    }

    private static void post(int ac_year_seq, Timestamp start_date1, Timestamp start_date2, int ac_month_seq2, int plr_ac_seq, DBConn conn) {
        AccountBalance.unadjust(ac_month_seq2, conn);
        AccountMonth.postAcYearSeq(ac_year_seq, start_date1, start_date2, conn);
        ArrayList pl_balances = AccountBalance.getProfitAndLossBalances(start_date1, start_date2, conn);
        double ttl_debit = 0.0;
        double ttl_credit = 0.0;
        int i = 0;
        while (i < pl_balances.size()) {
            int ac_seq = ArrayUtil.getInt("AC_SEQ", i, pl_balances);
            double debit = ArrayUtil.getDouble("DEBIT", i, pl_balances);
            double credit = ArrayUtil.getDouble("CREDIT", i, pl_balances);
            ttl_debit = Arith.add(ttl_debit, debit);
            ttl_credit = Arith.add(ttl_credit, credit);
            AccountBalance.updateAdjust(ac_month_seq2, ac_seq, Arith.mul(debit, -1.0), Arith.mul(credit, -1.0), conn);
            ++i;
        }
        if (!AccountBalance.exist(ac_month_seq2, plr_ac_seq, conn)) {
            AccountBalance.insert(ac_month_seq2, plr_ac_seq, 0.0, 0.0, ttl_debit, ttl_credit, conn);
        } else {
            AccountBalance.updateAdjust(ac_month_seq2, plr_ac_seq, ttl_debit, ttl_credit, conn);
        }
    }

    public static int unpost(int ac_year_seq, int ac_month_seq2) {
        DBConn conn = new DBConn();
        String sql = "delete from ac_year where ac_year_seq=?";
        DBUtil.update(new Object[]{new Integer(ac_year_seq)}, new int[]{4}, sql, conn);
        AccountMonth.unpostAcYearSeq(ac_year_seq, conn);
        AccountBalance.unadjust(ac_month_seq2, conn);
        conn.commit();
        return conn.isSuccessful() ? 1 : -1;
    }

    public static int lock(int ac_year_seq, String lock) {
        DBConn conn = new DBConn();
        String sql = "update ac_year set lock=? where ac_year_seq=?";
        DBUtil.update(new Object[]{lock, new Integer(ac_year_seq)}, new int[]{12, 4}, sql, conn);
        conn.commit();
        return conn.isSuccessful() ? 1 : -1;
    }

    public static boolean isPosted(Timestamp start_date1, Timestamp start_date2) {
        String sql = "select ac_year_seq from  ac_month where start_date>=? and start_date<=? and ac_year_seq<>-1";
        RecordList v = DBUtil.select(new String[]{"AC_YEAR_SEQ"}, new int[]{12}, new Object[]{start_date1, start_date2}, new int[]{93, 93}, "select ac_year_seq from  ac_month where start_date>=? and start_date<=? and ac_year_seq<>-1");
        return !v.isEmpty();
    }

    public static String checkPostConsistence(Timestamp start_date1, Timestamp start_date2) {
        String MSG__OVERLAPPED = "Selected Months with more than 1 yearly postings";
        String MSG__PARTIAL = "Some months of the same yearly post are not selected";
        String MSG__BROKEN = "Some months before the selection are not posted";
        String sql = "select distinct ac_year_seq from  ac_month where start_date>=? and start_date<=?";
        RecordList v = DBUtil.select(new String[]{"AC_YEAR_SEQ"}, new int[]{4}, new Object[]{start_date1, start_date2}, new int[]{93, 93}, sql);
        if (v.size() > 1) {
            return MSG__OVERLAPPED;
        }
        sql = "select distinct ac_year_seq from  ac_month where (start_date<? or start_date>?) and ac_year_seq=? and ac_year_seq<>-1";
        RecordList u = DBUtil.select(new String[]{"AC_YEAR_SEQ"}, new int[]{4}, new Object[]{start_date1, start_date2, new Integer(ArrayUtil.getInt("AC_YEAR_SEQ", 0, v))}, new int[]{93, 93, 4}, sql);
        if (!u.isEmpty()) {
            return MSG__PARTIAL;
        }
        sql = "select 'x' as TMP from  ac_month where start_date<? and ac_year_seq=-1";
        RecordList w = DBUtil.run(sql, start_date1);
        if (!w.isEmpty()) {
            return MSG__BROKEN;
        }
        return "";
    }

    public static int getMonth_posted_ac_year_seq(Timestamp start_date1, Timestamp start_date2) {
        String sql = "select distinct ac_year_seq from  ac_month where start_date>=? and start_date<=?";
        RecordList v = DBUtil.select(new String[]{"AC_YEAR_SEQ"}, new int[]{4}, new Object[]{start_date1, start_date2}, new int[]{93, 93}, "select distinct ac_year_seq from  ac_month where start_date>=? and start_date<=?");
        return ArrayUtil.getInt("AC_YEAR_SEQ", 0, v);
    }

    public static ArrayList getYearInfo(int ac_year_seq) {
        String sql = "select ac_month_seq,start_date from ac_month where ac_year_seq=? order by start_date";
        return DBUtil.select(new String[]{"AC_MONTH_SEQ", "START_DATE"}, new int[]{4, 93}, new Object[]{new Integer(ac_year_seq)}, new int[]{4}, "select ac_month_seq,start_date from ac_month where ac_year_seq=? order by start_date");
    }
}

