/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.AccountMonth;
import account.AccountPostingListDialog;
import account.AccountYear;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import ui.DataDialog;
import ui.TableLayout;
import util.ArrayUtil;
import util.TimeUtil;
import util.WinUtil;

public class AccountMonthPostingDialog
extends DataDialog {
    JButton saveB;
    JButton cancelB;
    private AccountMonth g_AccountMonth = null;
    private boolean g_isUpdate = false;

    public AccountMonthPostingDialog(DataDialog f, int ac_month_seq) {
        super(f, "Monthly Posting", false);
        this.g_AccountMonth = new AccountMonth(ac_month_seq);
        if (ac_month_seq != -1) {
            this.g_isUpdate = true;
        } else {
            Timestamp start_date = AccountMonth.getNextMonthStartDate();
            this.g_AccountMonth.setStart_date(start_date);
            this.g_AccountMonth.setEnd_date(TimeUtil.adjustDate(TimeUtil.adjustMonth(start_date, 1), -1));
        }
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.saveB = new JButton("Post");
        this.cancelB = new JButton("Cancel");
        boolean locked = new AccountYear(this.g_AccountMonth.getAc_year_seq()).getLock().equals("Y");
        String msg = "";
        if (locked) {
            this.saveB.setEnabled(false);
            msg = "This month is locked and is not allow to post.";
        }
        TableLayout t = new TableLayout(this, 350, 150, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 80;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30, 30});
        JLabel jLabel = new JLabel("Period");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel(String.valueOf(TimeUtil.getStringByDate(this.g_AccountMonth.getStart_date())) + " to " + TimeUtil.getStringByDate(this.g_AccountMonth.getEnd_date()));
        t.getClass();
        t.addCell(jLabel2, 1, 0, 20, 0);
        JLabel jLabel3 = new JLabel(msg);
        t.getClass();
        t.addCell(jLabel3, 1, 1, 20, 0);
        t.addYSpace(10);
        t.addTable(new int[]{250, 15, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    void setEventHandler() {
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountMonthPostingDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountMonthPostingDialog.this.onCancel(evt);
            }
        });
    }

    void onSave(ActionEvent evt) {
        if (this.g_AccountMonth.getAc_year_seq() != -1 && !WinUtil.getConfirm(this, "This month is included in a year end. After monthly post, the system will process the yearly posting automatically.")) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        if (this.g_isUpdate) {
            AccountMonth.update(this.g_AccountMonth.getAc_month_seq());
        } else {
            AccountMonth.insert(this.g_AccountMonth.getStart_date(), this.g_AccountMonth.getEnd_date());
        }
        if (this.g_AccountMonth.getAc_year_seq() != -1) {
            AccountYear ac_year = new AccountYear(this.g_AccountMonth.getAc_year_seq());
            ArrayList months = AccountYear.getYearInfo(ac_year.getAc_year_seq());
            AccountYear.update(ac_year.getAc_year_seq(), ac_year.getName(), ArrayUtil.getTimestamp("START_DATE", 0, months), ArrayUtil.getTimestamp("START_DATE", months.size() - 1, months), ArrayUtil.getInt("AC_MONTH_SEQ", months.size() - 1, months), ac_year.getPlr_ac_seq());
        }
        wait_dialog.dispose();
        this.dispose();
        ((AccountPostingListDialog)this.getParent()).onSearch(null);
    }

    void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

