/*
 * Decompiled with CFR 0.152.
 */
package system;

import database.DBConn;
import database.DBUtil;
import java.util.ArrayList;
import util.ArrayListSet;
import util.ArrayUtil;
import util.RecordList;

public class MasterCode {
    private String g_Code_group = "";
    private ArrayList g_Codes = null;
    public static String CODE = "code";
    public static String CODE_GROUP = "code_group";
    public static String NAME = "name";
    public static String DISPLAY_ORDER = "display_order";
    public static String DEFAULT_ITEM = "default_item";
    public static String STATUS = "status";

    public MasterCode() {
    }

    public MasterCode(String code_group) {
        this.g_Code_group = code_group;
        DBConn conn = new DBConn();
        this.g_Codes = MasterCode.load(this.g_Code_group, conn);
        conn.commit();
    }

    public ArrayList getCodes() {
        return this.g_Codes;
    }

    private static ArrayList load(String code_group, DBConn conn) {
        String sql = "select CODE,CODE_GROUP,NAME,DISPLAY_ORDER,DEFAULT_ITEM,STATUS from master_code where CODE_GROUP=? order by DISPLAY_ORDER,NAME";
        return DBUtil.select(new String[]{"CODE", "CODE_GROUP", "NAME", "DISPLAY_ORDER", "DEFAULT_ITEM", "STATUS"}, new int[]{12, 12, 12, 4, 12, 12}, new Object[]{code_group}, new int[]{12}, sql, conn);
    }

    public static int update(String code_group, ArrayList codes) {
        DBConn conn = new DBConn();
        ArrayList old_codes = MasterCode.load(code_group, conn);
        ArrayListSet set = new ArrayListSet(old_codes, codes, new String[]{"CODE"});
        ArrayList v = set.getLeftOnly();
        int i = 0;
        while (i < v.size()) {
            String code = ArrayUtil.getString("CODE", i, v);
            MasterCode.delete(code, conn);
            ++i;
        }
        v = set.getIntersectOfRight();
        i = 0;
        while (i < v.size()) {
            MasterCode.update(ArrayUtil.getString("CODE", i, v), ArrayUtil.getString("NAME", i, v), ArrayUtil.getInt("DISPLAY_ORDER", i, v), ArrayUtil.getString("DEFAULT_ITEM", i, v), ArrayUtil.getString("STATUS", i, v), conn);
            ++i;
        }
        v = set.getRightOnly();
        i = 0;
        while (i < v.size()) {
            MasterCode.insert(code_group, ArrayUtil.getString("NAME", i, v), ArrayUtil.getInt("DISPLAY_ORDER", i, v), ArrayUtil.getString("DEFAULT_ITEM", i, v), ArrayUtil.getString("STATUS", i, v), conn);
            ++i;
        }
        conn.commit();
        return conn.isSuccessful() ? 1 : -1;
    }

    private static void insert(String code_group, String name, int display_order, String default_item, String status, DBConn conn) {
        String sql = "insert into master_code( CODE,CODE_GROUP,NAME,DISPLAY_ORDER,DEFAULT_ITEM,STATUS)values(?,?,?,?,?,?)";
        String code = String.valueOf(DBUtil.getNextValueFor("master_code_seq", conn));
        DBUtil.update(new Object[]{code, code_group, name, new Integer(display_order), default_item, status}, new int[]{12, 12, 12, 4, 12, 12}, sql, conn);
    }

    private static void update(String code, String name, int display_order, String default_item, String status, DBConn conn) {
        String sql = "update master_code set NAME=?,DISPLAY_ORDER=?,DEFAULT_ITEM=?,STATUS=? where CODE=?";
        DBUtil.update(new Object[]{name, new Integer(display_order), default_item, status, code}, new int[]{12, 4, 12, 12, 12}, sql, conn);
    }

    private static void delete(String code, DBConn conn) {
        String sql = "delete from master_code where CODE=?";
        DBUtil.update(new Object[]{code}, new int[]{12}, sql, conn);
    }

    public static String getName(String code) {
        String sql = "select NAME from master_code where CODE=?";
        RecordList v = DBUtil.select(new String[]{"NAME"}, new int[]{12}, new Object[]{code}, new int[]{12}, sql);
        return !v.isEmpty() ? ArrayUtil.getString("NAME", 0, v) : "";
    }

    public static String getGroupDefaultItem(String group) {
        String sql = "select CODE from master_code where CODE_GROUP=? and DEFAULT_ITEM='Y'";
        RecordList v = DBUtil.select(new String[]{"CODE"}, new int[]{12}, new Object[]{group}, new int[]{12}, sql);
        return !v.isEmpty() ? ArrayUtil.getString("CODE", 0, v) : "";
    }

    public static ArrayList getCodes(String group) {
        String sql = "select CODE,NAME,SUB_CODE,DEFAULT_ITEM from master_code where CODE_GROUP=? and STATUS='A' order by DISPLAY_ORDER,NAME";
        return DBUtil.select(new String[]{"CODE", "NAME", "SUB_CODE", "DEFAULT_ITEM"}, new int[]{12, 12, 12, 12}, new Object[]{group}, new int[]{12}, sql);
    }

    public static int getMaxDisplaySeq(String group) {
        String sql = "select coalesce(max(display_order),0) as i from master_code where code_group=?";
        RecordList r = DBUtil.run("select coalesce(max(display_order),0) as i from master_code where code_group=?", group);
        return r.getI("i", 0);
    }
}

