/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.VouTemplate;
import account.VouTemplateItem;
import account.Voucher;
import account.VoucherItem;
import account.VoucherListDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import system.Config;
import system.MasterCode;
import system.SystemCode;
import system.User;
import ui.AutoComboBoxNV;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.DateTextField;
import ui.ScrollList2;
import ui.TableLayout;
import util.ArrayUtil;
import util.ComparableHashMap;
import util.RecordList;
import util.TimeUtil;
import util.Tools;
import util.Validation;
import util.WinUtil;

public class VoucherInfoDialog
extends DataDialog {
    private JTextField idTF;
    private DateTextField dateDT;
    private JTextField ttl_debitTF;
    private JTextField ttl_creditTF;
    private ComboBoxCN statusCN;
    private ComboBoxCN id_prefixCN;
    private ComboBoxNV templateNV;
    private AutoComboBoxNV add_ac_idNV;
    private JButton use_templateB;
    private JButton add_itemB;
    private JButton del_itemB;
    private JButton saveB;
    private JButton nextB;
    private JButton cancelB;
    private ScrollList2 itemSL;
    private Voucher g_Voucher = null;
    private RecordList g_Items;
    private boolean g_isUpdate = false;
    private String g_Id_prefix_code = "";

    public VoucherInfoDialog(DataDialog f, int ac_doc_seq, boolean isUpdate) {
        super(f, "\u65b0\u589e\u50b3\u7968", false);
        if (isUpdate) {
            this.setTitle("\u4fee\u6539\u50b3\u7968");
        }
        this.g_isUpdate = isUpdate;
        this.init(ac_doc_seq);
    }

    private void init(int ac_doc_seq) {
        this.g_Voucher = new Voucher(ac_doc_seq);
        VoucherItem p = new VoucherItem(ac_doc_seq);
        this.g_Items = p.getItems();
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        String id = "";
        if (!this.g_isUpdate) {
            this.g_Id_prefix_code = MasterCode.getGroupDefaultItem("VOUCHER_ID_PREFIX");
            if (!this.g_Id_prefix_code.equals("")) {
                id = Tools.getNextID(String.valueOf(MasterCode.getName(this.g_Id_prefix_code)) + Config.getS(Config.voucherIdFormat), "voucher", "id");
            }
        } else {
            id = this.g_Voucher.getId();
        }
        this.idTF = new JTextField(id);
        Timestamp date = this.g_Voucher.getDate();
        date = date == null ? TimeUtil.getCurrentDate() : date;
        this.dateDT = new DateTextField(date);
        this.statusCN = this.getStatusSel();
        this.id_prefixCN = new ComboBoxCN(MasterCode.getCodes("VOUCHER_ID_PREFIX"), this.g_Id_prefix_code);
        this.add_ac_idNV = new AutoComboBoxNV(this.g_Voucher.getAllChildAccounts(), "name", "ac_seq", -1);
        this.templateNV = new ComboBoxNV((ArrayList)VouTemplate.getActiveTemplate(), "id", "vou_template_seq", -1);
        this.use_templateB = new JButton("\u4f7f\u7528\u7bc4\u672c");
        this.add_itemB = new JButton("\u52a0\u5165\u9805\u76ee");
        this.del_itemB = new JButton("\u522a\u9664\u9805\u76ee");
        this.saveB = new JButton("\u78ba\u5b9a");
        this.nextB = new JButton("\u4e0b\u4e00\u5f35");
        this.cancelB = new JButton("\u53d6\u6d88");
        this.saveB.setEnabled(User.hasPrivilege("voucherModify"));
        TableLayout t = new TableLayout(this, 700, 520, 5, 10);
        int[] nArray = new int[6];
        nArray[0] = 80;
        nArray[1] = 180;
        nArray[2] = 80;
        nArray[3] = 160;
        nArray[4] = 80;
        t.getClass();
        nArray[5] = 0;
        t.addTable(nArray, new int[]{30, 30, 15, 30});
        JLabel jLabel = new JLabel("\u50b3\u7968\u7de8\u865f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.idTF, 1, 0, 20, 0, 150, -1);
        if (!this.g_isUpdate) {
            JLabel jLabel2 = new JLabel("\u7de8\u865f\u958b\u9996");
            t.getClass();
            t.getClass();
            t.addCell(jLabel2, 2, 0, 1, 0);
            t.getClass();
            t.addCell(this.id_prefixCN, 3, 0, 20, 0);
        }
        JLabel jLabel3 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 4, 0, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 5, 0, 20, 0);
        JLabel jLabel4 = new JLabel("\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.dateDT, 1, 1, 20, 0);
        JLabel jLabel5 = new JLabel("\u7bc4\u672c");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 2, 1, 1, 0);
        t.getClass();
        t.addCell(this.templateNV, 3, 1, 20, 0);
        int n = (int)this.templateNV.getSize().getWidth() + 30;
        t.getClass();
        t.addCell(this.use_templateB, 3, 1, n, 0);
        JLabel jLabel6 = new JLabel("\u52a0\u5165\u5e33\u6236");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 0, 3, 1, 0);
        t.getClass();
        t.addCell(this.add_ac_idNV, 1, 3, 20, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.add_itemB, 4, 3, 1, 0);
        t.getClass();
        t.addCell(this.del_itemB, 5, 3, 10, 0);
        this.itemSL = new ScrollList2(660, 295, this.g_Items, new int[]{185, 190, 80, 60, 60}, new String[]{"\u5e33\u6236", "\u6458\u8981", "\u652f\u7968\u865f\u78bc", "\u501f\u65b9", "\u8cb8\u65b9"}, new String[]{VoucherItem.AC_SEQ, VoucherItem.REMARK, VoucherItem.CHEQUE_NO, VoucherItem.DEBIT, VoucherItem.CREDIT}, new boolean[]{true, true, true, true, true});
        this.itemSL.setBigDecimalTextFieldColumn(VoucherItem.DEBIT, "0.00");
        this.itemSL.setBigDecimalTextFieldColumn(VoucherItem.CREDIT, "0.00");
        this.itemSL.setEditing_mode(true);
        ComboBoxNV item_acENV = new ComboBoxNV(this.g_Voucher.getAllChildAccounts(), "name", "ac_seq", -1);
        this.itemSL.setComboxNVColumn("ac_seq", item_acENV);
        this.ttl_debitTF = new JTextField(String.valueOf(this.g_Items.getColumnSum(VoucherItem.DEBIT)));
        this.ttl_debitTF.setEditable(false);
        this.ttl_debitTF.setHorizontalAlignment(4);
        this.ttl_creditTF = new JTextField(String.valueOf(this.g_Items.getColumnSum(VoucherItem.CREDIT)));
        this.ttl_creditTF.setEditable(false);
        this.ttl_creditTF.setHorizontalAlignment(4);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{300});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, -1, -1);
        t.addTable(new int[]{485, 100, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.ttl_debitTF, 1, 0, 1, 0, 75, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.ttl_creditTF, 2, 0, 1, 0, 75, -1);
        t.addYSpace(5);
        t.addTable(new int[]{525, 80, 80}, new int[]{30});
        if (this.g_isUpdate) {
            t.getClass();
            t.addCell(this.saveB, 1, 0, 15, 0);
        } else {
            t.getClass();
            t.getClass();
            t.addCell(this.saveB, 0, 0, 1, 0);
            t.getClass();
            t.addCell(this.nextB, 1, 0, 15, 0);
            this.onAddItem(null);
            this.onAddItem(null);
        }
        t.getClass();
        t.addCell(this.cancelB, 2, 0, 10, 0);
    }

    public ComboBoxCN getStatusSel() {
        String[][] status;
        String cur_status = this.g_Voucher.getStatus();
        if (this.g_Voucher.getStatus().equals("")) {
            status = new String[][]{Tools.getStatusItem(Voucher.STATUS_MAP, Voucher.STATUS__IP), Tools.getStatusItem(Voucher.STATUS_MAP, Voucher.STATUS__CP)};
            cur_status = Voucher.STATUS__CP;
        } else {
            status = this.g_Voucher.getStatus().equals(Voucher.STATUS__IP) ? new String[][]{Tools.getStatusItem(Voucher.STATUS_MAP, Voucher.STATUS__IP), Tools.getStatusItem(Voucher.STATUS_MAP, Voucher.STATUS__CP), Tools.getStatusItem(Voucher.STATUS_MAP, Voucher.STATUS__CL)} : (this.g_Voucher.getStatus().equals(Voucher.STATUS__CP) ? new String[][]{Tools.getStatusItem(Voucher.STATUS_MAP, Voucher.STATUS__CP), Tools.getStatusItem(Voucher.STATUS_MAP, Voucher.STATUS__CL)} : new String[][]{Tools.getStatusItem(Voucher.STATUS_MAP, Voucher.STATUS__CL)});
        }
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(status), cur_status);
        c.hasNilItem(false);
        return c;
    }

    private void setEventHandler() {
        this.id_prefixCN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherInfoDialog.this.onChangeIDPrefix(evt);
            }
        });
        this.use_templateB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherInfoDialog.this.onUseTemplate(evt);
            }
        });
        this.add_ac_idNV.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    VoucherInfoDialog.this.onAddItem(null);
                }
            }
        });
        this.add_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherInfoDialog.this.onAddItem(evt);
            }
        });
        this.del_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherInfoDialog.this.onDelItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherInfoDialog.this.onSave(evt);
            }
        });
        this.nextB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherInfoDialog.this.onNext(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherInfoDialog.this.onCancel(evt);
            }
        });
        this.itemSL.addActionListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                VoucherInfoDialog.this.onTableChanged(e);
            }
        });
    }

    private void onChangeIDPrefix(ActionEvent evt) {
        this.g_Id_prefix_code = this.id_prefixCN.getSelectedCode();
        String id = "";
        if (!this.g_Id_prefix_code.equals("")) {
            id = Tools.getNextID(String.valueOf(MasterCode.getName(this.g_Id_prefix_code)) + Config.getS(Config.voucherIdFormat), "voucher", "id");
        }
        this.idTF.setText(id);
    }

    private void onUseTemplate(ActionEvent evt) {
        if (this.templateNV.getSelectedIndex() > 0) {
            int vou_template_seq = this.templateNV.getSelectedIntValue();
            VouTemplateItem p = new VouTemplateItem(vou_template_seq);
            RecordList items = p.getItems();
            RecordList r = this.itemSL.getTableData();
            r.clear();
            int i = 0;
            while (i < items.size()) {
                ComparableHashMap h = new ComparableHashMap();
                items.setCurrentRow(i);
                h.put(VoucherItem.AC_ITEM_SEQ, new Integer(-1));
                h.put(VoucherItem.AC_SEQ, new Integer(items.getI(VouTemplateItem.AC_SEQ)));
                h.put(VoucherItem.DEBIT, new BigDecimal(items.getD(VouTemplateItem.DEBIT)));
                h.put(VoucherItem.CREDIT, new BigDecimal(items.getD(VouTemplateItem.CREDIT)));
                h.put(VoucherItem.CHEQUE_NO, items.getS(VouTemplateItem.CHEQUE_NO));
                h.put(VoucherItem.REMARK, items.getS(VouTemplateItem.REMARK));
                r.add(h);
                ++i;
            }
            this.itemSL.fireDataChanged();
            this.calTotal();
        }
    }

    private void onAddItem(ActionEvent evt) {
        ArrayList acs = this.add_ac_idNV.getItems();
        int ac_seq = ArrayUtil.getInt("AC_SEQ", this.add_ac_idNV.getSelectedIndex(), acs);
        RecordList r = this.itemSL.getTableData();
        String last_remark = "";
        if (!r.isEmpty()) {
            last_remark = r.getS(VoucherItem.REMARK, r.size() - 1);
        }
        ComparableHashMap h = new ComparableHashMap();
        h.put(VoucherItem.AC_ITEM_SEQ, new Integer(-1));
        h.put(VoucherItem.AC_SEQ, new Integer(ac_seq));
        h.put(VoucherItem.DEBIT, new BigDecimal(0));
        h.put(VoucherItem.CREDIT, new BigDecimal(0));
        h.put(VoucherItem.CHEQUE_NO, "");
        h.put(VoucherItem.REMARK, last_remark);
        r.add(h);
        this.itemSL.fireDataChanged();
    }

    private void onDelItem(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        this.itemSL.getTableData().remove(sel_row);
        this.itemSL.fireDataChanged();
        this.calTotal();
    }

    private void onTableChanged(TableModelEvent e) {
        if (this.itemSL.getChangedColName(e).equals(VoucherItem.DEBIT)) {
            this.itemSL.getTableData().setD(VouTemplateItem.CREDIT, 0.0, e.getFirstRow());
            this.calTotal();
        } else if (this.itemSL.getChangedColName(e).equals(VoucherItem.CREDIT)) {
            this.itemSL.getTableData().setD(VouTemplateItem.DEBIT, 0.0, e.getFirstRow());
            this.calTotal();
        }
    }

    private void calTotal() {
        this.ttl_debitTF.setText(String.valueOf(this.itemSL.getTableData().getColumnSum(VoucherItem.DEBIT)));
        this.ttl_creditTF.setText(String.valueOf(this.itemSL.getTableData().getColumnSum(VoucherItem.CREDIT)));
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.idTF.getText(), "\u50b3\u7968\u7de8\u865f", "R");
        validation.add(this.dateDT.getInput(), "\u65e5\u671f", "R,D");
        validation.add(!Voucher.existID(this.idTF.getText(), this.g_Voucher.getAc_doc_seq()), "\u6b64\u50b3\u7968\u7de8\u865f\u5df2\u7d93\u5b58\u5728,\u8acb\u4f7f\u7528\u53e6\u4e00\u7de8\u865f", "RT");
        validation.add(!this.g_Voucher.getStatus().equals(Voucher.STATUS__CP) || !this.statusCN.getSelectedCode().equals(Voucher.STATUS__CP) || !Config.getS(Config.voucherAllowModify).equals(SystemCode.YN__N), "\u5df2\u78ba\u5b9a\u7684\u50b3\u7968\u4e0d\u53ef\u4fee\u6539,\u53ea\u53ef\u53d6\u6d88", "RT");
        RecordList items = this.itemSL.getTableData();
        validation.add(items.size(), "\u50b3\u7968\u9805\u76ee", "GTZ");
        int i = 0;
        while (i < items.size()) {
            items.setCurrentRow(i);
            int ac_seq = items.getI(VoucherItem.AC_SEQ);
            double debit = items.getD(VoucherItem.DEBIT);
            double credit = items.getD(VoucherItem.CREDIT);
            validation.add(ac_seq, "\u7b2c" + (i + 1) + "\u9805\u7684\u6240\u5c6c\u5e33\u76ee", "CBNVIR");
            validation.add(debit, "\u7b2c" + (i + 1) + "\u9805\u7684\u501f\u65b9\u91d1\u984d", "F");
            validation.add(credit, "\u7b2c" + (i + 1) + "\u9805\u7684\u8cb8\u65b9\u91d1\u984d", "F");
            validation.add(debit + credit, "\u7b2c" + (i + 1) + "\u9805\u7684\u501f\u65b9/\u8cb8\u65b9\u91d1\u984d", "F,GTZ");
            ++i;
        }
        double ttl_debit = Double.parseDouble(this.ttl_debitTF.getText());
        double ttl_credit = Double.parseDouble(this.ttl_creditTF.getText());
        validation.add(ttl_debit - ttl_credit, "\u501f\u65b9\u53ca\u8cb8\u65b9\u7684\u7e3d\u984d", "EQ");
        if (!validation.isValid()) {
            return false;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        if (this.g_isUpdate) {
            Voucher.update(this.g_Voucher.getAc_doc_seq(), this.idTF.getText(), this.dateDT.getDate(), this.statusCN.getSelectedCode(), items);
        } else {
            Voucher.insert(this.idTF.getText(), this.dateDT.getDate(), this.statusCN.getSelectedCode(), items);
        }
        ((VoucherListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onNext(ActionEvent evt) {
        boolean successful = this.onSave(evt);
        if (successful) {
            RecordList items = this.itemSL.getTableData();
            items.clear();
            this.onAddItem(null);
            this.onAddItem(null);
            if (!this.g_Id_prefix_code.equals("")) {
                this.idTF.setText(Tools.getNextID(String.valueOf(MasterCode.getName(this.g_Id_prefix_code)) + Config.getS(Config.voucherIdFormat), "voucher", "id"));
            }
            this.setVisible(true);
        }
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

