/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.wmf.InputMeta;
import com.lowagie.text.pdf.wmf.MetaDo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImgWMF
extends Image
implements Element {
    ImgWMF(Image image) {
        super(image);
    }

    public ImgWMF(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    public ImgWMF(String filename) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename));
    }

    public ImgWMF(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.originalData = img;
        this.processParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        block6: {
            this.type = 35;
            this.originalType = 6;
            InputStream is = null;
            try {
                String errorID;
                if (this.rawData == null) {
                    is = this.url.openStream();
                    errorID = this.url.toString();
                } else {
                    is = new ByteArrayInputStream(this.rawData);
                    errorID = "Byte array";
                }
                InputMeta in = new InputMeta(is);
                if (in.readInt() != -1698247209) {
                    throw new BadElementException(errorID + " is not a valid placeable windows metafile.");
                }
                in.readWord();
                int left = in.readShort();
                int top = in.readShort();
                int right = in.readShort();
                int bottom = in.readShort();
                int inch = in.readWord();
                this.dpiX = 72;
                this.dpiY = 72;
                this.scaledHeight = (float)(bottom - top) / (float)inch * 72.0f;
                this.setTop(this.scaledHeight);
                this.scaledWidth = (float)(right - left) / (float)inch * 72.0f;
                this.setRight(this.scaledWidth);
                Object var10_9 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (is != null) {
                    is.close();
                }
                this.plainWidth = this.width();
                this.plainHeight = this.height();
                throw throwable;
            }
            is.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readWMF(PdfTemplate template) throws IOException, DocumentException {
        this.setTemplateData(template);
        template.setWidth(this.width());
        template.setHeight(this.height());
        InputStream is = null;
        try {
            is = this.rawData == null ? this.url.openStream() : new ByteArrayInputStream(this.rawData);
            MetaDo meta = new MetaDo(is, template);
            meta.readAll();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

