/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import system.Lang;
import ui.DataDialog;
import util.RecordList;

public class ListDialog
extends DataDialog {
    private int g_Width;
    private int g_Height;
    private RecordList g_ResizeComps;
    private RecordList g_RelocateComps;

    public ListDialog() {
    }

    public ListDialog(ListDialog f, String title, boolean modal) {
        super(f, Lang.set(title), modal);
        this.initComponents();
    }

    public ListDialog(JFrame f, String title, boolean modal) {
        super(f, Lang.set(title), modal);
        this.initComponents();
    }

    private void initComponents() {
        this.g_ResizeComps = new RecordList(new String[]{"comp", "h", "v"});
        this.g_RelocateComps = new RecordList(new String[]{"comp", "h", "v"});
    }

    public void addResizeComp(Component c, boolean h, boolean v) {
        this.g_ResizeComps.addItem(new Object[]{c, new Boolean(h), new Boolean(v)});
    }

    public void addRelocateComp(Component c, boolean h, boolean v) {
        this.g_RelocateComps.addItem(new Object[]{c, new Boolean(h), new Boolean(v)});
    }

    @Override
    public void setDefaultButton(JButton b) {
        this.getRootPane().setDefaultButton(b);
    }

    public void showDialog() {
        this.setMinimumSize(this.getSize());
        this.setMaximumSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.setResizable(true);
        this.setVisible(true);
        this.pack();
        this.g_Width = this.getWidth();
        this.g_Height = this.getHeight();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ListDialog.this.rearrangeComp();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ListDialog.this.maxOrRestore();
                    ListDialog.this.rearrangeComp();
                }
            }
        });
    }

    public void maxOrRestore() {
        ListDialog c = this;
        if (!c.getSize().equals(((Component)c).getMaximumSize())) {
            c.setPreferredSize(c.getSize());
            ((Component)c).setLocation(0, 0);
            ((Component)c).setSize(((Component)c).getMaximumSize());
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension windowSize = ((Component)c).getPreferredSize();
            ((Component)c).setLocation(Math.max(0, (screenSize.width - windowSize.width) / 2), Math.max(0, (screenSize.height - windowSize.height) / 2));
            ((Component)c).setSize(((Component)c).getPreferredSize());
        }
    }

    private void rearrangeComp() {
        boolean v;
        boolean h;
        Component c;
        int width = this.g_Width;
        int height = this.g_Height;
        int i = 0;
        while (i < this.g_ResizeComps.size()) {
            this.g_ResizeComps.setCurrentRow(i);
            c = (Component)this.g_ResizeComps.getObj("comp");
            h = (Boolean)this.g_ResizeComps.getObj("h");
            v = (Boolean)this.g_ResizeComps.getObj("v");
            c.setSize(h ? c.getWidth() + this.getWidth() - width : c.getWidth(), v ? c.getHeight() + this.getHeight() - height : c.getHeight());
            ++i;
        }
        i = 0;
        while (i < this.g_RelocateComps.size()) {
            this.g_RelocateComps.setCurrentRow(i);
            c = (Component)this.g_RelocateComps.getObj("comp");
            h = (Boolean)this.g_RelocateComps.getObj("h");
            v = (Boolean)this.g_RelocateComps.getObj("v");
            c.setLocation(h ? c.getX() + this.getWidth() - width : c.getX(), v ? c.getY() + this.getHeight() - height : c.getY());
            ++i;
        }
        this.g_Width = this.getWidth();
        this.g_Height = this.getHeight();
        this.validate();
    }
}

