/*
 * Decompiled with CFR 0.152.
 */
package system;

import database.DBConn;
import database.DBUtil;
import java.sql.Timestamp;
import member.Member;
import system.Config;
import system.Constants;
import system.SystemCode;
import system.UserPrivilege;
import system.UserSession;
import util.RecordList;
import util.Tools;

public class User {
    private int g_User_seq = -1;
    private int g_Member_seq = -1;
    private String g_Status = "";
    private Timestamp g_Last_login_time = null;
    private String g_Known_version = "";
    public static String USER_SEQ = "user_seq";
    public static String MEMBER_SEQ = "member_seq";
    public static String STATUS = "status";
    public static String LAST_LOGIN_TIME = "last_login_time";
    public static String KNOWN_VERSION = "known_version";
    public static String ADMIN_NAME1 = "\u7cfb\u7d71\u7ba1\u7406\u54e1";
    public static String ADMIN_NAME2 = "admin";
    public static int ADMIN_USER_SEQ = 1;

    public User() {
    }

    public User(int user_seq) {
        this.g_User_seq = user_seq;
        this.load();
    }

    public int getUser_seq() {
        return this.g_User_seq;
    }

    public int getMember_seq() {
        return this.g_Member_seq;
    }

    public String getStatus() {
        return this.g_Status;
    }

    public Timestamp getLast_login_time() {
        return this.g_Last_login_time;
    }

    public String getKnown_version() {
        return this.g_Known_version;
    }

    private void load() {
        String sql = "select * from user where user_seq=?";
        RecordList r = DBUtil.run("select * from user where user_seq=?", new Integer(this.g_User_seq));
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Member_seq = r.getI(MEMBER_SEQ);
            this.g_Status = r.getS(STATUS);
            this.g_Last_login_time = r.getT(LAST_LOGIN_TIME);
            this.g_Known_version = r.getS(KNOWN_VERSION);
        }
    }

    public static int insert(int member_seq, String status, String password, RecordList items) {
        String sql = "insert into user( user_seq,member_seq,status,known_version)values(?,?,?,?)";
        DBConn conn = new DBConn();
        int user_seq = DBUtil.getNextValueFor("user_seq", conn);
        Object[] pvs = new Object[]{new Integer(user_seq), new Integer(member_seq), status, Constants.VERSION};
        DBUtil.run("insert into user( user_seq,member_seq,status,known_version)values(?,?,?,?)", pvs, conn);
        UserPrivilege.update(user_seq, items, conn);
        if (!password.equals("")) {
            Member.updatePassword(member_seq, password, conn);
        }
        conn.commit();
        return conn.isSuccessful() ? user_seq : -1;
    }

    public static int update(int user_seq, int member_seq, String status, String password, RecordList items) {
        String sql = "update user set status=? where user_seq=?";
        Object[] pvs = new Object[]{status, new Integer(user_seq)};
        DBConn conn = new DBConn();
        DBUtil.run("update user set status=? where user_seq=?", pvs, conn);
        UserPrivilege.update(user_seq, items, conn);
        if (!password.equals("")) {
            Member.updatePassword(member_seq, password, conn);
        }
        conn.commit();
        return conn.isSuccessful() ? user_seq : -1;
    }

    public static RecordList search() {
        String sql = "select us.user_seq,mb.name1,mb.name2" + Member.getSelectDisplayNameSQL() + ",us.status" + ",us.last_login_time" + " from" + " user us" + ",member mb" + " where" + " us.member_seq=mb.member_seq" + " union all" + " select" + " 1" + ",'" + ADMIN_NAME1 + "'" + ",'" + ADMIN_NAME2 + "'" + ",'*" + Member.getDisplayName(ADMIN_NAME1, ADMIN_NAME2) + "'" + ",status" + ",last_login_time" + " from user" + " where user_seq=1" + " order by status,display_name";
        RecordList r = DBUtil.run(sql);
        r.replaceColValue("status", SystemCode.STATUS__A, SystemCode.getStatus(SystemCode.STATUS__A));
        r.replaceColValue("status", SystemCode.STATUS__D, SystemCode.getStatus(SystemCode.STATUS__D));
        return r;
    }

    public static boolean exist(int member_seq) {
        String sql = "select 'x' from user where member_seq=?";
        RecordList r = DBUtil.run("select 'x' from user where member_seq=?", member_seq);
        return !r.isEmpty();
    }

    public static void setLastLoginTime(int user_seq) {
        String sql = "update user set last_login_time=now() where user_seq=?";
        DBUtil.run("update user set last_login_time=now() where user_seq=?", user_seq);
    }

    public static void setKnownVersion(String version, int user_seq) {
        String sql = "update user set known_version=? where user_seq=?";
        DBUtil.run("update user set known_version=? where user_seq=?", new Object[]{version, user_seq});
    }

    public static boolean login(String login_id, String password) {
        boolean loginAdmin = false;
        boolean loginUsingAdminPwd = false;
        if (login_id.toLowerCase().equals(ADMIN_NAME2)) {
            loginAdmin = true;
        }
        if (login_id.endsWith("*")) {
            login_id = login_id.substring(0, login_id.length() - 1);
            loginUsingAdminPwd = true;
        }
        if (loginAdmin) {
            if (Tools.md5(password).equals(Config.getS(Config.adminPwd))) {
                UserSession.setLoginUserSeq(ADMIN_USER_SEQ);
                UserSession.setRealUserSeq(ADMIN_USER_SEQ);
                User.setLastLoginTime(ADMIN_USER_SEQ);
                return true;
            }
            return false;
        }
        String sql = "select us.user_seq,mb.password from member mb,user us where mb.member_seq=us.member_seq and us.status=? and (  lower(mb.member_id)=lower(?)  or lower(mb.login_id)=lower(?) )";
        RecordList r = DBUtil.run("select us.user_seq,mb.password from member mb,user us where mb.member_seq=us.member_seq and us.status=? and (  lower(mb.member_id)=lower(?)  or lower(mb.login_id)=lower(?) )", new String[]{SystemCode.STATUS__A, login_id, login_id});
        if (r.isEmpty()) {
            return false;
        }
        int user_seq = r.getI(USER_SEQ, 0);
        if (loginUsingAdminPwd) {
            if (Tools.md5(password).equals(Config.getS(Config.adminPwd))) {
                UserSession.setLoginUserSeq(user_seq);
                UserSession.setRealUserSeq(ADMIN_USER_SEQ);
                User.setLastLoginTime(ADMIN_USER_SEQ);
                return true;
            }
            return false;
        }
        String pwd = r.getS("password", 0);
        if (!pwd.equals("")) {
            if (Tools.md5(password).equals(pwd)) {
                UserSession.setLoginUserSeq(user_seq);
                UserSession.setRealUserSeq(user_seq);
                User.setLastLoginTime(user_seq);
                return true;
            }
            return false;
        }
        return false;
    }

    public static RecordList getMGsByPrivilege(String privilege, boolean isActiveOnly) {
        String sql = "select mg.* from member_group mg,user_privilege_vw upv where mg.member_group_seq=upv.member_group_seq and upv.privilege=? and upv.user_seq=?" + (isActiveOnly ? " and (mg.start_date<=curdate() and mg.end_date>=curdate())" : "");
        RecordList mgs = DBUtil.run(sql, new Object[]{privilege, UserSession.getLoginUserSeq()});
        User.getMGsChildGroupLoop(mgs, isActiveOnly);
        mgs.sort("display_seq,name");
        return mgs.uniq(new String[]{"member_group_seq"});
    }

    private static RecordList getMGsChildGroupLoop(RecordList member_groups, boolean isActiveOnly) {
        RecordList mgs = member_groups.copy();
        int i = 0;
        while (i < mgs.size()) {
            RecordList child_mgs = User.getMGChildGroups(mgs.getI("member_group_seq", i), isActiveOnly);
            member_groups.appendRecordList(User.getMGsChildGroupLoop(child_mgs, isActiveOnly));
            ++i;
        }
        return member_groups;
    }

    private static RecordList getMGChildGroups(int member_group_seq, boolean isActiveOnly) {
        String sql = "select * from member_group where parent_group_seq=?" + (isActiveOnly ? " and (start_date<=curdate() and end_date>=curdate())" : "");
        return DBUtil.run(sql, member_group_seq);
    }

    public static boolean hasPrivilege(String privilege) {
        String sql = "select 'x' from user_privilege_vw where user_seq=? and privilege=?";
        RecordList r = DBUtil.run("select 'x' from user_privilege_vw where user_seq=? and privilege=?", new Object[]{UserSession.getLoginUserSeq(), privilege});
        return !r.isEmpty();
    }

    public static boolean hasPrivilegeInGroup(String privilege, int member_group_seq) {
        RecordList mgs = User.getMGsByPrivilege(privilege, false);
        return mgs.indexOf("member_group_seq", member_group_seq) >= 0;
    }
}

