/*
 * Decompiled with CFR 0.152.
 */
package system;

import account.AccountMonth;
import database.DBUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import system.Config;
import system.Lang;
import system.SystemCode;
import system.User;
import ui.CheckBoxYN;
import ui.ComboBoxCN;
import ui.DataDialog;
import ui.DateTextField;
import ui.TableLayout;
import ui.TimeTextField;
import util.TimeUtil;
import util.Tools;
import util.Validation;
import util.WinUtil;

public class ConfigInfoDialog
extends DataDialog {
    private JTabbedPane gTP;
    private JButton saveB;
    private JButton cancelB;
    private int gWidth = 580;
    private int gHeight = 360;
    private SystemPanel gSystemPanel = new SystemPanel();
    private MemberPanel gMemberPanel = new MemberPanel();
    private VenuePanel gVenuePanel = new VenuePanel();
    private AccountPanel gAccountPanel = new AccountPanel();
    private EmailPanel gEmailPanel = new EmailPanel();

    public ConfigInfoDialog(JFrame frame) {
        super(frame, "\u8a2d\u5b9a", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.gTP = new JTabbedPane();
        this.gTP.setSize(new Dimension(this.gWidth, this.gHeight));
        this.gTP.addTab(Lang.set(this.gSystemPanel.getName()), this.gSystemPanel);
        this.gTP.addTab(Lang.set(this.gMemberPanel.getName()), this.gMemberPanel);
        this.gTP.addTab(Lang.set(this.gVenuePanel.getName()), this.gVenuePanel);
        this.gTP.addTab(Lang.set(this.gAccountPanel.getName()), this.gAccountPanel);
        this.gTP.addTab(Lang.set(this.gEmailPanel.getName()), this.gEmailPanel);
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        this.saveB.setEnabled(User.hasPrivilege("configModify"));
        TableLayout t = new TableLayout(this, this.gWidth + 20, this.gHeight + 90, 5, 10);
        int[] nArray = new int[4];
        t.getClass();
        nArray[0] = 0;
        nArray[1] = 15;
        nArray[2] = 60;
        nArray[3] = 10;
        t.addTable(nArray, new int[]{this.gHeight + 10, 30});
        t.getClass();
        t.getClass();
        t.addCell(this.gTP, 0, 0, -1, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 1, -1, 0);
    }

    public void setEventHandler() {
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigInfoDialog.this.onCancel(evt);
            }
        });
    }

    private boolean onSave(ActionEvent evt) {
        int notValid = 0;
        if (!this.gSystemPanel.toValidate()) {
            ++notValid;
        }
        if (!this.gMemberPanel.toValidate()) {
            ++notValid;
        }
        if (!this.gVenuePanel.toValidate()) {
            ++notValid;
        }
        if (!this.gAccountPanel.toValidate()) {
            ++notValid;
        }
        if (!this.gEmailPanel.toValidate()) {
            ++notValid;
        }
        if (notValid > 0) {
            return false;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        this.gSystemPanel.save();
        this.gMemberPanel.save();
        this.gVenuePanel.save();
        this.gAccountPanel.save();
        this.gEmailPanel.save();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }

    private class AccountPanel
    extends TableLayout {
        private String gName;
        private JTextField gCompanyNameTF;
        private JTextField gReceiptIdFormatTF;
        private JTextArea gReceiptPrintoutStatementTA;
        private JTextArea gOfferingPrintoutStatementTA;
        private JTextField gReceiptEmailTF;
        private CheckBoxYN gReceiptAllowModifyCB;
        private JTextField gVoucherIdFormatTF;
        private CheckBoxYN gVoucherAllowModifyCB;
        private DateTextField gStartAcPeriodDT;
        private JTextField gCurrencyCodeTF;

        public AccountPanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gName = "\u6703\u8a08";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gCompanyNameTF = new JTextField(Config.getS(Config.companyName));
            this.gReceiptIdFormatTF = new JTextField(Config.getS(Config.receiptIdFormat));
            this.gReceiptPrintoutStatementTA = new JTextArea(Config.getS(Config.receiptPrintoutStatement));
            this.gOfferingPrintoutStatementTA = new JTextArea(Config.getS(Config.offeringPrintoutStatement));
            this.gReceiptEmailTF = new JTextField(Config.getS(Config.receiptEmail));
            this.gReceiptAllowModifyCB = new CheckBoxYN("\u5df2\u78ba\u5b9a\u7684\u6536\u64da\u4ecd\u53ef\u4fee\u6539", Config.getS(Config.receiptAllowModify));
            this.gVoucherIdFormatTF = new JTextField(Config.getS(Config.voucherIdFormat));
            this.gVoucherAllowModifyCB = new CheckBoxYN("\u5df2\u78ba\u5b9a\u7684\u50b3\u7968\u4ecd\u53ef\u4fee\u6539", Config.getS(Config.voucherAllowModify));
            this.gStartAcPeriodDT = new DateTextField(Config.getT(Config.startAcPeriod));
            this.gCurrencyCodeTF = new JTextField(Config.getS(Config.currencyCode));
            JScrollPane rpsSP = new JScrollPane(this.gReceiptPrintoutStatementTA);
            JScrollPane opsSP = new JScrollPane(this.gOfferingPrintoutStatementTA);
            if (!AccountMonth.isEmpty()) {
                this.gStartAcPeriodDT.setEnabled(false);
            }
            this.addTable(new int[]{80, 0}, new int[]{30, 30, 60, 60, 30, 30, 30, 20, 20});
            this.addCell(new JLabel("\u6559\u6703\u516c\u53f8\u540d\u7a31"), 0, 0, 1, 0);
            this.addCell(this.gCompanyNameTF, 1, 0, 10, 0, 200, -1);
            this.addCell(new JLabel("\u6536\u64da\u7de8\u865f\u683c\u5f0f*"), 0, 1, 1, 0);
            this.addCell(this.gReceiptIdFormatTF, 1, 1, 10, 0, 200, -1);
            this.addCell(this.gReceiptAllowModifyCB, 1, 1, 225, 0);
            this.addCell(new JLabel("\u6536\u64da\u8072\u660e"), 0, 2, 1, 0);
            this.addCell(rpsSP, 1, 2, 10, 0, 450, 55);
            this.addCell(new JLabel("\u5949\u737b\u8b49\u660e\u66f8\u8072\u660e"), 0, 3, 1, 0);
            this.addCell(opsSP, 1, 3, 10, 0, 450, 55);
            this.addCell(new JLabel("\u6536\u64da\u7ba1\u7406\u54e1\u96fb\u90f5"), 0, 4, 1, 0);
            this.addCell(this.gReceiptEmailTF, 1, 4, 10, 0, 200, -1);
            this.addCell(new JLabel("(\u5fc5\u9808\u5b89\u88ddWebtool\u4e26\u555f\u52d5\u96fb\u90f5\u529f\u80fd)"), 1, 4, 220, 0);
            this.addCell(new JLabel("\u50b3\u7968\u5c3e\u78bc\u683c\u5f0f*"), 0, 5, 1, 0);
            this.addCell(this.gVoucherIdFormatTF, 1, 5, 10, 0, 200, -1);
            this.addCell(this.gVoucherAllowModifyCB, 1, 5, 225, 0);
            this.addCell(new JLabel("\u958b\u59cb\u5e74\u5ea6\u65e5\u671f"), 0, 6, 1, 0);
            this.addCell(this.gStartAcPeriodDT, 1, 6, 10, 0);
            this.addCell(new JLabel("\u8ca8\u5e63"), 1, 6, 100, 0);
            this.addCell(this.gCurrencyCodeTF, 1, 6, 140, 0, 50, -1);
            this.addCell(new JLabel("*\u7de8\u865f\u683c\u5f0f\u7531\u56fa\u5b9a\u5b57\u548c\u8b8a\u6578\u7d44\u6210. \u8b8a\u6578\u5305\u62ec[yyyy](4\u4f4d\u5e74\u4efd),[yy](2\u4f4d\u5e74\u4efd),[MM](\u6708\u4efd)"), 0, 7, -1, 0);
            this.addCell(new JLabel("[#x](\u81ea\u52d5\u4e0a\u8df3\u6578\u5b57,x\u4ee3\u8868\u4f4d\u6578). \u4f8b: R[yy][#3] R\u70ba\u56fa\u5b9a\u5b57,\u8ddf\u4e0a2\u4f4d\u5e74\u4efd\u53ca3\u4f4d\u6578\u81ea\u52d5\u4e0a\u8df3"), 0, 8, -1, 0);
        }

        public void setEventHandler() {
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            validation.add(this.gCompanyNameTF.getText(), "[\u6703\u8a08]\u9801:\u6559\u6703\u516c\u53f8\u540d\u7a31", "R");
            validation.add(this.gReceiptEmailTF.getText(), "[\u6703\u8a08]: \u6536\u64da\u7ba1\u7406\u8005\u96fb\u90f5", "EMAIL");
            validation.add(Tools.validateIdFormat(this.gReceiptIdFormatTF.getText()), "[\u6703\u8a08]\u9801:\u6536\u64da\u7de8\u865f\u683c\u5f0f\u4e0d\u6b63\u78ba", "RT");
            validation.add(Tools.validateIdFormat(this.gVoucherIdFormatTF.getText()), "[\u6703\u8a08]\u9801:\u50b3\u7968\u5c3e\u78bc\u683c\u5f0f\u4e0d\u6b63\u78ba", "RT");
            validation.add(this.gStartAcPeriodDT.getInput(), "[\u6703\u8a08]\u9801:\u958b\u59cb\u5e74\u5ea6\u65e5\u671f", "D");
            if (TimeUtil.isValidDateString(this.gStartAcPeriodDT.getInput())) {
                validation.add(this.gStartAcPeriodDT.getDate().equals(TimeUtil.getMonthStartDay(this.gStartAcPeriodDT.getDate())), "[\u6703\u8a08]\u9801:\u958b\u59cb\u5e74\u5ea6\u65e5\u671f\u5fc5\u9808\u662f\u6708\u4efd\u9996\u65e5", "RT");
            }
            validation.add(this.gCurrencyCodeTF.getText(), "[\u6703\u8a08]\u9801:\u8ca8\u5e63", "R");
            return validation.isValid();
        }

        public void save() {
            Config.setS(Config.companyName, this.gCompanyNameTF.getText());
            Config.setS(Config.receiptIdFormat, this.gReceiptIdFormatTF.getText());
            Config.setS(Config.receiptPrintoutStatement, this.gReceiptPrintoutStatementTA.getText());
            Config.setS(Config.offeringPrintoutStatement, this.gOfferingPrintoutStatementTA.getText());
            Config.setS(Config.receiptEmail, this.gReceiptEmailTF.getText());
            Config.setS(Config.receiptAllowModify, this.gReceiptAllowModifyCB.getValue());
            Config.setS(Config.voucherIdFormat, this.gVoucherIdFormatTF.getText());
            Config.setS(Config.voucherAllowModify, this.gVoucherAllowModifyCB.getValue());
            Config.setT(Config.startAcPeriod, this.gStartAcPeriodDT.getDate());
            Config.setS(Config.currencyCode, this.gCurrencyCodeTF.getText());
        }
    }

    private class EmailPanel
    extends TableLayout {
        private String gName;
        private CheckBoxYN gEnableEmailCB;
        private JTextField gEmailHostTF;
        private JTextField gEmailPortTF;
        private JTextField gEmailUserTF;
        private JPasswordField gEmailPwdTF;
        private JTextField gAdminEmailTF;

        public EmailPanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gName = "\u96fb\u90f5";
            this.setLayout();
            this.setEventHandler();
            this.onEnableEmail(null);
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gEnableEmailCB = new CheckBoxYN("", Config.getS(Config.enableEmail));
            this.gEmailHostTF = new JTextField(Config.getS(Config.emailHost));
            this.gEmailPortTF = new JTextField(String.valueOf(Config.getI(Config.emailPort)));
            this.gEmailUserTF = new JTextField(Config.getS(Config.emailUser));
            this.gEmailPwdTF = new JPasswordField(Config.getS(Config.emailPwd));
            this.gAdminEmailTF = new JTextField(Config.getS(Config.adminEmail));
            this.addTable(new int[]{80, 200, 80, 0}, new int[]{30, 30, 30, 30});
            this.addCell(new JLabel("\u555f\u7528\u96fb\u90f5\u529f\u80fd"), 0, 0, 1, 0);
            this.addCell(this.gEnableEmailCB, 1, 0, 10, 0);
            this.addCell(new JLabel("(\u5fc5\u9808\u5b89\u88ddWebtool\u624d\u80fd\u767c\u63ee\u529f\u80fd)"), 1, 0, 40, 0);
            this.addCell(new JLabel("SMTP\u4f3a\u670d\u5668"), 0, 1, 1, 0);
            this.addCell(this.gEmailHostTF, 1, 1, 10, 0, 200, -1);
            this.addCell(new JLabel("\u9023\u63a5\u57e0"), 2, 1, 1, 0);
            this.addCell(this.gEmailPortTF, 3, 1, 10, 0, 50, -1);
            this.addCell(new JLabel("\u4f3a\u670d\u5668\u4f7f\u7528\u8005"), 0, 2, 1, 0);
            this.addCell(this.gEmailUserTF, 1, 2, 10, 0, 200, -1);
            this.addCell(new JLabel("\u4f7f\u7528\u8005\u5bc6\u78bc"), 2, 2, 1, 0);
            this.addCell(this.gEmailPwdTF, 3, 2, 10, 0, 130, -1);
            this.addCell(new JLabel("\u7cfb\u7d71\u7ba1\u7406\u54e1\u96fb\u90f5"), 0, 3, 1, 0);
            this.addCell(this.gAdminEmailTF, 1, 3, 10, 0, 200, -1);
        }

        public void setEventHandler() {
            this.gEnableEmailCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EmailPanel.this.onEnableEmail(evt);
                }
            });
        }

        public void onEnableEmail(ActionEvent evt) {
            boolean b = this.gEnableEmailCB.isSelected();
            this.gEmailHostTF.setEnabled(b);
            this.gEmailPortTF.setEnabled(b);
            this.gEmailUserTF.setEnabled(b);
            this.gEmailPwdTF.setEnabled(b);
            this.gAdminEmailTF.setEnabled(b);
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            if (this.gEnableEmailCB.isSelected()) {
                validation.add(this.gEmailHostTF.getText(), "[\u96fb\u90f5]\u9801:SMTP\u4f3a\u670d\u5668", "R");
                validation.add(this.gEmailPortTF.getText(), "[\u96fb\u90f5]\u9801:\u9023\u63a5\u57e0", "R,I,GTZ");
                validation.add(this.gAdminEmailTF.getText(), "[\u96fb\u90f5]\u9801:\u7cfb\u7d71\u7ba1\u7406\u54e1\u96fb\u90f5", "R,EMAIL");
            }
            return validation.isValid();
        }

        public void save() {
            int port = 25;
            if (!this.gEmailPortTF.getText().equals("")) {
                port = Integer.parseInt(this.gEmailPortTF.getText());
            }
            Config.setS(Config.enableEmail, this.gEnableEmailCB.getValue());
            Config.setS(Config.emailHost, this.gEmailHostTF.getText());
            Config.setI(Config.emailPort, port);
            Config.setS(Config.emailUser, this.gEmailUserTF.getText());
            Config.setS(Config.emailPwd, String.valueOf(this.gEmailPwdTF.getPassword()));
            Config.setS(Config.adminEmail, this.gAdminEmailTF.getText());
        }
    }

    private class MemberPanel
    extends TableLayout {
        private String gName;
        private JTextField gMemberIdFormatTF;
        private CheckBoxYN gMemberIdCheckDigitCB;
        private JTextField gMemberIdSeqTF;
        private JTextField gDisplayNameFormatTF;
        private JTextField gDisplayNameShortFormatTF;

        public MemberPanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gName = "\u6703\u773e";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gMemberIdFormatTF = new JTextField(Config.getS(Config.memberIdFormat));
            this.gMemberIdCheckDigitCB = new CheckBoxYN("\u65b0\u589e\u6703\u773e\u7de8\u865f\u6642\u81ea\u52d5\u5728\u6700\u5f8c\u52a0\u4e0a\u4e00\u500b Mod 11 \u6838\u5c0d\u4f4d\u5143", Config.getS(Config.memberIdCheckDigit));
            this.gMemberIdSeqTF = new JTextField(String.valueOf(DBUtil.getCurValueFor("member_id_seq", null)));
            this.gDisplayNameFormatTF = new JTextField(Config.getS(Config.displayNameFormat));
            this.gDisplayNameShortFormatTF = new JTextField(Config.getS(Config.displayNameShortFormat));
            this.addTable(new int[]{100, 0}, new int[]{30, 30, 20, 30, 30, 30, 20, 20, 20});
            this.addCell(new JLabel("\u6703\u773e\u7de8\u865f\u683c\u5f0f*"), 0, 0, 1, 0);
            this.addCell(this.gMemberIdFormatTF, 1, 0, 10, 0, 200, -1);
            this.addCell(this.gMemberIdCheckDigitCB, 1, 1, 10, 0);
            this.addCell(new JLabel("(\u82e5\u4f7f\u7528\u6838\u5c0d\u4f4d\u5143,\u6703\u773e\u7de8\u865f\u5fc5\u9808\u662f\u82f1\u6587\u5b57\u6216\u6578\u5b57\u4e26\u572810\u500b\u5b57\u5143\u6216\u4ee5\u5167)"), 1, 2, 20, 0);
            this.addCell(new JLabel("\u6703\u773e\u7de8\u865f\u4e0a\u8df3\u59cb\u65bc"), 0, 3, 1, 0);
            this.addCell(this.gMemberIdSeqTF, 1, 3, 10, 0, 50, -1);
            this.addCell(new JLabel("\u59d3\u540d\u683c\u5f0f^"), 0, 4, 1, 0);
            this.addCell(this.gDisplayNameFormatTF, 1, 4, 10, 0, 200, -1);
            this.addCell(new JLabel("\u7c21\u77ed\u59d3\u540d\u683c\u5f0f^"), 0, 5, 1, 0);
            this.addCell(this.gDisplayNameShortFormatTF, 1, 5, 10, 0, 200, -1);
            this.addCell(new JLabel("*\u7de8\u865f\u683c\u5f0f\u7531\u56fa\u5b9a\u5b57\u548c\u8b8a\u6578\u7d44\u6210. \u8b8a\u6578\u5305\u62ec[yyyy](4\u4f4d\u5e74\u4efd),[yy](2\u4f4d\u5e74\u4efd),[MM](\u6708\u4efd)"), 0, 6, -1, 0);
            this.addCell(new JLabel(" [#x](\u81ea\u52d5\u4e0a\u8df3\u6578\u5b57,x\u4ee3\u8868\u4f4d\u6578). \u4f8b: R[yy][#3] R\u70ba\u56fa\u5b9a\u5b57,\u8ddf\u4e0a2\u4f4d\u5e74\u4efd\u53ca3\u4f4d\u6578\u81ea\u52d5\u4e0a\u8df3"), 0, 7, -1, 0);
            this.addCell(new JLabel("^\u59d3\u540d\u986f\u793a\u683c\u5f0f\u7531\u56fa\u5b9a\u5b57\u548c\u8b8a\u6578\u7d44\u6210. \u8b8a\u6578\u5305\u62ec[n1](\u59d3\u540d1),[n2](\u59d3\u540d2)"), 0, 8, -1, 0);
        }

        public void setEventHandler() {
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            validation.add(Tools.validateIdFormat(this.gMemberIdFormatTF.getText()), "[\u6703\u773e]\u9801:\u6703\u773e\u7de8\u865f\u683c\u5f0f\u4e0d\u6b63\u78ba", "RT");
            if (this.gMemberIdCheckDigitCB.isSelected()) {
                validation.add(Tools.validateMemberIdFormat(this.gMemberIdFormatTF.getText()), "[\u6703\u773e]\u9801:\u6703\u773e\u7de8\u865f\u683c\u5f0f\u4e0d\u7b26\u5408\u4f7f\u7528\u6838\u5c0d\u4f4d\u5143\u7684\u8981\u6c42", "RT");
            }
            validation.add(this.gMemberIdSeqTF.getText(), "[\u6703\u773e]\u9801:\u6703\u773e\u7de8\u865f\u4e0a\u8df3\u65bc", "R,I,GTZ");
            validation.add(this.gDisplayNameFormatTF.getText(), "[\u6703\u773e]\u9801:\u59d3\u540d\u986f\u793a\u683c\u5f0f", "R");
            validation.add(Tools.validateDisplayNameFormat(this.gDisplayNameFormatTF.getText()), "[\u6703\u773e]\u9801:\u59d3\u540d\u683c\u5f0f\u4e0d\u6b63\u78ba", "RT");
            validation.add(Tools.validateDisplayNameFormat(this.gDisplayNameShortFormatTF.getText()), "[\u6703\u773e]\u9801:\u7c21\u77ed\u59d3\u540d\u683c\u5f0f\u4e0d\u6b63\u78ba", "RT");
            return validation.isValid();
        }

        public void save() {
            Config.setS(Config.memberIdFormat, this.gMemberIdFormatTF.getText());
            Config.setS(Config.memberIdCheckDigit, this.gMemberIdCheckDigitCB.getValue());
            Config.setS(Config.displayNameFormat, this.gDisplayNameFormatTF.getText());
            Config.setS(Config.displayNameShortFormat, this.gDisplayNameShortFormatTF.getText());
            DBUtil.setValueFor("member_id_seq", Integer.parseInt(this.gMemberIdSeqTF.getText()), null);
        }
    }

    private class SystemPanel
    extends TableLayout {
        private String gName;
        private JTextField gChurchNameTF;
        private ComboBoxCN gLangCN;
        private CheckBoxYN gAutoCheckUpdateCB;
        private JLabel gChurchP;
        private JButton gChurchPSelB;
        private String gChurchPTmpPath;
        private String gChurchPPath;
        private JLabel gMemberCardFrontP;
        private JButton gMemberCardFrontPSelB;
        private String gMemberCardFrontPTmpPath;
        private String gMemberCardFrontPPath;
        private JLabel gMemberCardBackP;
        private JButton gMemberCardBackPSelB;
        private String gMemberCardBackPTmpPath;
        private String gMemberCardBackPPath;

        public SystemPanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gChurchPTmpPath = "";
            this.gChurchPPath = "image/logo.jpg";
            this.gMemberCardFrontPTmpPath = "";
            this.gMemberCardFrontPPath = "image/card_front_bg.jpg";
            this.gMemberCardBackPTmpPath = "";
            this.gMemberCardBackPPath = "image/card_back_bg.jpg";
            this.gName = "\u7cfb\u7d71";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gChurchNameTF = new JTextField(Config.getS(Config.churchName));
            this.gLangCN = new ComboBoxCN(SystemCode.getLang(), Config.getS(Config.lang));
            this.gAutoCheckUpdateCB = new CheckBoxYN("\u81ea\u52d5\u6aa2\u67e5\u66f4\u65b0", Config.getS(Config.autoCheckUpdate));
            this.gChurchP = new JLabel(Tools.getScaledImage(this.gChurchPPath, 240, 30));
            this.gChurchPSelB = new JButton("\u700f\u89bd...");
            this.gMemberCardFrontP = new JLabel(Tools.getScaledImage(this.gMemberCardFrontPPath, 90, 60));
            this.gMemberCardFrontPSelB = new JButton("\u6b63\u9762...");
            this.gMemberCardBackP = new JLabel(Tools.getScaledImage(this.gMemberCardBackPPath, 90, 60));
            this.gMemberCardBackPSelB = new JButton("\u80cc\u9762...");
            this.gLangCN.hasNilItem(false);
            this.addTable(new int[]{80, 245, 80, 0}, new int[]{30, 30, 40, 30, 60});
            this.addCell(new JLabel("\u6559\u6703\u540d\u7a31"), 0, 0, 1, 0);
            this.addCell(this.gChurchNameTF, 1, 0, 10, 0, 200, -1);
            this.addCell(new JLabel("\u8a9e\u8a00"), 2, 0, 1, 0);
            this.addCell(this.gLangCN, 3, 0, 10, 0);
            this.addCell(new JLabel("\u6559\u6703\u5716\u50cf"), 0, 1, 1, 0);
            this.addCell(this.gChurchPSelB, 1, 1, 10, 0);
            this.addCell(new JLabel("\u5efa\u8b70:\u95ca1200px\u9ad8150px"), 1, 1, 90, 0);
            this.addCell(this.gAutoCheckUpdateCB, 3, 1, 10, 0);
            this.addCell(this.gChurchP, 1, 2, 10, 0);
            this.addCell(new JLabel("\u6703\u773e\u8b49\u5716\u50cf"), 0, 3, 1, 0);
            this.addCell(this.gMemberCardFrontPSelB, 1, 3, 10, 0);
            this.addCell(new JLabel("\u5efa\u8b70:\u95ca900px\u9ad8600px"), 1, 3, 90, 0);
            this.addCell(this.gMemberCardBackPSelB, 1, 3, 250, 0);
            this.addCell(new JLabel("\u5efa\u8b70:\u95ca900px\u9ad8600px"), 1, 3, 340, 0);
            this.addCell(this.gMemberCardFrontP, 1, 4, 10, 0);
            this.addCell(this.gMemberCardBackP, 1, 4, 250, 0);
        }

        public void setEventHandler() {
            this.gAutoCheckUpdateCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (SystemPanel.this.gAutoCheckUpdateCB.isSelected()) {
                        WinUtil.showMessage(null, "\u555f\u7528\u6b64\u529f\u80fd\u6703\u9023\u63a5\u4e0aActs\u5b98\u65b9\u7db2\u7ad9\u6aa2\u67e5\u66f4\u65b0. \u5728\u4fe1\u4ef0\u654f\u611f\u7684\u5730\u5340, \u4e0d\u5efa\u8b70\u555f\u7528\u6b64\u529f\u80fd, \u4ee5\u514d\u88ab\u8ffd\u8e64\u6e90\u982d.");
                    }
                }
            });
            this.gChurchPSelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SystemPanel.this.gChurchPTmpPath = SystemPanel.this.onChurchPhotoChoose(evt, SystemPanel.this.gChurchPTmpPath, SystemPanel.this.gChurchP, 240, 30);
                }
            });
            this.gMemberCardFrontPSelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SystemPanel.this.gMemberCardFrontPTmpPath = SystemPanel.this.onChurchPhotoChoose(evt, SystemPanel.this.gMemberCardFrontPTmpPath, SystemPanel.this.gMemberCardFrontP, 90, 60);
                }
            });
            this.gMemberCardBackPSelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SystemPanel.this.gMemberCardBackPTmpPath = SystemPanel.this.onChurchPhotoChoose(evt, SystemPanel.this.gMemberCardBackPTmpPath, SystemPanel.this.gMemberCardBackP, 90, 60);
                }
            });
        }

        private String onChurchPhotoChoose(ActionEvent evt, String tmpPath, JLabel photo, int width, int height) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            int option = chooser.showOpenDialog(this);
            if (option == 0) {
                tmpPath = chooser.getSelectedFile().getPath();
                photo.setIcon(Tools.getScaledImage(tmpPath, width, height));
            }
            return tmpPath;
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            validation.add(this.gChurchNameTF.getText(), "[\u4e00\u822c]\u9801:\u6559\u6703\u540d\u7a31", "R");
            return validation.isValid();
        }

        public void save() {
            Config.setS(Config.churchName, this.gChurchNameTF.getText());
            Config.setS(Config.lang, this.gLangCN.getSelectedCode());
            Config.setS(Config.autoCheckUpdate, this.gAutoCheckUpdateCB.getValue());
            if (!this.gChurchPTmpPath.equals("")) {
                Tools.copyFile(this.gChurchPTmpPath, this.gChurchPPath);
            }
            if (!this.gMemberCardFrontPTmpPath.equals("")) {
                Tools.copyFile(this.gMemberCardFrontPTmpPath, this.gMemberCardFrontPPath);
            }
            if (!this.gMemberCardBackPTmpPath.equals("")) {
                Tools.copyFile(this.gMemberCardBackPTmpPath, this.gMemberCardBackPPath);
            }
        }
    }

    private class VenuePanel
    extends TableLayout {
        private String gName;
        private TimeTextField gVenueStartTimeTT;
        private TimeTextField gVenueEndTimeTT;
        private DateTextField gVenueRequestMaxDateDT;
        private JTextArea gVenueRequestWalkInPeriodTA;
        private CheckBoxYN gVenueRequestDefaultApprovedCB;
        private JTextField gVenueRequestEmailTF;

        public VenuePanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gName = "\u5834\u5730";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gVenueStartTimeTT = new TimeTextField(Config.getT(Config.venueStartTime));
            this.gVenueEndTimeTT = new TimeTextField(Config.getT(Config.venueEndTime));
            this.gVenueRequestMaxDateDT = new DateTextField(Config.getT(Config.venueRequestMaxDate));
            this.gVenueRequestWalkInPeriodTA = new JTextArea(Config.getS(Config.venueRequestWalkInPeriod));
            this.gVenueRequestDefaultApprovedCB = new CheckBoxYN("", Config.getS(Config.venueRequestDefaultApproved));
            this.gVenueRequestEmailTF = new JTextField(Config.getS(Config.venueRequestEmail));
            JScrollPane wipSP = new JScrollPane(this.gVenueRequestWalkInPeriodTA);
            this.addTable(new int[]{80, 0}, new int[]{30, 30, 60, 30, 30});
            this.addCell(new JLabel("\u5834\u5730\u958b\u653e\u6642\u9593"), 0, 0, 1, 0);
            this.addCell(this.gVenueStartTimeTT, 1, 0, 10, 0);
            this.addCell(new JLabel("\u81f3"), 1, 0, 60, 0);
            this.addCell(this.gVenueEndTimeTT, 1, 0, 75, 0);
            this.addCell(new JLabel("(\u53ea\u6709Webtool\u53d7\u6b64\u9650\u5236)"), 1, 0, 125, 0);
            this.addCell(new JLabel("\u53ef\u7533\u8acb\u6700\u9060\u65e5\u671f"), 0, 1, 1, 0);
            this.addCell(this.gVenueRequestMaxDateDT, 1, 1, 10, 0);
            this.addCell(new JLabel("(\u53ea\u6709Webtool\u53d7\u6b64\u9650\u5236)"), 1, 1, 100, 0);
            this.addCell(new JLabel("\u7121\u5373\u6642\u9810\u7d04\u6642\u6bb5"), 0, 2, 1, 0);
            this.addCell(wipSP, 1, 2, 10, 0, 140, 55);
            this.addCell(new JLabel("(\u53ea\u6709Webtool\u53d7\u6b64\u9650\u5236)"), 1, 2, 160, 0);
            this.addCell(new JLabel("\u7533\u8acb\u9810\u8a2d\u6279\u6838"), 0, 3, 1, 0);
            this.addCell(this.gVenueRequestDefaultApprovedCB, 1, 3, 10, 0);
            this.addCell(new JLabel("(\u53ea\u6709Webtool\u53d7\u6b64\u9650\u5236)"), 1, 3, 30, 0);
            this.addCell(new JLabel("\u5834\u5730\u7ba1\u7406\u54e1\u96fb\u90f5"), 0, 4, 1, 0);
            this.addCell(this.gVenueRequestEmailTF, 1, 4, 10, 0, 200, -1);
            this.addCell(new JLabel("(\u5fc5\u9808\u5b89\u88ddWebtool\u4e26\u555f\u52d5\u96fb\u90f5\u529f\u80fd)"), 1, 4, 220, 0);
        }

        public void setEventHandler() {
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            validation.add(this.gVenueStartTimeTT.getInput(), "[\u5834\u5730]: \u5834\u5730\u958b\u653e\u6642\u9593(\u958b\u59cb)", "R,T");
            validation.add(this.gVenueEndTimeTT.getInput(), "[\u5834\u5730]: \u5834\u5730\u958b\u653e\u6642\u9593(\u7d50\u675f)", "R,T");
            validation.add(this.gVenueRequestMaxDateDT.getInput(), "[\u5834\u5730]: \u53ef\u7533\u8acb\u6700\u9060\u65e5\u671f", "R,D");
            validation.add(this.gVenueRequestEmailTF.getText(), "[\u5834\u5730]: \u5834\u5730\u7ba1\u7406\u8005\u96fb\u90f5", "EMAIL");
            if (!this.gVenueRequestWalkInPeriodTA.getText().equals("")) {
                String[] periods;
                String[] stringArray = periods = this.gVenueRequestWalkInPeriodTA.getText().split("\n");
                int n = periods.length;
                int n2 = 0;
                while (n2 < n) {
                    String period = stringArray[n2];
                    String[] items = period.split(",");
                    if (items.length != 5) {
                        validation.add(this.gVenueRequestEmailTF.getText(), "[\u5834\u5730]: \u7121\u5373\u65e5\u9810\u7d04\u6642\u6bb5\u4e2d " + period + " \u4e0d\u662f \u9031\u4e4b\u65e5,\u958b\u59cb\u6642,\u958b\u59cb\u5206,\u7d50\u675f\u6642,\u7d50\u675f\u5206 \u7684\u683c\u5f0f", "RT");
                        break;
                    }
                    if (Integer.valueOf(items[0]) < 0 || Integer.valueOf(items[0]) > 6) {
                        validation.add(this.gVenueRequestEmailTF.getText(), "[\u5834\u5730]: \u7121\u5373\u65e5\u9810\u7d04\u6642\u6bb5\u4e2d " + period + " \u7684\u9031\u4e4b\u65e5\u5fc5\u9808\u662f0-6,\u5373\u4ee3\u8868\u661f\u671f\u65e5\u81f3\u516d", "RT");
                        break;
                    }
                    if (Integer.valueOf(items[1]) < 0 || Integer.valueOf(items[1]) > 23 || Integer.valueOf(items[3]) < 0 || Integer.valueOf(items[3]) > 23) {
                        validation.add(this.gVenueRequestEmailTF.getText(), "[\u5834\u5730]: \u7121\u5373\u65e5\u9810\u7d04\u6642\u6bb5\u4e2d " + period + " \u7684\u958b\u59cb\u6642\u6216\u7d50\u675f\u6642\u5fc5\u9808\u662f0-23", "RT");
                        break;
                    }
                    if (Integer.valueOf(items[2]) < 0 || Integer.valueOf(items[2]) > 59 || Integer.valueOf(items[4]) < 0 || Integer.valueOf(items[4]) > 59) {
                        validation.add(this.gVenueRequestEmailTF.getText(), "[\u5834\u5730]: \u7121\u5373\u65e5\u9810\u7d04\u6642\u6bb5\u4e2d " + period + " \u7684\u958b\u59cb\u5206\u6216\u7d50\u675f\u5206\u5fc5\u9808\u662f0-59", "RT");
                        break;
                    }
                    ++n2;
                }
            }
            return validation.isValid();
        }

        public void save() {
            Config.setT(Config.venueStartTime, this.gVenueStartTimeTT.getTime("01/01/2000"));
            Config.setT(Config.venueEndTime, this.gVenueEndTimeTT.getTime("01/01/2000"));
            Config.setT(Config.venueRequestMaxDate, this.gVenueRequestMaxDateDT.getDate());
            Config.setS(Config.venueRequestWalkInPeriod, this.gVenueRequestWalkInPeriodTA.getText().trim());
            Config.setS(Config.venueRequestDefaultApproved, this.gVenueRequestDefaultApprovedCB.getValue());
            Config.setS(Config.venueRequestEmail, this.gVenueRequestEmailTF.getText());
        }
    }
}

