/*
 * Decompiled with CFR 0.152.
 */
package printout.xls;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import jxl.HeaderFooter;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.format.PaperSize;
import jxl.write.Blank;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import system.Lang;
import util.ArrayUtil;
import util.TimeUtil;
import util.Tools;

public class ExcelPrintout {
    private int[] g_Widths;
    private String g_Paper_size;
    private String g_Output_file;
    private boolean g_Has_report_end = true;
    private int g_Header_rownum = 0;
    private WritableWorkbook g_Workbook;
    private WritableSheet g_Sheet;
    private ArrayList g_DataSets;
    public ExcelCellFormat FORMAT_INTEGER = new ExcelCellFormat(ExcelCellFormat.INT, "");
    public ExcelCellFormat FORMAT_DOUBLE = new ExcelCellFormat(ExcelCellFormat.DOUBLE, "");
    public ExcelCellFormat FORMAT_TIMESTAMP = new ExcelCellFormat(ExcelCellFormat.TIMESTAMP, "");
    public ExcelCellFormat FORMAT_STRING = new ExcelCellFormat(ExcelCellFormat.STRING, "");
    public ExcelCellFormat TL = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.TL);
    public ExcelCellFormat TR = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.TR);
    public ExcelCellFormat BTBD = new ExcelCellFormat(ExcelCellFormat.DOUBLE, String.valueOf(ExcelFormat.BT) + ExcelFormat.BD);
    public ExcelCellFormat BD = new ExcelCellFormat(ExcelCellFormat.DOUBLE, ExcelFormat.BD);
    public ExcelCellFormat AR = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.AR);
    public ExcelCellFormat AL = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.AR);

    public ExcelPrintout(String paper_size, int[] widths) {
        this.g_Widths = widths;
        this.g_Paper_size = paper_size;
        this.g_Output_file = String.valueOf(System.getProperty("java.io.tmpdir")) + String.valueOf(System.currentTimeMillis()) + ".xls";
        try {
            this.g_Workbook = Workbook.createWorkbook((File)new File(this.g_Output_file));
        }
        catch (IOException e) {
            Tools.writeError(e);
        }
        this.g_Sheet = this.g_Workbook.createSheet("Results", 0);
        this.g_DataSets = new ArrayList();
    }

    public void addHeader(String title, String[] conditions) {
        this.addHeader("", title, conditions);
    }

    public void addHeader(String name, String title, String[] conditions) {
        ExcelCellFormat TITLE = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.FS15) + ExcelFormat.AC);
        ExcelCellFormat TIME = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.WF) + ExcelFormat.AR);
        ExcelCellFormat CONDITION = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.WF);
        int row = 0;
        if (!name.equals("")) {
            this.addCell(0, row, this.g_Widths.length, 1, name, TITLE);
            ++row;
        }
        this.addCell(0, row, this.g_Widths.length, 1, title, TITLE);
        String current_time = TimeUtil.getStringByDateTime(TimeUtil.getCurrentTimestamp());
        this.addCell(this.g_Widths.length - 1, row + 1, String.valueOf(Lang.set("\u5217\u5370\u6642\u9593: ")) + current_time, TIME);
        int i = 0;
        while (i < conditions.length) {
            this.addCell(0, ++row, conditions[i], CONDITION);
            ++i;
        }
        this.g_Header_rownum = Math.max(conditions.length, 1) + 2;
    }

    public void setReportEnd(boolean s) {
        this.g_Has_report_end = s;
    }

    public int getRowNumAfterHeader() {
        return this.g_Header_rownum;
    }

    public void addCell(int col, int row, int data) {
        this.add(col, row, 1, 1, new Integer(data), this.FORMAT_INTEGER);
    }

    public void addCell(int col, int row, double data) {
        this.add(col, row, 1, 1, new BigDecimal(data), this.FORMAT_DOUBLE);
    }

    public void addCell(int col, int row, Timestamp data) {
        this.add(col, row, 1, 1, data, this.FORMAT_TIMESTAMP);
    }

    public void addCell(int col, int row, String data) {
        this.add(col, row, 1, 1, data, this.FORMAT_STRING);
    }

    public void addCell(int col, int row, StringBuffer data) {
        this.add(col, row, 1, 1, data, this.FORMAT_STRING);
    }

    public void addCell(int col, int row, int data, ExcelCellFormat cf) {
        this.add(col, row, 1, 1, new Integer(data), cf);
    }

    public void addCell(int col, int row, double data, ExcelCellFormat cf) {
        this.add(col, row, 1, 1, new BigDecimal(data), cf);
    }

    public void addCell(int col, int row, Timestamp data, ExcelCellFormat cf) {
        this.add(col, row, 1, 1, data, cf);
    }

    public void addCell(int col, int row, String data, ExcelCellFormat cf) {
        this.add(col, row, 1, 1, data, cf);
    }

    public void addCell(int col, int row, StringBuffer data, ExcelCellFormat cf) {
        this.add(col, row, 1, 1, data, cf);
    }

    public void addCell(int col, int row, int colspan, int rowspan, int data, ExcelCellFormat cf) {
        this.add(col, row, colspan, rowspan, new Integer(data), cf);
    }

    public void addCell(int col, int row, int colspan, int rowspan, double data, ExcelCellFormat cf) {
        this.add(col, row, colspan, rowspan, new BigDecimal(data), cf);
    }

    public void addCell(int col, int row, int colspan, int rowspan, Timestamp data, ExcelCellFormat cf) {
        this.add(col, row, colspan, rowspan, data, cf);
    }

    public void addCell(int col, int row, int colspan, int rowspan, String data, ExcelCellFormat cf) {
        this.add(col, row, colspan, rowspan, data, cf);
    }

    public void addCell(int col, int row, int colspan, int rowspan, StringBuffer data, ExcelCellFormat cf) {
        this.add(col, row, colspan, rowspan, data, cf);
    }

    private void add(int col, int row, int colspan, int rowspan, Object data, ExcelCellFormat cf) {
        if (row >= this.g_DataSets.size()) {
            int i = this.g_DataSets.size();
            while (i <= row) {
                this.g_DataSets.add(new HashMap());
                ++i;
            }
        }
        HashMap h = (HashMap)this.g_DataSets.get(row);
        h.put(String.valueOf(col), new DataSet(data, colspan, rowspan, cf));
        this.g_DataSets.set(row, h);
    }

    public void addPageBreak(int row) {
        this.g_Sheet.addRowPageBreak(row);
    }

    public void setPrintFitWidthToPage(int page) {
        this.g_Sheet.getSettings().setFitWidth(page);
    }

    public void genPrintout() {
        try {
            this.setSheetFormats();
            if (this.g_Has_report_end) {
                this.addReportEnd();
            }
            int row = 0;
            while (row < this.g_DataSets.size()) {
                int col = 0;
                while (col < this.g_Widths.length) {
                    Object obj = ArrayUtil.getObject(String.valueOf(col), row, this.g_DataSets);
                    Object cell = null;
                    if (obj == null) {
                        cell = new Blank(col, row);
                    } else {
                        DataSet ds = (DataSet)ArrayUtil.getObject(String.valueOf(col), row, this.g_DataSets);
                        cell = ds.getData() instanceof Integer ? new Number(col, row, (double)((Integer)ds.getData()).intValue(), (CellFormat)ds.getWritableCellFormat()) : (ds.getData() instanceof BigDecimal ? new Number(col, row, ((BigDecimal)ds.getData()).doubleValue(), (CellFormat)ds.getWritableCellFormat()) : (ds.getData() instanceof Timestamp ? new DateTime(col, row, (Date)((Timestamp)ds.getData()), (CellFormat)ds.getWritableCellFormat()) : (ds.getData() instanceof String ? new Label(col, row, (String)ds.getData(), (CellFormat)ds.getWritableCellFormat()) : (ds.getData() instanceof StringBuffer ? new Formula(col, row, ((StringBuffer)ds.getData()).toString(), (CellFormat)ds.getWritableCellFormat()) : new Blank(col, row)))));
                        if (ds.getColspan() != 1 || ds.getRowspan() != 1) {
                            this.g_Sheet.mergeCells(col, row, col + ds.getColspan() - 1, row + ds.getRowspan() - 1);
                        }
                        col = col + ds.getColspan() - 1;
                        row = row + ds.getRowspan() - 1;
                    }
                    this.g_Sheet.addCell((WritableCell)cell);
                    ++col;
                }
                ++row;
            }
            this.g_Workbook.write();
            this.g_Workbook.close();
            Tools.openFileByCmd(this.g_Output_file);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
    }

    private void setSheetFormats() {
        double mm18 = 18.0 * ExcelFormat.MM2INCH;
        double mm10 = 10.0 * ExcelFormat.MM2INCH;
        SheetSettings ss = this.g_Sheet.getSettings();
        if (this.g_Paper_size.equals(ExcelFormat.PA4)) {
            ss.setPaperSize(PaperSize.A4);
            ss.setTopMargin(mm18);
            ss.setBottomMargin(mm10);
            ss.setLeftMargin(mm18);
            ss.setRightMargin(mm10);
        } else if (this.g_Paper_size.equals(ExcelFormat.PA4R)) {
            ss.setPaperSize(PaperSize.A4_ROTATED);
            ss.setTopMargin(mm18);
            ss.setBottomMargin(mm10);
            ss.setLeftMargin(mm10);
            ss.setRightMargin(mm10);
        }
        ss.setHeaderMargin(mm10);
        ss.setFooterMargin(0.0);
        HeaderFooter header = new HeaderFooter();
        HeaderFooter.Contents right_header = header.getRight();
        right_header.append(Lang.set("\u9801"));
        right_header.appendPageNumber();
        right_header.append("/");
        right_header.appendTotalPages();
        ss.setHeader(header);
        int col = 0;
        while (col < this.g_Widths.length) {
            this.g_Sheet.setColumnView(col, (int)Math.round((double)this.g_Widths[col] * ExcelFormat.MM2COLWIDTH));
            ++col;
        }
    }

    private void addReportEnd() {
        ExcelCellFormat STYLE = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.AC);
        this.addCell(0, this.g_DataSets.size() + 1, this.g_Widths.length, 1, Lang.set("[\u5831\u8868\u5b8c\u7562]"), STYLE);
    }

    class DataSet {
        private Object g_Data = null;
        private int g_Colspan = 1;
        private int g_Rowspan = 1;
        private ExcelCellFormat g_CellFormat = null;

        public Object getData() {
            return this.g_Data;
        }

        public int getColspan() {
            return this.g_Colspan;
        }

        public int getRowspan() {
            return this.g_Rowspan;
        }

        public ExcelCellFormat getCellFormat() {
            return this.g_CellFormat;
        }

        public WritableCellFormat getWritableCellFormat() {
            return this.g_CellFormat.getCellFormat();
        }

        public DataSet(Object data, int colspan, int rowspan, ExcelCellFormat cellformat) {
            this.g_Data = data;
            this.g_Colspan = colspan;
            this.g_Rowspan = rowspan;
            this.g_CellFormat = cellformat;
            if (this.g_Colspan != 1 || this.g_Rowspan != 1) {
                this.g_CellFormat.setWrap(false);
            }
        }
    }
}

