/*
 * Decompiled with CFR 0.152.
 */
package printout.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfPTable;
import util.Tools;

public class PDFTable {
    private PdfPTable g_Table = null;
    private int g_ColNum = 0;
    private int g_CurCellPos = 0;

    public PDFTable(int[] widths) {
        this.g_ColNum = widths.length;
        float[] pt_widths = new float[widths.length];
        int i = 0;
        while (i < widths.length) {
            pt_widths[i] = (float)widths[i] * 2.8346f;
            ++i;
        }
        this.g_Table = new PdfPTable(pt_widths.length);
        try {
            this.g_Table.setTotalWidth(pt_widths);
        }
        catch (DocumentException e) {
            Tools.writeError(e.getMessage());
        }
        this.g_Table.setLockedWidth(true);
    }

    public void addCell(String data, int col, int row, int colspan, int rowspan) {
        int pos = row * this.g_ColNum + col;
        if (pos < this.g_CurCellPos) {
            Tools.writeError("PDFTable:added Cell in older position");
            return;
        }
        int i = 0;
        while (i < pos - this.g_CurCellPos - 1) {
            this.g_Table.addCell("");
            ++i;
        }
        this.g_CurCellPos = pos;
        this.g_Table.addCell(data);
    }

    public void addCell(PdfPTable table, int col, int row, int colspan, int rowspan) {
        int pos = row * this.g_ColNum + col;
        if (pos < this.g_CurCellPos) {
            Tools.writeError("PDFTable:added Cell in older position");
            return;
        }
        int i = 0;
        while (i < pos - this.g_CurCellPos - 1) {
            this.g_Table.addCell("");
            ++i;
        }
        this.g_CurCellPos = pos;
        this.g_Table.addCell(table);
    }

    public PdfPTable getPdfPTable() {
        int i = 0;
        while (i < this.g_ColNum - (this.g_CurCellPos + 1) % this.g_ColNum) {
            this.g_Table.addCell("");
            ++i;
        }
        return this.g_Table;
    }
}

