/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import database.DBUtil;
import database.SQLWhereClause;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import printout.pdf.PDFPrintout;
import system.Config;
import system.Lang;
import system.SystemCode;
import util.Arith;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;
import util.Tools;
import util.WinUtil;

public class ReceiptPrintout {
    private float g_MM2PT = 2.8346f;
    private float g_Width = 210.0f * this.g_MM2PT;
    private float g_Height = 99.0f * this.g_MM2PT;
    private float g_Margin = 5.0f * this.g_MM2PT;
    private ArrayList g_Receipts = null;
    private ArrayList g_Receipt_items = null;
    private String g_Output_file = String.valueOf(System.getProperty("java.io.tmpdir")) + String.valueOf(System.currentTimeMillis()) + ".pdf";
    private boolean g_Auto_print = false;
    private int g_Auto_print_copy = 1;

    public ReceiptPrintout(String start_id, String end_id, Timestamp start_date, Timestamp end_date, boolean incl_not_require, boolean incl_email_receipt) {
        this.g_Receipts = ReceiptPrintout.getReceipts(start_id, end_id, start_date, end_date, incl_not_require, incl_email_receipt);
        this.g_Receipt_items = ReceiptPrintout.getReceiptItems(start_id, end_id, start_date, end_date);
    }

    public ReceiptPrintout(int receipt_seq, int copy) {
        Receipt c = new Receipt(receipt_seq);
        this.g_Receipts = ReceiptPrintout.getReceipts(c.getId(), c.getId(), null, null, true, true);
        this.g_Receipt_items = ReceiptPrintout.getReceiptItems(c.getId(), c.getId(), null, null);
        this.g_Auto_print = true;
        this.g_Auto_print_copy = copy;
    }

    public boolean genFile() {
        if (this.g_Receipts.isEmpty()) {
            WinUtil.showMessage(null, "\u6b64\u7bc4\u570d\u4e2d\u6c92\u6709\u6536\u64da\u6216\u7576\u4e2d\u6536\u64da\u4e26\u672a\u6279\u6838");
            return true;
        }
        Document document = new Document(new Rectangle(this.g_Width, this.g_Height), this.g_Margin, this.g_Margin, this.g_Margin, this.g_Margin);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.g_Output_file));
            document.open();
            BaseFont bf = BaseFont.createFont((String)PDFPrintout.getFullFontPath(), (String)"Identity-H", (boolean)true);
            Font F15 = new Font(bf, 18.0f, 1);
            Font F9 = new Font(bf, 9.0f);
            Image header_logo = Image.getInstance((String)"image/logo.jpg");
            PdfPCell emptyC = new PdfPCell(new Phrase(" ", F9));
            emptyC.setBorder(0);
            int i = 0;
            while (i < this.g_Receipts.size()) {
                PdfPTable header_table = new PdfPTable(new float[]{130.0f, 70.0f});
                header_table.setTotalWidth(this.g_Width - this.g_Margin * 2.0f);
                header_table.setWidthPercentage(100.0f);
                header_table.setLockedWidth(true);
                header_table.getDefaultCell().setPadding(0.0f);
                PdfPCell header_logoC = new PdfPCell(header_logo, true);
                header_logoC.setBorder(0);
                PdfPCell header_receiptC = new PdfPCell(new Phrase(Lang.set("\u6536\u64da"), F15));
                header_receiptC.setHorizontalAlignment(2);
                header_receiptC.setBorder(0);
                header_table.addCell(header_logoC);
                header_table.addCell(header_receiptC);
                PdfPTable parent_table = new PdfPTable(new float[]{12.0f, 135.0f, 18.0f, 35.0f});
                parent_table.getDefaultCell().setBorder(0);
                parent_table.setTotalWidth(this.g_Width - this.g_Margin * 2.0f);
                parent_table.setWidthPercentage(100.0f);
                parent_table.setLockedWidth(true);
                parent_table.getDefaultCell().setPadding(0.0f);
                int receipt_seq = ArrayUtil.getInt("RECEIPT_SEQ", i, this.g_Receipts);
                String id = ArrayUtil.getString("ID", i, this.g_Receipts);
                Timestamp date = ArrayUtil.getTimestamp("DATE", i, this.g_Receipts);
                String offer_from = ArrayUtil.getString("OFFER_FROM", i, this.g_Receipts);
                String cheque_no = ArrayUtil.getString("CHEQUE_NO", i, this.g_Receipts);
                ArrayList items = ArrayUtil.getGroupItems(this.g_Receipt_items, "RECEIPT_SEQ", new Integer(receipt_seq));
                double total = ArrayUtil.getDoubleSum(items, "AMOUNT");
                PdfPCell dataC = new PdfPCell();
                dataC.setBorder(0);
                dataC.setPhrase(new Phrase(Lang.set("\u65e5\u671f:"), F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(TimeUtil.getStringByDate(date), F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(Lang.set("\u6536\u64da\u7de8\u865f:"), F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(id, F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(Lang.set("\u59d3\u540d:"), F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(offer_from, F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(Lang.set("\u7e3d\u91d1\u984d\u3000:"), F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(String.valueOf(Config.getS(Config.currencyCode)) + Arith.formatAmount(total), F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase("", F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase("", F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(!cheque_no.equals("") ? Lang.set("\u652f\u7968\u865f\u78bc:") : " ", F9));
                parent_table.addCell(dataC);
                dataC.setPhrase(new Phrase(cheque_no, F9));
                parent_table.addCell(dataC);
                PdfPTable item_table = new PdfPTable(new float[]{15.0f * this.g_MM2PT, 15.0f * this.g_MM2PT, 100.0f * this.g_MM2PT, 35.0f * this.g_MM2PT, 20.0f * this.g_MM2PT});
                item_table.getDefaultCell().setBorder(0);
                item_table.setTotalWidth(this.g_Width - this.g_Margin * 2.0f);
                item_table.setWidthPercentage(100.0f);
                item_table.setLockedWidth(true);
                item_table.getDefaultCell().setPadding(0.0f);
                PdfPCell item_header_typeC = new PdfPCell(new Phrase(Lang.set("\u985e\u5225"), F9));
                PdfPCell item_header_target_dateC = new PdfPCell(new Phrase(Lang.set("\u6307\u5b9a\u671f"), F9));
                PdfPCell item_header_noteC = new PdfPCell(new Phrase(Lang.set("\u6458\u8981"), F9));
                PdfPCell item_header_amountC = new PdfPCell(new Phrase(String.valueOf(Lang.set("\u91d1\u984d")) + "(" + Config.getS(Config.currencyCode) + ")", F9));
                item_header_typeC.setBorder(3);
                item_header_target_dateC.setBorder(3);
                item_header_noteC.setBorder(3);
                item_header_noteC.setColspan(2);
                item_header_amountC.setBorder(3);
                item_header_amountC.setHorizontalAlignment(2);
                item_table.addCell(item_header_typeC);
                item_table.addCell(item_header_target_dateC);
                item_table.addCell(item_header_noteC);
                item_table.addCell(item_header_amountC);
                int j = 0;
                while (j < items.size()) {
                    String type = ArrayUtil.getString("TYPE", j, items);
                    Timestamp target_date = ArrayUtil.getTimestamp("TARGET_DATE", j, items);
                    String note = ArrayUtil.getString("NOTE", j, items);
                    double amount = ArrayUtil.getDouble("AMOUNT", j, items);
                    String type_desc = type.equals(Receipt.TYPE__OFFERING) ? Tools.getStatusName(Receipt.TYPE_MAP, Receipt.TYPE__OFFERING) : Tools.getStatusName(Receipt.TYPE_MAP, Receipt.TYPE__CHARGE);
                    PdfPCell typeC = new PdfPCell(new Phrase(type_desc, F9));
                    PdfPCell target_dateC = new PdfPCell(new Phrase(TimeUtil.getMonthYearByDate(target_date), F9));
                    PdfPCell noteC = new PdfPCell(new Phrase(note, F9));
                    PdfPCell amountC = new PdfPCell(new Phrase(Arith.formatAmount(amount), F9));
                    typeC.setBorder(0);
                    target_dateC.setBorder(0);
                    noteC.setBorder(0);
                    noteC.setColspan(2);
                    amountC.setBorder(0);
                    amountC.setHorizontalAlignment(2);
                    item_table.addCell(typeC);
                    item_table.addCell(target_dateC);
                    item_table.addCell(noteC);
                    item_table.addCell(amountC);
                    ++j;
                }
                PdfPCell totalC = new PdfPCell(new Phrase(Arith.formatAmount(total), F9));
                totalC.setHorizontalAlignment(2);
                totalC.setBorder(1);
                item_table.addCell(emptyC);
                item_table.addCell(emptyC);
                item_table.addCell(emptyC);
                item_table.addCell(emptyC);
                item_table.addCell(totalC);
                int j2 = 0;
                while (j2 < 8 - items.size()) {
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    item_table.addCell(emptyC);
                    ++j2;
                }
                PdfPCell noticeC = new PdfPCell(new Phrase(Config.getS(Config.receiptPrintoutStatement), F9));
                PdfPCell signC = new PdfPCell(new Phrase(Lang.set("\u7f72\u540d\u53ca\u6559\u6703\u84cb\u5370"), F9));
                noticeC.setBorder(0);
                noticeC.setColspan(3);
                signC.setHorizontalAlignment(2);
                signC.setBorder(1);
                signC.setColspan(2);
                item_table.addCell(noticeC);
                item_table.addCell(signC);
                PdfPTable page_table = new PdfPTable(1);
                page_table.getDefaultCell().setBorder(0);
                page_table.addCell(header_table);
                page_table.addCell(parent_table);
                page_table.addCell(item_table);
                document.add((Element)page_table);
                if (i != this.g_Receipts.size() - 1) {
                    document.newPage();
                }
                ++i;
            }
        }
        catch (DocumentException e1) {
            Tools.writeError(e1.getMessage());
        }
        catch (IOException e2) {
            Tools.writeError(e2.getMessage());
        }
        document.close();
        try {
            String option = "";
            Runtime.getRuntime().exec("cmd.exe /c \"" + this.g_Output_file + "\"");
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        return true;
    }

    public static RecordList getReceipts(String start_id, String end_id, Timestamp start_date, Timestamp end_date, boolean incl_not_require, boolean incl_email_receipt) {
        SQLWhereClause clause = new SQLWhereClause("where", new String[]{"id>=?", "id<=?", "date>=?", "date<?", "not status=?", "require_receipt=?", "email_status=?"}, new Object[]{start_id, end_id, start_date, TimeUtil.adjustDate(end_date, 1), Receipt.STATUS__CL, incl_not_require ? "" : SystemCode.YN__Y, incl_email_receipt ? "" : Receipt.EMAIL_STATUS__NA});
        String sql = "select receipt_seq,id,date,status,offer_from,payment_method,cheque_no,member_seq,remark,require_receipt,email_status from receipt" + clause.getConds() + " order by id";
        return DBUtil.run(sql, clause.getPrepValues());
    }

    public static RecordList getReceiptItems(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"rc.id>=?", "rc.id<=?", "rc.date>=?", "rc.date<?", "not rc.status=?"}, new Object[]{start_id, end_id, start_date, TimeUtil.adjustDate(end_date, 1), Receipt.STATUS__CL});
        String sql = "select rci.receipt_seq,rci.type,rci.sub_type,rci.target_date,rci.note,rci.amount from receipt as rc,receipt_item as rci where rc.receipt_seq=rci.receipt_seq" + clause.getConds();
        return DBUtil.run(sql, clause.getPrepValues());
    }
}

