/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import account.ReceiptPrintout;
import java.sql.Timestamp;
import java.util.ArrayList;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelFormula;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import system.MasterCode;
import system.SystemCode;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class ReceiptDetailReport {
    private RecordList gReceipts;
    private RecordList gReceiptItems;

    public ReceiptDetailReport(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        this.getReceipts(start_id, end_id, start_date, end_date);
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4R, new int[]{24, 22, 40, 22, 22, 22, 20, 16, 18, 25, 18, 35, 22});
        p.setPrintFitWidthToPage(1);
        String range = start_id.isEmpty() ? String.valueOf(Lang.set("\u6536\u64da\u65e5\u671f: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" \u81f3 ") + TimeUtil.getStringByDate(end_date) : String.valueOf(Lang.set("\u6536\u64da\u7de8\u865f: ")) + start_id + Lang.set(" \u81f3 ") + end_id;
        p.addHeader(Config.getS(Config.churchName), Lang.set("\u6536\u64da\u8a73\u7d30\u8868"), new String[]{range, Lang.set("*\u4e0d\u5305\u542b\u5df2\u53d6\u6d88\u7684\u6536\u64da")});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("\u6536\u64da\u7de8\u865f"), p.TL);
        p.addCell(1, row, Lang.set("\u6536\u64da\u65e5\u671f"), p.TL);
        p.addCell(2, row, Lang.set("\u8332\u6536\u5230"), p.TL);
        p.addCell(3, row, Lang.set("\u4ed8\u6b3e\u65b9\u5f0f"), p.TL);
        p.addCell(4, row, Lang.set("\u652f\u7968\u865f\u78bc"), p.TL);
        p.addCell(5, row, Lang.set("\u5099\u8a3b"), p.TL);
        p.addCell(6, row, Lang.set("\u73fe\u6cc1"), p.TL);
        p.addCell(7, row, Lang.set("\u9700\u8981\u6536\u64da"), p.TL);
        p.addCell(8, row, Lang.set("\u985e\u5225"), p.TL);
        p.addCell(9, row, Lang.set("\u9805\u76ee"), p.TL);
        p.addCell(10, row, Lang.set("\u6307\u5b9a\u671f"), p.TL);
        p.addCell(11, row, Lang.set("\u6458\u8981"), p.TL);
        p.addCell(12, row, String.valueOf(Lang.set("\u91d1\u984d(")) + Config.getS(Config.currencyCode) + ")", p.TR);
        int i = 0;
        while (i < this.gReceipts.size()) {
            this.gReceipts.setCurrentRow(i);
            RecordList items = this.gReceiptItems.getGroupItems("receipt_seq", this.gReceipts.getI("receipt_seq"));
            int j = 0;
            while (j < items.size()) {
                ExcelCellFormat strFormat = p.FORMAT_STRING;
                ExcelCellFormat numFormat = p.FORMAT_DOUBLE;
                if (j == items.size() - 1) {
                    strFormat = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BB);
                    numFormat = new ExcelCellFormat(ExcelCellFormat.DOUBLE, ExcelFormat.BB);
                }
                p.addCell(0, ++row, this.gReceipts.getS("id"), strFormat);
                p.addCell(1, row, TimeUtil.getStringByDate(this.gReceipts.getT("date")), strFormat);
                p.addCell(2, row, this.gReceipts.getS("offer_from"), strFormat);
                p.addCell(3, row, this.gReceipts.getS("payment_method"), strFormat);
                p.addCell(4, row, this.gReceipts.getS("cheque_no"), strFormat);
                p.addCell(5, row, this.gReceipts.getS("remark"), strFormat);
                p.addCell(6, row, this.gReceipts.getS("status"), strFormat);
                p.addCell(7, row, this.gReceipts.getS("require_receipt"), strFormat);
                items.setCurrentRow(j);
                p.addCell(8, row, items.getS("type"), strFormat);
                p.addCell(9, row, items.getS("sub_type").trim(), strFormat);
                p.addCell(10, row, TimeUtil.getMonthYearByDate(items.getT("target_date")), strFormat);
                p.addCell(11, row, items.getS("note"), strFormat);
                p.addCell(12, row, items.getD("amount"), numFormat);
                ++j;
            }
            ++i;
        }
        p.addCell(11, ++row, "\u7e3d\u91d1\u984d:", p.AR);
        if (this.gReceiptItems.isEmpty()) {
            p.addCell(12, row, 0, p.BTBD);
        } else {
            p.addCell(12, row, ExcelFormula.sum(12, row - this.gReceiptItems.size(), 12, row - 1), p.BTBD);
        }
        p.addCell(11, ++row, "\u7e3d\u6536\u64da:", p.AR);
        p.addCell(12, row, this.gReceipts.size());
        p.genPrintout();
    }

    private void getReceipts(String start_id, String end_id, Timestamp start_date, Timestamp end_date) {
        this.gReceipts = ReceiptPrintout.getReceipts(start_id, end_id, start_date, end_date, true, true);
        ArrayList payment_methods = MasterCode.getCodes("PAYMENT_METHOD");
        int i = 0;
        while (i < this.gReceipts.size()) {
            this.gReceipts.setCurrentRow(i);
            this.gReceipts.setS("status", Tools.getStatusName(Receipt.STATUS_MAP, this.gReceipts.getS("status")));
            this.gReceipts.setS("email_status", Tools.getStatusName(Receipt.EMAIL_STATUS_MAP, this.gReceipts.getS("email_status")));
            int k = ArrayUtil.indexOf("code", this.gReceipts.getS("payment_method"), payment_methods);
            this.gReceipts.setS("payment_method", k != -1 ? ArrayUtil.getString("name", k, payment_methods) : "");
            this.gReceipts.setS("require_receipt", SystemCode.getYN(this.gReceipts.getS("require_receipt")));
            ++i;
        }
        ArrayList sub_types = MasterCode.getCodes("RECEIPT_SUB_TYPE");
        this.gReceiptItems = ReceiptPrintout.getReceiptItems(start_id, end_id, start_date, end_date);
        int i2 = 0;
        while (i2 < this.gReceiptItems.size()) {
            this.gReceiptItems.setCurrentRow(i2);
            this.gReceiptItems.setS("type", Tools.getStatusName(Receipt.TYPE_MAP, this.gReceiptItems.getS("type")));
            int k = ArrayUtil.indexOf("code", this.gReceiptItems.getS("sub_type"), sub_types);
            this.gReceiptItems.setS("sub_type", k != -1 ? ArrayUtil.getString("name", k, sub_types) : "");
            ++i2;
        }
    }
}

