/*
 * Decompiled with CFR 0.152.
 */
package account;

import database.DBConn;
import database.DBUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;

public class AccountBalance {
    private int g_Ac_month_seq = -1;
    private int g_Ac_seq = -1;
    private double g_Debit = -1.0;
    private double g_Credit = -1.0;
    private double g_Adj_debit = -1.0;
    private double g_Adj_credit = -1.0;

    public AccountBalance() {
    }

    public AccountBalance(int ac_month_seq) {
        this.g_Ac_month_seq = ac_month_seq;
        this.load();
    }

    public int getAc_month_seq() {
        return this.g_Ac_month_seq;
    }

    public int getAc_seq() {
        return this.g_Ac_seq;
    }

    public double getDebit() {
        return this.g_Debit;
    }

    public double getCredit() {
        return this.g_Credit;
    }

    public double getAdj_debit() {
        return this.g_Adj_debit;
    }

    public double getAdj_credit() {
        return this.g_Adj_credit;
    }

    private void load() {
        String sql = "select AC_SEQ,DEBIT,CREDIT,ADJ_DEBIT,ADJ_CREDIT from ac_balance where AC_MONTH_SEQ=?";
        RecordList v = DBUtil.select(new String[]{"AC_SEQ", "DEBIT", "CREDIT", "ADJ_DEBIT", "ADJ_CREDIT"}, new int[]{4, 8, 8, 8, 8}, new Object[]{new Integer(this.g_Ac_month_seq)}, new int[]{4}, sql);
        if (!v.isEmpty()) {
            this.g_Ac_seq = ArrayUtil.getInt("AC_SEQ", 0, v);
            this.g_Debit = ArrayUtil.getDouble("DEBIT", 0, v);
            this.g_Credit = ArrayUtil.getDouble("CREDIT", 0, v);
            this.g_Adj_debit = ArrayUtil.getDouble("ADJ_DEBIT", 0, v);
            this.g_Adj_credit = ArrayUtil.getDouble("ADJ_CREDIT", 0, v);
        }
    }

    public static void insert(int ac_month_seq, int ac_seq, double debit, double credit, double adj_debit, double adj_credit, DBConn conn) {
        String sql = "insert into ac_balance( AC_MONTH_SEQ,AC_SEQ,DEBIT,CREDIT,ADJ_DEBIT,ADJ_CREDIT)values(?,?,?,?,?,?)";
        DBUtil.run("insert into ac_balance( AC_MONTH_SEQ,AC_SEQ,DEBIT,CREDIT,ADJ_DEBIT,ADJ_CREDIT)values(?,?,?,?,?,?)", new Object[]{new Integer(ac_month_seq), new Integer(ac_seq), new BigDecimal(debit), new BigDecimal(credit), new BigDecimal(adj_debit), new BigDecimal(adj_credit)}, conn);
    }

    public static void updateAdjust(int ac_month_seq, int ac_seq, double adj_debit, double adj_credit, DBConn conn) {
        String sql = "update ac_balance set ADJ_DEBIT=?,ADJ_CREDIT=? where AC_MONTH_SEQ=? and AC_SEQ=?";
        DBUtil.update(new Object[]{new BigDecimal(adj_debit), new BigDecimal(adj_credit), new Integer(ac_month_seq), new Integer(ac_seq)}, new int[]{8, 8, 4, 4}, sql, conn);
    }

    public static void unadjust(int ac_month_seq, DBConn conn) {
        String sql = "update ac_balance set adj_debit=0,adj_credit=0 where ac_month_seq=?";
        DBUtil.update(new Object[]{new Integer(ac_month_seq)}, new int[]{4}, sql, conn);
    }

    public static void update(int ac_month_seq, Timestamp start_date, Timestamp end_date, DBConn conn) {
        AccountBalance.delete(ac_month_seq, conn);
        ArrayList items = AccountBalance.getItems(start_date, end_date, conn);
        int i = 0;
        while (i < items.size()) {
            AccountBalance.insert(ac_month_seq, ArrayUtil.getInt("AC_SEQ", i, items), ArrayUtil.getDouble("DEBIT", i, items), ArrayUtil.getDouble("CREDIT", i, items), 0.0, 0.0, conn);
            ++i;
        }
    }

    public static boolean exist(int ac_month_seq, int ac_seq, DBConn conn) {
        String sql = "select * from ac_balance where ac_month_seq=? and ac_seq=?";
        RecordList r = DBUtil.run(sql, new Object[]{new Integer(ac_month_seq), new Integer(ac_seq)}, conn);
        return !r.isEmpty();
    }

    private static void delete(int ac_month_seq, DBConn conn) {
        String sql = "delete from ac_balance where AC_MONTH_SEQ=?";
        DBUtil.update(new Object[]{new Integer(ac_month_seq)}, new int[]{4}, sql, conn);
    }

    private static ArrayList getItems(Timestamp start_date, Timestamp end_date, DBConn conn) {
        String sql = "select am.AC_SEQ as AC_SEQ,coalesce(alv.DEBIT,0) as DEBIT,coalesce(alv.CREDIT,0) as CREDIT from ac_master am left join (select  AC_SEQ ,sum(DEBIT) as DEBIT ,sum(CREDIT) as CREDIT  from ac_ledger_vw  where DATE>=? and DATE<?  group by AC_SEQ ) alv on am.AC_SEQ=alv.AC_SEQ and am.IS_PARENT='N'";
        return DBUtil.select(new String[]{"AC_SEQ", "DEBIT", "CREDIT"}, new int[]{4, 8, 8}, new Object[]{start_date, TimeUtil.adjustDate(end_date, 1)}, new int[]{93, 93}, "select am.AC_SEQ as AC_SEQ,coalesce(alv.DEBIT,0) as DEBIT,coalesce(alv.CREDIT,0) as CREDIT from ac_master am left join (select  AC_SEQ ,sum(DEBIT) as DEBIT ,sum(CREDIT) as CREDIT  from ac_ledger_vw  where DATE>=? and DATE<?  group by AC_SEQ ) alv on am.AC_SEQ=alv.AC_SEQ and am.IS_PARENT='N'", conn);
    }

    public static ArrayList getProfitAndLossBalances(Timestamp start_date1, Timestamp start_date2, DBConn conn) {
        String sql = "select  ab.ac_seq as ac_seq,sum(ab.debit) as debit,sum(ab.credit) as credit from ac_balance ab,ac_month ap,ac_master am where ap.ac_month_seq=ab.ac_month_seq and ab.ac_seq=am.ac_seq and am.type in ('E','R') and am.is_parent='N' and ap.start_date>=? and ap.start_date<=? group by ab.ac_seq";
        return DBUtil.select(new String[]{"AC_SEQ", "DEBIT", "CREDIT"}, new int[]{4, 8, 8}, new Object[]{start_date1, start_date2}, new int[]{93, 93}, "select  ab.ac_seq as ac_seq,sum(ab.debit) as debit,sum(ab.credit) as credit from ac_balance ab,ac_month ap,ac_master am where ap.ac_month_seq=ab.ac_month_seq and ab.ac_seq=am.ac_seq and am.type in ('E','R') and am.is_parent='N' and ap.start_date>=? and ap.start_date<=? group by ab.ac_seq", conn);
    }

    public static ArrayList getBfBalances(Timestamp end_date, ArrayList ac_seqs) {
        String sql = "select acb.ac_seq as ac_seq,sum(acb.debit+acb.adj_debit-acb.credit-acb.adj_credit) as balance from ac_balance acb,ac_month acm where acb.ac_month_seq=acm.ac_month_seq and acm.end_date<=? and acb.ac_seq in" + DBUtil.getSQLInValues(ac_seqs) + " group by acb.ac_seq";
        return DBUtil.select(new String[]{"AC_SEQ", "BALANCE"}, new int[]{4, 8}, new Object[]{end_date}, new int[]{93}, sql);
    }

    public static ArrayList getPeriodBalances(Timestamp start_end_date, Timestamp end_end_date, ArrayList ac_seqs) {
        String sql = "select acb.ac_seq,sum(acb.debit-acb.credit) as balance from ac_balance acb,ac_month acm,ac_master am where acb.ac_seq=am.ac_seq and acb.ac_month_seq=acm.ac_month_seq and acm.end_date>=? and acm.end_date<=? and acb.ac_seq in" + DBUtil.getSQLInValues(ac_seqs) + " group by acb.ac_seq,am.id" + " order by am.id";
        return DBUtil.run(sql, new Object[]{start_end_date, end_end_date});
    }
}

