/*
 * Decompiled with CFR 0.152.
 */
package account;

import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.util.ArrayList;
import system.SystemCode;
import util.RecordList;
import util.Tools;

public class Account {
    private int g_Ac_seq = -1;
    private String g_Id = "";
    private String g_Is_parent = "";
    private String g_Name = "";
    private int g_Parent_ac_seq = -1;
    private String g_Type = "";
    private String g_Remark = "";

    public Account() {
    }

    public Account(int ac_seq) {
        this.g_Ac_seq = ac_seq;
        this.load();
    }

    public int getAc_seq() {
        return this.g_Ac_seq;
    }

    public String getId() {
        return this.g_Id;
    }

    public String getIs_parent() {
        return this.g_Is_parent;
    }

    public String getName() {
        return this.g_Name;
    }

    public int getParent_ac_seq() {
        return this.g_Parent_ac_seq;
    }

    public String getType() {
        return this.g_Type;
    }

    public String getRemark() {
        return this.g_Remark;
    }

    private void load() {
        String sql = "select * from ac_master where ac_seq=?";
        RecordList r = DBUtil.run(sql, new Integer(this.g_Ac_seq));
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Id = r.getS("id");
            this.g_Is_parent = r.getS("is_parent");
            this.g_Name = r.getS("name");
            this.g_Parent_ac_seq = r.getI("parent_ac_seq");
            this.g_Type = r.getS("type");
            this.g_Remark = r.getS("remark");
        }
    }

    public static int insert(String id, String is_parent, String name, int parent_ac_seq, String type, String remark) {
        String sql = "insert into ac_master( ac_seq,id,is_parent,name,parent_ac_seq,type,remark)values(?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int ac_seq = DBUtil.getNextValueFor("ac_seq", conn);
        Object[] pvs = new Object[]{new Integer(ac_seq), id, is_parent, name, new Integer(parent_ac_seq), type, remark};
        DBUtil.run(sql, pvs, conn);
        conn.commit();
        return conn.isSuccessful() ? ac_seq : -1;
    }

    public static int update(int ac_seq, String id, String is_parent, String name, int parent_ac_seq, String type, String remark) {
        String sql = "update ac_master set id=?,is_parent=?,name=?,parent_ac_seq=?,type=?,remark=? where ac_seq=?";
        Object[] pvs = new Object[]{id, is_parent, name, new Integer(parent_ac_seq), type, remark, new Integer(ac_seq)};
        DBConn conn = new DBConn();
        DBUtil.run(sql, pvs, conn);
        conn.commit();
        return conn.isSuccessful() ? ac_seq : -1;
    }

    public static ArrayList getAllParentAccounts() {
        String sql = "select distinct ac_seq,id,id||' '||name as name from ac_master where is_parent='Y' order by id";
        return DBUtil.run(sql);
    }

    public static ArrayList getAllChildAccounts() {
        String sql = "select distinct ac_seq,id,id||' '||name as name from ac_master where is_parent='N' order by id";
        return DBUtil.run(sql);
    }

    public static ArrayList getAllAccounts() {
        String sql = "select ac_seq,id,name,type,is_parent,parent_ac_seq,remark from ac_master order by id";
        return DBUtil.run("select ac_seq,id,name,type,is_parent,parent_ac_seq,remark from ac_master order by id");
    }

    public static int getAc_seq(String id) {
        String sql = "select ac_seq from ac_master where id=?";
        RecordList r = DBUtil.run(sql, id);
        return !r.isEmpty() ? r.getI("ac_seq", 0) : -1;
    }

    public static boolean existChild(int ac_seq) {
        if (ac_seq == -1) {
            return false;
        }
        String sql = "select 'x' as col from ac_master where parent_ac_seq=?";
        RecordList r = DBUtil.run(sql, new Integer(ac_seq));
        return !r.isEmpty();
    }

    public static ArrayList search(String id, String name) {
        SQLWhereClause clause = new SQLWhereClause("where", new String[]{"lower(ac.ID) like lower(?)", "lower(ac.NAME) like lower(?)"}, new String[]{Tools.pad(id), Tools.pad(name)});
        String sql = "select ac_seq,id,name,type,remark from ac_master as ac" + clause.getConds() + " order by id" + " limit 1000";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            String accountType = r.getS("type");
            r.setS("type", SystemCode.getAccount(accountType));
            ++i;
        }
        return r;
    }

    public static ArrayList getAccountsOfPLRetainedGroup() {
        String sql = "select am.ac_seq,am.id ||' '||am.name as name from ac_master am  where  is_parent='N' and type='C' order by am.id";
        return DBUtil.run("select am.ac_seq,am.id ||' '||am.name as name from ac_master am  where  is_parent='N' and type='C' order by am.id");
    }
}

