/*
 * Decompiled with CFR 0.152.
 */
package venue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import system.User;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.DateTextField;
import ui.ScrollList2;
import ui.TableLayout;
import util.ArrayUtil;
import util.RecordList;
import util.Tools;
import venue.Venue;
import venue.VenueRequest;
import venue.VenueRequestInfoDialog;

public class VenueRequestListDialog
extends DataDialog {
    private JButton searchB;
    private JButton modifyB;
    private JButton addB;
    private JButton copyB;
    private ComboBoxNV venueNameNV;
    private ComboBoxCN requestStatusCN;
    private DateTextField start_dateDT;
    private DateTextField end_dateDT;
    private ScrollList2 listSL;
    private RecordList g_List = VenueRequest.search(-1, "", null, null);

    public VenueRequestListDialog(JFrame frame) {
        super(frame, "\u5834\u5730\u7533\u8acb\u5217\u8868", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setLayout() {
        this.venueNameNV = new ComboBoxNV((ArrayList)Venue.getVenueNames(), "name", "venue_seq", -1);
        this.requestStatusCN = this.getStatus();
        this.start_dateDT = new DateTextField();
        this.end_dateDT = new DateTextField();
        this.searchB = new JButton("\u641c\u5c0b");
        this.modifyB = new JButton("\u4fee\u6539/\u6aa2\u8996");
        this.addB = new JButton("\u65b0\u589e");
        this.copyB = new JButton("\u8907\u88fd");
        this.addB.setEnabled(User.hasPrivilege("venueRequestModify"));
        this.modifyB.setEnabled(User.hasPrivilege("venueRequestRead"));
        this.copyB.setEnabled(User.hasPrivilege("venueRequestModify"));
        this.listSL = new ScrollList2(560, 410, this.g_List, new int[]{80, 45, 45, 80, 90, 30, 65, 60, 45}, new String[]{"\u4f7f\u7528\u65e5\u671f", "\u958b\u59cb", "\u7d50\u675f", "\u5834\u5730", "\u4f7f\u7528\u7fa4\u7d44", "\u4eba\u6578", "\u7528\u9014", "\u7533\u8acb\u4eba", "\u73fe\u6cc1"}, new String[]{"date", "start_time", "end_time", "venue_name", "member_group_name", "user_num", "purpose", "member_name", "status"}, new boolean[9]);
        this.listSL.setDateTextFieldColumn("date");
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 250;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("\u4f7f\u7528\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDT, 1, 0, 20, 0);
        JLabel jLabel2 = new JLabel("\u81f3");
        t.getClass();
        t.addCell(jLabel2, 1, 0, 115, 0);
        t.getClass();
        t.addCell(this.end_dateDT, 1, 0, 140, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 3, 0, -1, 0, 115, -1);
        JLabel jLabel3 = new JLabel("\u5834\u5730");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.venueNameNV, 1, 1, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 3, 1, -1, 0, 115, -1);
        JLabel jLabel4 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 2, 1, 0);
        t.getClass();
        t.addCell(this.requestStatusCN, 1, 2, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.copyB, 3, 2, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{425});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    private ComboBoxCN getStatus() {
        String[][] status = new String[][]{Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__WA), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__AP), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__CL), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__RJ)};
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(status), "");
        c.hasNilItem(true);
        return c;
    }

    private void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onSearch(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onModify(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onAdd(evt);
            }
        });
        this.copyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onCopy(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        int venue_seq = this.venueNameNV.getSelectedIntValue();
        String status = this.requestStatusCN.getSelectedCode();
        RecordList r = VenueRequest.search(venue_seq, status, this.start_dateDT.getDate(), this.end_dateDT.getDate());
        this.listSL.refreshTable(r);
    }

    private void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int venue_request_seq = ArrayUtil.getInt("VENUE_REQUEST_SEQ", selrow, this.listSL.getTableData());
            VenueRequestInfoDialog venueRequestInfoDialog = new VenueRequestInfoDialog((DataDialog)this, venue_request_seq, true);
        }
    }

    public void onAdd(ActionEvent evt) {
        VenueRequestInfoDialog d = new VenueRequestInfoDialog((DataDialog)this, -1, false);
    }

    public void onCopy(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int venue_request_seq = ArrayUtil.getInt("VENUE_REQUEST_SEQ", selrow, this.listSL.getTableData());
            VenueRequestInfoDialog venueRequestInfoDialog = new VenueRequestInfoDialog((DataDialog)this, venue_request_seq, false);
        }
    }
}

