/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import system.Lang;
import ui.CheckBoxYN;
import ui.ComboBoxNV;
import ui.DateTextField;
import util.Arith;
import util.ArrayUtil;
import util.TimeUtil;
import util.Tools;

public class ScrollList
extends JScrollPane {
    private String[] g_ColKeys;
    private ScrollTable g_Table = new ScrollTable();
    private TableModel g_TableModel;

    public ScrollList(int width, int height, ArrayList data, int[] col_widths, String[] col_headers, String[] col_keys, boolean[] col_editable) {
        this.setViewportView(this.g_Table);
        this.setVerticalScrollBarPolicy(22);
        int i = 0;
        while (i < col_headers.length) {
            col_headers[i] = Lang.set(col_headers[i]);
            ++i;
        }
        this.g_ColKeys = col_keys;
        this.g_TableModel = new TableModel(data, col_headers, col_keys, col_editable);
        this.g_Table.setModel(this.g_TableModel);
        this.g_Table.setPreferredScrollableViewportSize(new Dimension(width, height));
        this.g_Table.getTableHeader().setReorderingAllowed(false);
        this.g_Table.setRowHeight(20);
        this.g_Table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        MultiLineHeaderRenderer mhr = new MultiLineHeaderRenderer();
        int i2 = 0;
        while (i2 < col_widths.length) {
            TableColumn tc = this.g_Table.getColumnModel().getColumn(i2);
            tc.setPreferredWidth(col_widths[i2]);
            tc.setHeaderRenderer(mhr);
            this.setTextFieldColumn(this.g_ColKeys[i2]);
            ++i2;
        }
    }

    public void setEditing_mode(boolean s) {
        this.g_Table.setEditing_mode(s);
    }

    public void setHorizontalScroll() {
        this.g_Table.setAutoResizeMode(0);
    }

    public void setMatchedRowProperties(String[] colNames, Object[] values, Color color, boolean editable) {
        this.g_TableModel.setMatchedRow(colNames, values);
        this.g_TableModel.setMatchRowEditable(editable);
        this.g_Table.setMatchedRowBgColor(color);
    }

    public void setColorColumn(String colName) {
    }

    public String getChangedColName(TableModelEvent evt) {
        if (evt.getColumn() != -1) {
            return this.g_ColKeys[evt.getColumn()];
        }
        return "";
    }

    public void addActionListener(TableModelListener c) {
        this.g_TableModel.addTableModelListener(c);
    }

    public ArrayList getTableData() {
        return this.g_TableModel.getTableData();
    }

    public int getSelectedRow() {
        return this.g_Table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.g_Table.getSelectedRows();
    }

    public JTableHeader getTableHeader() {
        return this.g_Table.getTableHeader();
    }

    public void setSelectedRow(int row, int col) {
        this.g_Table.changeSelection(row, col, false, false);
    }

    public void fireDataChanged() {
        this.g_TableModel.fireTableDataChanged();
    }

    public void refreshTable() {
        this.g_TableModel.refreshTable();
    }

    public void refreshTable(ArrayList v) {
        this.g_TableModel.refreshTable(v);
    }

    private int getColIndexByKey(String col_key) {
        int i = 0;
        while (i < this.g_ColKeys.length) {
            if (this.g_ColKeys[i].equals(col_key)) {
                return i;
            }
            ++i;
        }
        Tools.writeError("no " + col_key + " to set the ScrollList column type");
        return -1;
    }

    public void setTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.g_Table.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new TextFieldEditor(new TextField()));
        tc.setCellRenderer(new TextField());
    }

    public void setIntegerTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.g_Table.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new IntegerTextFieldEditor(new IntegerTextField()));
        tc.setCellRenderer(new IntegerTextField());
    }

    public void setBigDecimalTextFieldColumn(String col_key) {
        this.setBigDecimalTextFieldColumn(col_key, true);
    }

    public void setBigDecimalTextFieldColumn(String col_key, boolean show2DP) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.g_Table.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new BigDecimalTextFieldEditor(new BigDecimalTextField(show2DP)));
        tc.setCellRenderer(new BigDecimalTextField(show2DP));
    }

    public void setDateTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.g_Table.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new DateTextFieldEditor(new DateTextField()));
        DateTextField f = new DateTextField();
        f.setEmptyBorder();
        tc.setCellRenderer(f);
    }

    public void setTimeTextFieldColumn(String col_key, Timestamp date_part) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.g_Table.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new TimeTextFieldEditor(new TimeTextField(date_part)));
        tc.setCellRenderer(new TimeTextField(date_part));
    }

    public void setDateTimeTextFieldColumn(String col_key) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.g_Table.getColumnModel().getColumn(colIndex);
        tc.setCellEditor(new DateTimeTextFieldEditor(new DateTimeTextField()));
        tc.setCellRenderer(new DateTimeTextField());
    }

    public void setComboxNVColumn(String col_key, ComboBoxNV editor) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.g_Table.getColumnModel().getColumn(colIndex);
        editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        ComboBoxNV renderer = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(editor);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            renderer = (ComboBoxNV)ois.readObject();
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        tc.setCellEditor(new ComboBoxNVEditor(editor));
        tc.setCellRenderer(renderer);
    }

    public void setCheckBoxYNColumn(String col_key, String true_value, String false_value) {
        int colIndex = this.getColIndexByKey(col_key);
        if (colIndex == -1) {
            return;
        }
        TableColumn tc = this.g_Table.getColumnModel().getColumn(colIndex);
        CheckBoxYN editor = new CheckBoxYN(true_value, false_value, "");
        CheckBoxYN renderer = new CheckBoxYN(true_value, false_value, "");
        tc.setCellEditor(new CheckBoxYNEditor(editor));
        tc.setCellRenderer(renderer);
    }

    class BigDecimalTextField
    extends JTextField
    implements TableCellRenderer {
        boolean gShow2DP = true;

        public BigDecimalTextField(boolean show2DP) {
            this.gShow2DP = show2DP;
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        public boolean getShow2DP() {
            return this.gShow2DP;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(this.gShow2DP ? Arith.formatAmount(((BigDecimal)item_value).doubleValue()) : Arith.formatDouble(((BigDecimal)item_value).doubleValue()));
            return this;
        }
    }

    class BigDecimalTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private BigDecimalTextField g_TextField;

        public BigDecimalTextFieldEditor(BigDecimalTextField tf) {
            this.g_TextField = tf;
        }

        @Override
        public Object getCellEditorValue() {
            try {
                Double.parseDouble(this.g_TextField.getText());
                return new BigDecimal(this.g_TextField.getText());
            }
            catch (NumberFormatException e) {
                return new BigDecimal(0);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.g_TextField.setText(Arith.formatDouble(((BigDecimal)value).doubleValue()));
            this.fireEditingStopped();
            return this.g_TextField;
        }
    }

    class CheckBoxYNEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private CheckBoxYN g_CheckBox;

        public CheckBoxYNEditor(CheckBoxYN box) {
            this.g_CheckBox = box;
        }

        @Override
        public Object getCellEditorValue() {
            return this.g_CheckBox.isSelected() ? this.g_CheckBox.getTrue_value() : this.g_CheckBox.getFalse_value();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.g_CheckBox.setSelected(value.equals(this.g_CheckBox.getTrue_value()));
            return this.g_CheckBox;
        }
    }

    class ComboBoxNVEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComboBoxNV g_ComboBoxNV;

        public ComboBoxNVEditor(ComboBoxNV box) {
            this.g_ComboBoxNV = box;
        }

        @Override
        public Object getCellEditorValue() {
            return this.g_ComboBoxNV.getSelectedObjectValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.g_ComboBoxNV.setSelectedItem(value);
            this.fireEditingStopped();
            return this.g_ComboBoxNV;
        }
    }

    class DateTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private DateTextField g_TextField;

        public DateTextFieldEditor(DateTextField tf) {
            this.g_TextField = tf;
            this.g_TextField.setEmptyBorder();
        }

        @Override
        public Object getCellEditorValue() {
            return TimeUtil.getDateByString(this.g_TextField.getText());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.g_TextField.setValue(TimeUtil.getStringByDate((Timestamp)value));
            this.fireEditingStopped();
            return this.g_TextField;
        }
    }

    class DateTimeTextField
    extends JTextField
    implements TableCellRenderer {
        public DateTimeTextField() {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(TimeUtil.getStringByDateTime((Timestamp)item_value));
            return this;
        }
    }

    class DateTimeTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private DateTimeTextField g_TextField;

        public DateTimeTextFieldEditor(DateTimeTextField tf) {
            this.g_TextField = tf;
        }

        @Override
        public Object getCellEditorValue() {
            StringTokenizer st = new StringTokenizer(this.g_TextField.getText(), " ");
            return TimeUtil.getDateByString(st.nextToken(), st.nextToken());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.g_TextField.setText(TimeUtil.getStringByDateTime((Timestamp)value));
            this.fireEditingStopped();
            return this.g_TextField;
        }
    }

    class IntegerTextField
    extends JTextField
    implements TableCellRenderer {
        public IntegerTextField() {
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(String.valueOf(item_value));
            return this;
        }
    }

    class IntegerTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private IntegerTextField gTextField;

        public IntegerTextFieldEditor(IntegerTextField tf) {
            this.gTextField = tf;
        }

        @Override
        public Object getCellEditorValue() {
            try {
                Integer.parseInt(this.gTextField.getText());
                return new Integer(this.gTextField.getText());
            }
            catch (NumberFormatException e) {
                return new Integer(0);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.gTextField.setText(String.valueOf(value));
            this.fireEditingStopped();
            return this.gTextField;
        }
    }

    public class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        public MultiLineHeaderRenderer() {
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            ListCellRenderer renderer = this.getCellRenderer();
            ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
            this.setCellRenderer(renderer);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            String str = value == null ? "" : value.toString();
            BufferedReader br = new BufferedReader(new StringReader(str));
            Vector<String> v = new Vector<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    v.addElement(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.setListData(v);
            return this;
        }
    }

    class ScrollTable
    extends JTable {
        private boolean g_Editing_mode = false;
        private Color g_MatchedRowBgColor = null;

        ScrollTable() {
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (this.g_Editing_mode) {
                if (this.isRowSelected(row) && this.isColumnSelected(column)) {
                    c.setForeground(Color.BLACK);
                    c.setBackground(Color.YELLOW);
                } else {
                    c.setForeground(Color.BLACK);
                    if (this.g_MatchedRowBgColor != null && ((TableModel)this.getModel()).isRowMatched(row)) {
                        c.setBackground(this.g_MatchedRowBgColor);
                    } else {
                        c.setBackground(Color.WHITE);
                    }
                }
            } else if (this.isRowSelected(row)) {
                c.setForeground(Color.BLACK);
                c.setBackground(Color.lightGray);
            } else {
                c.setForeground(Color.BLACK);
                if (this.g_MatchedRowBgColor != null && ((TableModel)this.getModel()).isRowMatched(row)) {
                    c.setBackground(this.g_MatchedRowBgColor);
                } else {
                    c.setBackground(Color.WHITE);
                }
            }
            return c;
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component c = super.prepareEditor(editor, row, column);
            if (c instanceof JTextComponent) {
                ((JTextField)c).selectAll();
            }
            return c;
        }

        public void setEditing_mode(boolean s) {
            this.g_Editing_mode = s;
        }

        public boolean getEditing_mode() {
            return this.g_Editing_mode;
        }

        public void setMatchedRowBgColor(Color color) {
            this.g_MatchedRowBgColor = color;
        }
    }

    public class TableModel
    extends AbstractTableModel {
        private String[] g_ColKeys;
        private String[] g_ColHeaders;
        private boolean[] g_ColEditable;
        private String[] g_MatchRowCols;
        private Object[] g_MatchRowValues;
        private boolean g_MatchedRowEditable = true;
        private ArrayList g_Data = null;

        public TableModel(ArrayList v, String[] headers, String[] keys) {
            this.g_Data = v;
            this.g_ColHeaders = headers;
            this.g_ColKeys = keys;
        }

        public TableModel(ArrayList v, String[] headers, String[] keys, boolean[] editable) {
            this.g_Data = v;
            this.g_ColHeaders = headers;
            this.g_ColKeys = keys;
            this.g_ColEditable = editable;
            this.g_MatchRowCols = new String[0];
            this.g_MatchRowValues = new Object[0];
        }

        public void setMatchedRow(String[] colNames, Object[] values) {
            this.g_MatchRowCols = colNames;
            this.g_MatchRowValues = values;
        }

        public void setMatchRowEditable(boolean editable) {
            this.g_MatchedRowEditable = editable;
        }

        public boolean isRowMatched(int row) {
            if (this.g_MatchRowCols.length == 0) {
                return false;
            }
            int i = 0;
            while (i < this.g_MatchRowCols.length) {
                if (!ArrayUtil.getObject(this.g_MatchRowCols[i], row, this.g_Data).equals(this.g_MatchRowValues[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public int getColumnCount() {
            return this.g_ColHeaders.length;
        }

        @Override
        public int getRowCount() {
            return this.g_Data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.g_ColHeaders[col];
        }

        public String getColumnKey(int col) {
            return this.g_ColKeys[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            String key = this.g_ColKeys[col];
            return ArrayUtil.getObject(key, row, this.g_Data);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ArrayUtil.setObject(this.g_ColKeys[col], obj, row, this.g_Data);
            this.fireTableCellUpdated(row, col);
        }

        public void refreshTable() {
            this.fireTableDataChanged();
        }

        public void refreshTable(ArrayList v) {
            this.g_Data = v;
            this.fireTableDataChanged();
        }

        public ArrayList getTableData() {
            return this.g_Data;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            int i = 0;
            while (i < this.g_MatchRowCols.length) {
                if (!ArrayUtil.getObject(this.g_MatchRowCols[i], row, this.g_Data).equals(this.g_MatchRowValues[i])) break;
                if (i == this.g_MatchRowCols.length - 1) {
                    return this.g_MatchedRowEditable;
                }
                ++i;
            }
            return this.g_ColEditable[col];
        }

        public Class getColumnClass(int c) {
            Class<?> cl;
            try {
                cl = this.getValueAt(0, c).getClass();
            }
            catch (Exception e) {
                cl = "".getClass();
            }
            return cl;
        }
    }

    class TextField
    extends JTextField
    implements TableCellRenderer {
        public TextField() {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(item_value == null ? "" : item_value.toString());
            return this;
        }
    }

    class TextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TextField g_TextField;

        public TextFieldEditor(TextField tf) {
            this.g_TextField = tf;
        }

        @Override
        public Object getCellEditorValue() {
            return this.g_TextField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.g_TextField.setText(value == null ? "" : value.toString());
            this.fireEditingStopped();
            return this.g_TextField;
        }
    }

    class TimeTextField
    extends JTextField
    implements TableCellRenderer {
        private Timestamp g_Date_part;

        public TimeTextField(Timestamp date_part) {
            this.g_Date_part = date_part;
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        public Timestamp getDate_part() {
            return this.g_Date_part;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object item_value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(TimeUtil.getStringByTime((Timestamp)item_value));
            return this;
        }
    }

    class TimeTextFieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TimeTextField g_TextField;

        public TimeTextFieldEditor(TimeTextField tf) {
            this.g_TextField = tf;
        }

        @Override
        public Object getCellEditorValue() {
            String date = TimeUtil.getStringByDate(this.g_TextField.getDate_part());
            return TimeUtil.getDateByString(date, this.g_TextField.getText());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.g_TextField.setText(TimeUtil.getStringByTime((Timestamp)value));
            this.fireEditingStopped();
            return this.g_TextField;
        }
    }
}

