/*
 * Decompiled with CFR 0.152.
 */
package member;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.Barcode39;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import member.Member;
import system.Config;
import system.SystemCode;
import util.ArrayUtil;
import util.Tools;

public class MemberCardPrintout {
    private float g_Page_hMargin = 0.0f;
    private float g_Page_vMargin = 0.0f;
    private float g_Card_width = 0.0f;
    private float g_Card_height = 0.0f;
    private float g_Card_gap_height = 0.0f;
    private String g_Card_front_bg_path = "";
    private String g_Card_back_bg_path = "";
    private float g_Front_empty_cell_height = 0.0f;
    private float g_Front_name_chi_cell_height = 0.0f;
    private float g_Front_name_eng_cell_height = 0.0f;
    private float g_Front_barcode_cell_height = 0.0f;
    private float g_Front_member_id_cell_height = 0.0f;
    private float g_Front_name_chi_in_card_hAlign = 0.0f;
    private float g_Front_name_chi_in_card_vAlign = 0.0f;
    private float g_Front_name_eng_in_card_hAlign = 0.0f;
    private float g_Front_name_eng_in_card_vAlign = 0.0f;
    private float g_Front_name_chi_char_spacing = 0.0f;
    private float g_Front_name_eng_word_spacing = 0.0f;
    private float g_Front_name_eng_padding = 0.0f;
    private float g_Front_barcode_left_padding = 0.0f;
    private float g_Front_barcode_right_padding = 0.0f;
    private float g_Front_member_id_left_padding = 0.0f;
    private float g_Front_member_id_right_padding = 0.0f;
    private float g_Front_name_chi_font_size = 0.0f;
    private float g_Front_name_eng_font_size = 0.0f;
    private float g_Front_member_id_font_size = 0.0f;
    private float g_Back_empty_cell_height = 0.0f;
    private float g_Back_text_cell_height = 0.0f;
    private float g_Back_text_left_padding = 0.0f;
    private float g_Back_text_right_padding = 0.0f;
    private float g_Back_text_font_size = 0.0f;
    private float g_Barcode_width = 0.0f;
    private float g_Barcode_multiplier = 0.0f;
    private float g_Barcode_height = 0.0f;
    private float g_Photo_width = 0.0f;
    private float g_Photo_height = 0.0f;
    private float g_Photo_in_card_hAlign = 0.0f;
    private float g_Photo_in_card_vAlign = 0.0f;
    private boolean g_Use_card_border = false;
    private boolean g_Use_test_border = false;
    private boolean g_Use_front_card_bg = true;
    private boolean g_Use_back_card_bg = true;
    private ArrayList g_Member_info = null;
    private Properties g_Config = null;
    private String g_Output_file = "";

    public MemberCardPrintout(String start_member_id, String end_member_id, ArrayList member_seqs) {
        this.g_Member_info = Member.getMemberCardInfo(start_member_id, end_member_id, member_seqs, "");
        this.g_Output_file = String.valueOf(System.getProperty("java.io.tmpdir")) + String.valueOf(System.currentTimeMillis()) + ".pdf";
        this.g_Config = new Properties();
        try {
            this.g_Config.load(new FileInputStream("config/member_card_config.txt"));
        }
        catch (IOException e) {
            Tools.writeError(e.getMessage());
        }
        this.g_Page_hMargin = this.getFloatFromConfig("page_hMargin") * 72.0f;
        this.g_Page_vMargin = this.getFloatFromConfig("page_vMargin") * 72.0f;
        this.g_Card_width = this.getFloatFromConfig("card_width") * 72.0f;
        this.g_Card_height = this.getFloatFromConfig("card_height") * 72.0f;
        this.g_Card_gap_height = this.getFloatFromConfig("card_gap_height") * 72.0f;
        this.g_Card_front_bg_path = "image/" + this.getStringFromConfig("card_front_bg_path");
        this.g_Card_back_bg_path = "image/" + this.getStringFromConfig("card_back_bg_path");
        this.g_Front_empty_cell_height = this.getFloatFromConfig("front_empty_cell_height") * 72.0f;
        this.g_Front_name_chi_cell_height = this.getFloatFromConfig("front_name_chi_cell_height") * 72.0f;
        this.g_Front_name_eng_cell_height = this.getFloatFromConfig("front_name_eng_cell_height") * 72.0f;
        this.g_Front_barcode_cell_height = this.getFloatFromConfig("front_barcode_cell_height") * 72.0f;
        this.g_Front_member_id_cell_height = this.getFloatFromConfig("front_member_id_cell_height") * 72.0f;
        this.g_Front_name_chi_in_card_hAlign = this.getFloatFromConfig("front_name_chi_in_card_hAlign") * 72.0f;
        this.g_Front_name_chi_in_card_vAlign = this.getFloatFromConfig("front_name_chi_in_card_vAlign") * 72.0f;
        this.g_Front_name_eng_in_card_hAlign = this.getFloatFromConfig("front_name_eng_in_card_hAlign") * 72.0f;
        this.g_Front_name_eng_in_card_vAlign = this.getFloatFromConfig("front_name_eng_in_card_vAlign") * 72.0f;
        this.g_Front_name_chi_char_spacing = this.getFloatFromConfig("front_name_chi_char_spacing");
        this.g_Front_name_eng_word_spacing = this.getFloatFromConfig("front_name_chi_char_spacing");
        this.g_Front_name_eng_padding = this.getFloatFromConfig("front_name_eng_padding") * 72.0f;
        this.g_Front_barcode_left_padding = this.getFloatFromConfig("front_barcode_left_padding") * 72.0f;
        this.g_Front_barcode_right_padding = this.getFloatFromConfig("front_barcode_right_padding") * 72.0f;
        this.g_Front_member_id_left_padding = this.getFloatFromConfig("front_member_id_left_padding") * 72.0f;
        this.g_Front_member_id_right_padding = this.getFloatFromConfig("front_member_id_right_padding") * 72.0f;
        this.g_Front_name_chi_font_size = this.getFloatFromConfig("front_name_chi_font_size");
        this.g_Front_name_eng_font_size = this.getFloatFromConfig("front_name_eng_font_size");
        this.g_Front_member_id_font_size = this.getFloatFromConfig("front_member_id_font_size");
        this.g_Back_empty_cell_height = this.getFloatFromConfig("back_empty_cell_height") * 72.0f;
        this.g_Back_text_cell_height = this.getFloatFromConfig("back_text_cell_height") * 72.0f;
        this.g_Back_text_left_padding = this.getFloatFromConfig("back_text_left_padding") * 72.0f;
        this.g_Back_text_right_padding = this.getFloatFromConfig("back_text_right_padding") * 72.0f;
        this.g_Back_text_font_size = this.getFloatFromConfig("back_text_font_size") * 72.0f;
        this.g_Barcode_width = this.getFloatFromConfig("barcode_width");
        this.g_Barcode_multiplier = this.getFloatFromConfig("barcode_multiplier");
        this.g_Barcode_height = this.getFloatFromConfig("barcode_height");
        this.g_Photo_width = this.getFloatFromConfig("photo_width") * 72.0f;
        this.g_Photo_height = this.getFloatFromConfig("photo_height") * 72.0f;
        this.g_Photo_in_card_hAlign = this.getFloatFromConfig("photo_in_card_hAlign") * 72.0f;
        this.g_Photo_in_card_vAlign = this.getFloatFromConfig("photo_in_card_vAlign") * 72.0f;
        this.g_Use_card_border = this.getBooleanFromConfig("use_card_border");
        this.g_Use_test_border = this.getBooleanFromConfig("use_test_border");
        this.g_Use_front_card_bg = this.getBooleanFromConfig("use_front_card_bg");
        this.g_Use_back_card_bg = this.getBooleanFromConfig("use_back_card_bg");
    }

    private float getFloatFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return Float.valueOf(value).floatValue();
        }
        return 0.0f;
    }

    private String getStringFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return value;
        }
        return "";
    }

    private boolean getBooleanFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        return value != null && value.equals("Y");
    }

    public boolean genFile() {
        int card_per_page = 4;
        if (this.g_Member_info.size() == 0) {
            return false;
        }
        Document document = new Document(PageSize.A4, this.g_Page_hMargin, this.g_Page_hMargin, this.g_Page_vMargin, this.g_Page_vMargin);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.g_Output_file));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            String fontFile = Config.getS(Config.lang).equals(SystemCode.LANG__TC) ? "bsmi00lp.ttf" : "gbsn00lp.ttf";
            BaseFont bf = BaseFont.createFont((String)("webtool/font/" + fontFile), (String)"Identity-H", (boolean)true);
            BaseFont bf_eng = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            Image card_front_bg = null;
            Image card_back_bg = null;
            if (this.g_Use_front_card_bg) {
                card_front_bg = Image.getInstance((String)this.g_Card_front_bg_path);
                card_front_bg.scaleToFit(this.g_Card_width, this.g_Card_height);
            }
            if (this.g_Use_back_card_bg) {
                card_back_bg = Image.getInstance((String)this.g_Card_back_bg_path);
                card_back_bg.scaleToFit(this.g_Card_width, this.g_Card_height);
            }
            int border_size = 0;
            if (this.g_Use_test_border) {
                border_size = 1;
            }
            int j = 0;
            int ttl_card = this.g_Member_info.size();
            while (j < ttl_card) {
                document.newPage();
                int cards_this_page = Math.min(card_per_page, ttl_card - j);
                PdfPTable page_table = new PdfPTable(2);
                page_table.setTotalWidth(new float[]{this.g_Card_width, this.g_Card_width});
                page_table.setWidthPercentage(100.0f);
                page_table.setLockedWidth(true);
                page_table.getDefaultCell().setPadding(0.0f);
                if (!this.g_Use_card_border) {
                    page_table.getDefaultCell().setBorder(border_size);
                }
                PdfPCell card_gap_cell = new PdfPCell();
                card_gap_cell.setFixedHeight(this.g_Card_gap_height);
                card_gap_cell.setBorder(border_size);
                int i = 0;
                while (i < cards_this_page) {
                    int member_seq = ArrayUtil.getInt("MEMBER_SEQ", j + i, this.g_Member_info);
                    String member_id = ArrayUtil.getString("MEMBER_ID", j + i, this.g_Member_info);
                    String name_eng = ArrayUtil.getString("NAME_ENG", j + i, this.g_Member_info);
                    String name_chi = ArrayUtil.getString("NAME_CHI", j + i, this.g_Member_info);
                    float front_bg_xpos = this.g_Page_hMargin;
                    float front_bg_ypos = (float)(card_per_page - (i + 1)) * (this.g_Card_height + this.g_Card_gap_height) + this.g_Page_vMargin;
                    if (this.g_Use_front_card_bg) {
                        card_front_bg.setAbsolutePosition(front_bg_xpos, front_bg_ypos);
                        document.add((Element)card_front_bg);
                    }
                    float back_bg_xpos = this.g_Page_hMargin + this.g_Card_width;
                    float back_bg_ypos = front_bg_ypos;
                    if (this.g_Use_back_card_bg) {
                        card_back_bg.setAbsolutePosition(back_bg_xpos, back_bg_ypos);
                        document.add((Element)card_back_bg);
                    }
                    float name_chi_xpos = front_bg_xpos + this.g_Front_name_chi_in_card_hAlign;
                    float name_chi_ypos = front_bg_ypos + this.g_Front_name_chi_in_card_vAlign;
                    cb.beginText();
                    cb.setFontAndSize(bf, this.g_Front_name_chi_font_size);
                    cb.setCharacterSpacing(this.g_Front_name_chi_char_spacing);
                    cb.showTextAligned(1, name_chi, name_chi_xpos, name_chi_ypos, 0.0f);
                    cb.setCharacterSpacing(0.0f);
                    cb.moveTextWithLeading(72.0f, 0.0f);
                    cb.endText();
                    boolean show_photo = false;
                    String photo_location = "image/member_photo/" + member_seq + ".jpg";
                    try {
                        File f = new File(photo_location);
                        if (f.exists()) {
                            show_photo = true;
                        }
                    }
                    catch (SecurityException e) {
                        Tools.writeError(e.toString());
                    }
                    if (show_photo) {
                        Image photo = Image.getInstance((String)photo_location);
                        photo.scaleAbsolute(this.g_Photo_width, this.g_Photo_height);
                        float photo_xpos = front_bg_xpos + this.g_Photo_in_card_hAlign;
                        float photo_ypos = front_bg_ypos + this.g_Photo_in_card_vAlign;
                        photo.setAbsolutePosition(photo_xpos, photo_ypos);
                        document.add((Element)photo);
                    }
                    PdfPTable card_front_table = new PdfPTable(1);
                    card_front_table.setTotalWidth(new float[]{this.g_Card_width});
                    card_front_table.setLockedWidth(true);
                    PdfPCell front_empty = new PdfPCell();
                    front_empty.setFixedHeight(this.g_Front_empty_cell_height);
                    front_empty.setBorder(border_size);
                    PdfPCell name_cell = new PdfPCell(new Phrase(""));
                    name_cell.setPadding(0.0f);
                    name_cell.setFixedHeight(this.g_Front_name_chi_cell_height);
                    name_cell.setVerticalAlignment(5);
                    name_cell.setHorizontalAlignment(1);
                    name_cell.setBorder(border_size);
                    PdfPCell name_eng_cell = new PdfPCell(new Phrase(name_eng, new Font(bf_eng, this.g_Front_name_eng_font_size)));
                    name_eng_cell.setPadding(0.0f);
                    name_eng_cell.setFixedHeight(this.g_Front_name_eng_cell_height);
                    name_eng_cell.setVerticalAlignment(4);
                    name_eng_cell.setHorizontalAlignment(1);
                    name_eng_cell.setPaddingRight(this.g_Front_name_eng_padding);
                    name_eng_cell.setPaddingLeft(this.g_Front_name_eng_padding);
                    name_eng_cell.setBorder(border_size);
                    Barcode39 code = new Barcode39();
                    code.setCode(member_id);
                    code.setX(this.g_Barcode_width);
                    code.setN(this.g_Barcode_multiplier);
                    code.setBarHeight(this.g_Barcode_height);
                    code.setSize(0.0f);
                    code.setFont(null);
                    PdfPCell code_image = new PdfPCell(code.createImageWithBarcode(cb, null, null));
                    code_image.setFixedHeight(this.g_Front_barcode_cell_height);
                    code_image.setPadding(0.0f);
                    code_image.setVerticalAlignment(6);
                    code_image.setPaddingRight(this.g_Front_barcode_right_padding);
                    code_image.setHorizontalAlignment(1);
                    code_image.setBorder(border_size);
                    String print_member_id = "";
                    if (!member_id.equals("")) {
                        print_member_id = member_id;
                    }
                    PdfPCell code_text = new PdfPCell(new Phrase(print_member_id, FontFactory.getFont((String)"Helvetica", (float)this.g_Front_member_id_font_size)));
                    code_text.setFixedHeight(this.g_Front_member_id_cell_height);
                    code_text.setVerticalAlignment(4);
                    code_text.setPadding(0.0f);
                    code_text.setPaddingRight(this.g_Front_member_id_right_padding);
                    code_text.setHorizontalAlignment(1);
                    code_text.setBorder(border_size);
                    card_front_table.addCell(front_empty);
                    card_front_table.addCell(name_cell);
                    card_front_table.addCell(name_eng_cell);
                    card_front_table.addCell(code_image);
                    card_front_table.addCell(code_text);
                    PdfPTable card_back_table = new PdfPTable(1);
                    card_back_table.setTotalWidth(new float[]{this.g_Card_width});
                    card_back_table.setLockedWidth(true);
                    PdfPCell back_empty = new PdfPCell();
                    back_empty.setFixedHeight(this.g_Back_empty_cell_height);
                    back_empty.setBorder(border_size);
                    PdfPCell back_text = new PdfPCell(new Phrase("", new Font(bf, this.g_Back_text_font_size)));
                    back_text.setFixedHeight(this.g_Back_text_cell_height);
                    back_text.setVerticalAlignment(5);
                    back_text.setPadding(this.g_Back_text_left_padding);
                    back_text.setBorder(border_size);
                    card_back_table.addCell(back_empty);
                    card_back_table.addCell(back_text);
                    page_table.addCell(card_front_table);
                    page_table.addCell(card_back_table);
                    if (i != card_per_page - 1) {
                        page_table.addCell(card_gap_cell);
                        page_table.addCell(card_gap_cell);
                    }
                    ++i;
                }
                j += cards_this_page;
                document.add((Element)page_table);
            }
        }
        catch (DocumentException e1) {
            Tools.writeError(e1.getMessage());
        }
        catch (IOException e2) {
            Tools.writeError(e2.getMessage());
        }
        document.close();
        try {
            Runtime.getRuntime().exec("cmd.exe /c \"" + this.g_Output_file + "\"");
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        return true;
    }
}

