/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Lang;
import util.RecordList;
import util.TimeUtil;
import venue.Venue;
import venue.VenueRequest;
import venue.VenueRequestEquipment;

public class VenueRequestReport {
    public ExcelCellFormat FORMAT_WFAR = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.WF) + ExcelFormat.AR);
    public ExcelCellFormat FORMAT_BT = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BT);
    public ExcelCellFormat FORMAT_BD = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BD);
    public ExcelCellFormat FORMAT_AR = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.AR);
    public ExcelCellFormat FORMAT_ARBB = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.AR) + ExcelFormat.BB);
    public ExcelCellFormat FORMAT_WFBB = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.WF) + ExcelFormat.BB);
    private Timestamp gStartDate;
    private Timestamp gEndDate;
    private int gVenueSeq;

    public VenueRequestReport(Timestamp start_date, Timestamp end_date, int venue_seq) {
        this.gStartDate = start_date;
        this.gEndDate = end_date;
        this.gVenueSeq = venue_seq;
        RecordList vnrs = this.getVenueRequests();
        RecordList vnres = this.getVenueRequestEquipments();
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4, new int[]{25, 22, 22, 26, 28, 12, 22, 22});
        p.addHeader(Lang.set("Venue Reservation Report"), new String[]{String.valueOf(Lang.set("Date: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" to ") + TimeUtil.getStringByDate(end_date), String.valueOf(Lang.set("Venue: ")) + (this.gVenueSeq == -1 ? Lang.set("All") : new Venue(this.gVenueSeq).getName())});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("Date"), p.TL);
        p.addCell(1, row, Lang.set("Start"), p.TL);
        p.addCell(2, row, Lang.set("End"), p.TL);
        p.addCell(3, row, Lang.set("Venue"), p.TL);
        p.addCell(4, row, Lang.set("Use By"), p.TL);
        p.addCell(5, row, Lang.set("User#"), p.TL);
        p.addCell(6, row, Lang.set("Usage"), p.TL);
        p.addCell(7, row, Lang.set("Applicant"), p.TL);
        int i = 0;
        while (i < vnrs.size()) {
            vnrs.setCurrentRow(i);
            p.addCell(0, ++row, TimeUtil.getStringByDate(vnrs.getT("start_time")));
            p.addCell(1, row, TimeUtil.getStringByTime12(vnrs.getT("start_time")));
            p.addCell(2, row, TimeUtil.getStringByTime12(vnrs.getT("end_time")));
            p.addCell(3, row, vnrs.getS("venue"));
            p.addCell(4, row, vnrs.getS("mg_name"));
            p.addCell(5, row, vnrs.getI("user_num"));
            p.addCell(6, row, vnrs.getS("purpose"));
            p.addCell(7, row, vnrs.getS("name_chi"));
            RecordList eqs = vnres.getGroupItems(VenueRequestEquipment.VENUE_REQUEST_SEQ, vnrs.getI(VenueRequestEquipment.VENUE_REQUEST_SEQ));
            String eq = "";
            int j = 0;
            while (j < eqs.size()) {
                eqs.setCurrentRow(j);
                eq = String.valueOf(eq) + eqs.getS("name") + " " + eqs.getD("qty") + eqs.getS("unit") + ",";
                ++j;
            }
            eq = eq.equals("") ? "" : eq.substring(0, eq.length() - 1);
            p.addCell(0, ++row, Lang.set("Use Eq.:"), this.FORMAT_WFAR);
            p.addCell(1, row, 7, 1, eq, p.FORMAT_STRING);
            p.addCell(0, ++row, Lang.set("Remark:"), this.FORMAT_ARBB);
            p.addCell(1, row, 7, 1, vnrs.getS("remark"), this.FORMAT_WFBB);
            ++i;
        }
        p.genPrintout();
    }

    private RecordList getVenueRequests() {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"trunc(vnr.start_time,'DD')>=?", "trunc(vnr.end_time,'DD')<=?", "vnr.venue_seq=?"}, new Object[]{this.gStartDate, this.gEndDate, this.gVenueSeq});
        String sql = "select vnr.venue_request_seq,vnr.start_time,vnr.end_time,vnr.user_num,vnr.remark,vn.name as venue,mg.name as mg_name,mc.name as purpose,mb.name_chi from venue_request vnr,venue vn,member_group mg,master_code mc,member mb where vnr.venue_seq=vn.venue_seq and vnr.member_group_seq=mg.member_group_seq and vnr.purpose=mc.code and vnr.member_seq=mb.member_seq and vnr.status='" + VenueRequest.STATUS__AP + "'" + clause.getConds() + " order by vnr.start_time,vn.name";
        return DBUtil.run(sql, clause.getPrepValues());
    }

    private RecordList getVenueRequestEquipments() {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"trunc(vnr.start_time,'DD')>=?", "trunc(vnr.end_time,'DD')<=?", "vnr.venue_seq=?"}, new Object[]{this.gStartDate, this.gEndDate, this.gVenueSeq});
        String sql = "select vnre.venue_request_seq,vnre.qty,vne.name,vne.unit from venue_request vnr,venue_request_equipment vnre,venue_equipment vne where vnr.venue_request_seq=vnre.venue_request_seq and vnre.venue_equipment_seq=vne.venue_equipment_seq and vnr.status='" + VenueRequest.STATUS__AP + "'" + clause.getConds();
        return DBUtil.run(sql, clause.getPrepValues());
    }
}

