/*
 * Decompiled with CFR 0.152.
 */
package venue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.MemberGroup;
import member.MemberGroupMember;
import system.Config;
import system.MasterCode;
import system.User;
import ui.AutoComboBoxNV;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.DateTextField;
import ui.ScrollList2;
import ui.TableLayout;
import ui.TimeTextField;
import util.ArrayUtil;
import util.ComparableHashMap;
import util.RecordList;
import util.TimeUtil;
import util.Tools;
import util.Validation;
import util.WinUtil;
import venue.Venue;
import venue.VenueEquipment;
import venue.VenueRequest;
import venue.VenueRequestEquipment;
import venue.VenueRequestListDialog;

public class VenueRequestInfoDialog
extends DataDialog {
    private ComboBoxNV venueNV;
    private ComboBoxCN statusCN;
    private DateTextField dateDT;
    private TimeTextField start_timeTT;
    private TimeTextField end_timeTT;
    private ComboBoxNV member_groupNV;
    private ComboBoxCN purposeCN;
    private JTextField remarkTF;
    private JTextField user_numTF;
    private JTextField max_userTF;
    private AutoComboBoxNV memberNV;
    private DateTextField entry_dateDT;
    private ComboBoxNV add_equipment_idNV;
    private ScrollList2 itemSL;
    private JButton add_itemB;
    private JButton del_itemB;
    private JButton saveB;
    private JButton cancelB;
    private VenueRequest g_VenueRequest = null;
    private RecordList g_Items;
    private boolean g_isUpdate = false;

    public VenueRequestInfoDialog(DataDialog f, int venue_request_seq, boolean isUpdate) {
        super(f, "Add Venue Reservation", false);
        if (isUpdate) {
            this.setTitle("Edit Venue Reservation");
        }
        this.g_isUpdate = isUpdate;
        this.init(venue_request_seq);
    }

    public VenueRequestInfoDialog(DataDialog f, int venue_seq, int member_seq, Timestamp start_time, Timestamp end_time, int member_group_seq) {
        this.g_VenueRequest = new VenueRequest(-1);
        VenueRequestEquipment p = new VenueRequestEquipment(-1);
        this.g_Items = p.getItems();
        this.g_VenueRequest.newFromActivity(venue_seq, member_seq, start_time, end_time, member_group_seq, new Venue(venue_seq).getUser_capacity());
        this.initLayout();
    }

    private void init(int venue_request_seq) {
        this.g_VenueRequest = new VenueRequest(venue_request_seq);
        VenueRequestEquipment p = new VenueRequestEquipment(venue_request_seq);
        this.g_Items = p.getItems();
        if (!this.g_isUpdate && venue_request_seq != -1) {
            this.g_VenueRequest.resetForCopy();
            this.g_Items = new RecordList();
        }
        this.initLayout();
    }

    private void initLayout() {
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        this.venueNV = new ComboBoxNV((ArrayList)Venue.getVenueNames(), "name", "venue_seq", this.g_VenueRequest.getVenue_seq());
        this.statusCN = this.getStatusSel();
        this.dateDT = new DateTextField(this.g_VenueRequest.getStart_time());
        this.start_timeTT = new TimeTextField(this.g_VenueRequest.getStart_time());
        this.end_timeTT = new TimeTextField(this.g_VenueRequest.getEnd_time());
        RecordList mg = MemberGroup.getGroupNames(MemberGroup.getAllActiveGroups(this.g_VenueRequest.getMember_group_seq()), "name", "member_group_seq");
        this.member_groupNV = new ComboBoxNV((ArrayList)mg, "name", "member_group_seq", this.g_VenueRequest.getMember_group_seq());
        this.purposeCN = new ComboBoxCN(MasterCode.getCodes("VENUE_REQUEST_PURPOSE"), this.g_VenueRequest.getPurpose());
        this.remarkTF = new JTextField(this.g_VenueRequest.getRemark());
        this.user_numTF = new JTextField(String.valueOf(this.g_VenueRequest.getUser_num()));
        this.max_userTF = new JTextField(String.valueOf(new Venue(this.g_VenueRequest.getVenue_seq()).getUser_capacity()));
        this.memberNV = new AutoComboBoxNV((ArrayList)MemberGroupMember.getActiveMembersInGroup(MemberGroup.ROOT_GROUP_SEQ, this.g_VenueRequest.getMember_seq()), "list_item", "member_seq", this.g_VenueRequest.getMember_seq());
        this.entry_dateDT = new DateTextField(this.g_VenueRequest.getEntry_date() == null ? TimeUtil.getCurrentDate() : this.g_VenueRequest.getEntry_date());
        this.add_equipment_idNV = new ComboBoxNV((ArrayList)VenueRequest.getAvailableEquipments(this.g_VenueRequest.getVenue_seq(), this.g_VenueRequest.getVenue_request_seq(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput())), "name", "venue_equipment_seq", -1);
        this.max_userTF.setEnabled(false);
        if (this.g_Items.size() > 0) {
            this.dateDT.setEnabled(false);
            this.start_timeTT.setEnabled(false);
            this.end_timeTT.setEnabled(false);
        }
        this.add_itemB = new JButton("Add Eq.");
        this.del_itemB = new JButton("Del Eq.");
        this.saveB = new JButton("Save");
        this.cancelB = new JButton("Cancel");
        this.saveB.setEnabled(this.isSaveEnabled());
        TableLayout t = new TableLayout(this, 600, 600, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 250;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30, 30, 30, 30, 30});
        int row = 0;
        JLabel jLabel = new JLabel("Venue");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.venueNV, 1, row, 20, 0);
        JLabel jLabel2 = new JLabel("Status");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.statusCN, 3, row, 20, 0, 75, -1);
        ++row;
        JLabel jLabel3 = new JLabel("Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.dateDT, 1, row, 20, 0);
        t.getClass();
        t.addCell(this.start_timeTT, 1, row, 105, 0);
        JLabel jLabel4 = new JLabel("to");
        t.getClass();
        t.addCell(jLabel4, 1, row, 155, 0);
        t.getClass();
        t.addCell(this.end_timeTT, 1, row, 170, 0);
        ++row;
        JLabel jLabel5 = new JLabel("Use By");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.member_groupNV, 1, row, 20, 0, 200, -1);
        ++row;
        JLabel jLabel6 = new JLabel("Users#");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.user_numTF, 1, row, 20, 0, 50, -1);
        JLabel jLabel7 = new JLabel("Seats");
        t.getClass();
        t.addCell(jLabel7, 1, row, 70, 0);
        JLabel jLabel8 = new JLabel("(Max ");
        t.getClass();
        t.addCell(jLabel8, 1, row, 130, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.max_userTF, 1, row, 170, 0, 50, -1);
        JLabel jLabel9 = new JLabel(" Seats)");
        t.getClass();
        t.addCell(jLabel9, 1, row, 220, 0);
        ++row;
        JLabel jLabel10 = new JLabel("Usage");
        t.getClass();
        t.getClass();
        t.addCell(jLabel10, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.purposeCN, 1, row, 20, 0);
        JLabel jLabel11 = new JLabel("Apply Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel11, 2, row, 1, 0);
        t.getClass();
        t.addCell(this.entry_dateDT, 3, row, 20, 0);
        ++row;
        JLabel jLabel12 = new JLabel("Applicant");
        t.getClass();
        t.getClass();
        t.addCell(jLabel12, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.memberNV, 1, row, 20, 0, 460, -1);
        ++row;
        JLabel jLabel13 = new JLabel("Remark");
        t.getClass();
        t.getClass();
        t.addCell(jLabel13, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, row, 20, 0, 460, -1);
        ++row;
        JLabel jLabel14 = new JLabel("Equipment");
        t.getClass();
        t.getClass();
        t.addCell(jLabel14, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.add_equipment_idNV, 1, row, 20, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.add_itemB, 2, row, 1, 0);
        t.getClass();
        t.addCell(this.del_itemB, 3, row, 20, 0);
        boolean[] blArray = new boolean[4];
        blArray[2] = true;
        this.itemSL = new ScrollList2(560, 250, this.g_Items, new int[]{300, 80, 80, 80}, new String[]{"Eq.", "Max Qty", "Qty", "Unit"}, new String[]{VenueEquipment.NAME, "max_qty", VenueRequestEquipment.QTY, VenueEquipment.UNIT}, blArray);
        this.itemSL.setEditing_mode(true);
        this.itemSL.setBigDecimalTextFieldColumn("max_qty");
        this.itemSL.setBigDecimalTextFieldColumn(VenueRequestEquipment.QTY);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{250});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, 0, 0);
        t.addYSpace(15);
        t.addTable(new int[]{435, 70, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 1, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    private ComboBoxCN getStatusSel() {
        String[] wa = Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__WA);
        String[] ap = Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__AP);
        String[] cl = Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__CL);
        String[] rj = Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__RJ);
        int cur_privilege = User.hasPrivilege("venueRequestApprove") ? 1 : 0;
        int cur_status = 0;
        if (this.g_VenueRequest.getStatus().isEmpty()) {
            cur_status = 0;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__WA)) {
            cur_status = 1;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__AP)) {
            cur_status = 2;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__CL)) {
            cur_status = 3;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__RJ)) {
            cur_status = 4;
        }
        Object[][] smatrix = new Object[2][5];
        smatrix[0][0] = new String[][]{wa};
        smatrix[0][1] = new String[][]{wa, cl};
        smatrix[0][2] = new String[][]{ap};
        smatrix[0][3] = new String[][]{cl};
        smatrix[0][4] = new String[][]{rj};
        smatrix[1][0] = new String[][]{wa, ap};
        smatrix[1][1] = new String[][]{wa, ap, cl, rj};
        smatrix[1][2] = new String[][]{ap, cl, rj};
        smatrix[1][3] = new String[][]{cl};
        smatrix[1][4] = new String[][]{rj};
        String[][] result_status = (String[][])smatrix[cur_privilege][cur_status];
        String preSelected = this.g_VenueRequest.getStatus();
        if (preSelected.equals("")) {
            preSelected = User.hasPrivilege("venueRequestApprove") ? VenueRequest.STATUS__AP : VenueRequest.STATUS__WA;
        }
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(result_status), preSelected);
        c.hasNilItem(false);
        return c;
    }

    private boolean isSaveEnabled() {
        if (!User.hasPrivilege("venueRequestModify")) {
            return false;
        }
        int cur_privilege = User.hasPrivilege("venueRequestApprove") ? 1 : 0;
        int cur_status = 0;
        if (this.g_VenueRequest.getStatus().isEmpty()) {
            cur_status = 0;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__WA)) {
            cur_status = 1;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__AP)) {
            cur_status = 2;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__CL)) {
            cur_status = 3;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__RJ)) {
            cur_status = 4;
        }
        boolean[][] smatrix = new boolean[2][5];
        smatrix[0][0] = true;
        smatrix[0][1] = true;
        smatrix[0][2] = false;
        smatrix[0][3] = false;
        smatrix[0][4] = false;
        smatrix[1][0] = true;
        smatrix[1][1] = true;
        smatrix[1][2] = true;
        smatrix[1][3] = false;
        smatrix[1][4] = false;
        return smatrix[cur_privilege][cur_status];
    }

    private void setEventHandler() {
        this.venueNV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onChangeVenueCN(evt);
            }
        });
        this.add_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onAddItem(evt);
            }
        });
        this.del_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onDelItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onCancel(evt);
            }
        });
    }

    private void onChangeVenueCN(ActionEvent evt) {
        this.itemSL.getTableData().clear();
        this.itemSL.fireDataChanged();
        int venue_seq = this.venueNV.getSelectedIntValue();
        RecordList equipments = VenueRequest.getAvailableEquipments(venue_seq, this.g_VenueRequest.getVenue_request_seq(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput()));
        this.add_equipment_idNV.refreshItems(equipments);
        this.add_equipment_idNV.setItemSelected(-1);
        String user = String.valueOf(new Venue(venue_seq).getUser_capacity());
        this.max_userTF.setText(user);
        this.user_numTF.setText(user);
        this.dateDT.setEnabled(true);
        this.start_timeTT.setEnabled(true);
        this.end_timeTT.setEnabled(true);
    }

    private void onAddItem(ActionEvent evt) {
        int index = this.add_equipment_idNV.getSelectedIndex();
        int sel_vne_seq = this.add_equipment_idNV.getSelectedIntValue();
        RecordList r = this.itemSL.getTableData();
        Validation validation = new Validation();
        validation.add(index != 0, "Please select equipment", "RT");
        validation.add(r.indexOf(VenueEquipment.VENUE_EQUIPMENT_SEQ, new Integer(sel_vne_seq)) == -1, "The selected equipment is already added", "RT");
        validation.add(this.dateDT.getInput(), "Date", "R,D");
        validation.add(this.start_timeTT.getInput(), "Start Time", "R,T");
        validation.add(this.end_timeTT.getInput(), "End Time", "R,T");
        if (!validation.isValid()) {
            return;
        }
        RecordList equipments = VenueRequest.getAvailableEquipments(this.venueNV.getSelectedIntValue(), this.g_VenueRequest.getVenue_request_seq(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput()));
        int venue_equipment_seq = ArrayUtil.getInt(VenueEquipment.VENUE_EQUIPMENT_SEQ, --index, equipments);
        String equipment_name = ArrayUtil.getString(VenueEquipment.NAME, index, equipments);
        double max_qty = ArrayUtil.getDouble(VenueEquipment.QTY, index, equipments);
        String unit = ArrayUtil.getString(VenueEquipment.UNIT, index, equipments);
        ComparableHashMap h = new ComparableHashMap();
        h.put(VenueRequestEquipment.VENUE_REQUEST_EQUIPMENT_SEQ, new Integer(-1));
        h.put(VenueEquipment.NAME, equipment_name);
        h.put(VenueEquipment.VENUE_EQUIPMENT_SEQ, new Integer(venue_equipment_seq));
        h.put("max_qty", new BigDecimal(max_qty));
        h.put(VenueEquipment.QTY, new BigDecimal(0));
        h.put(VenueEquipment.UNIT, unit);
        r.add(h);
        this.itemSL.fireDataChanged();
        this.dateDT.setEnabled(false);
        this.start_timeTT.setEnabled(false);
        this.end_timeTT.setEnabled(false);
    }

    private void onDelItem(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        RecordList v = this.itemSL.getTableData();
        v.remove(sel_row);
        this.itemSL.fireDataChanged();
        if (v.size() == 0) {
            this.dateDT.setEnabled(true);
            this.start_timeTT.setEnabled(true);
            this.end_timeTT.setEnabled(true);
        }
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.venueNV.getSelectedIndex(), "Venue", "CBNVIR");
        validation.add(this.dateDT.getInput(), "Date", "R,D");
        validation.add(this.start_timeTT.getInput(), "Start Time", "R,T");
        validation.add(this.end_timeTT.getInput(), "End Time", "R,T");
        validation.add(this.member_groupNV.getSelectedIntValue(), "Use By", "CBNVIR");
        validation.add(this.purposeCN.getSelectedCode(), "Usage", "R");
        validation.add(this.user_numTF.getText(), "Users#", "R,I,GTZ");
        validation.add(this.memberNV.getSelectedIntValue(), "Applicant", "CBNVIR");
        validation.add(this.entry_dateDT.getInput(), "Apply Date", "R,D");
        int over_user = Integer.parseInt(this.user_numTF.getText()) - Integer.parseInt(this.max_userTF.getText());
        validation.add(over_user <= 0, "User# should not over capacity", "RT");
        RecordList items = this.itemSL.getTableData();
        int i = 0;
        while (i < items.size()) {
            items.setCurrentRow(i);
            double qty = items.getD(VenueRequestEquipment.QTY);
            validation.add(qty, "Item " + (i + 1) + " eq. qty", "R,F,GTZ");
            double max_qty = items.getD("max_qty");
            validation.add(max_qty - qty >= 0.0, "Item " + (i + 1) + " qty is more than max qty.", "RT");
            ++i;
        }
        if (!validation.isValid()) {
            return false;
        }
        String venueStartTime = TimeUtil.getStringByTime(Config.getT(Config.venueStartTime));
        String venueEndTime = TimeUtil.getStringByTime(Config.getT(Config.venueEndTime));
        RecordList overlaps = VenueRequest.getOverlappedRequests(this.g_VenueRequest.getVenue_request_seq(), this.venueNV.getSelectedIntValue(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput()));
        if (!overlaps.isEmpty()) {
            String msg = "Venue is occupied by:\n";
            int i2 = 0;
            while (i2 < overlaps.size()) {
                overlaps.setCurrentRow(i2);
                msg = String.valueOf(msg) + overlaps.getS("purpose") + " " + TimeUtil.getStringByDate(overlaps.getT("start_time")) + " " + TimeUtil.getStringByTime(overlaps.getT("start_time")) + "-" + TimeUtil.getStringByTime(overlaps.getT("end_time")) + "\n";
                ++i2;
            }
            WinUtil.showMessage(this, msg);
            return false;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        if (this.g_isUpdate) {
            VenueRequest.update(this.g_VenueRequest.getVenue_request_seq(), this.venueNV.getSelectedIntValue(), this.statusCN.getSelectedCode(), this.memberNV.getSelectedIntValue(), this.entry_dateDT.getDate(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput()), this.member_groupNV.getSelectedIntValue(), this.purposeCN.getSelectedCode(), this.remarkTF.getText(), Integer.parseInt(this.user_numTF.getText()), items);
        } else {
            VenueRequest.insert(this.venueNV.getSelectedIntValue(), this.statusCN.getSelectedCode(), this.memberNV.getSelectedIntValue(), this.entry_dateDT.getDate(), this.start_timeTT.getTime(this.dateDT.getInput()), this.end_timeTT.getTime(this.dateDT.getInput()), this.member_groupNV.getSelectedIntValue(), this.purposeCN.getSelectedCode(), this.remarkTF.getText(), Integer.parseInt(this.user_numTF.getText()), items);
        }
        ((VenueRequestListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

