/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import system.Config;
import system.Lang;
import system.SystemCode;
import util.RecordList;
import util.TimeUtil;
import util.Tools;
import venue.Venue;
import venue.VenueEquipment;
import venue.VenueRequestEquipment;

public class VenueRequest {
    private int g_Venue_request_seq = -1;
    private int g_Venue_seq = -1;
    private String g_Status = "";
    private int g_Member_seq = -1;
    private Timestamp g_Entry_date = null;
    private int g_Approve_user_seq = -1;
    private String g_Approve_name = "";
    private Timestamp g_Approve_date = null;
    private Timestamp g_Start_time = null;
    private Timestamp g_End_time = null;
    private int g_Member_group_seq = -1;
    private String g_Purpose = "";
    private String g_Remark = "";
    private int g_User_num = 0;
    private String g_Email_status = "";
    public static String STATUS__WA = "WA";
    public static String STATUS__AP = "AP";
    public static String STATUS__CL = "CL";
    public static String STATUS__RJ = "RJ";
    public static Object[] STATUS_MAP = new Object[]{new String[]{STATUS__WA, Lang.set("Pending")}, new String[]{STATUS__AP, Lang.set("Confirm")}, new String[]{STATUS__CL, Lang.set("Cancel")}, new String[]{STATUS__RJ, Lang.set("Reject")}};
    public static String EMAIL_STATUS__NA = "NA";
    public static String EMAIL_STATUS__TBS = "TBS";
    public static String EMAIL_STATUS__SENT = "SENT";
    public static Object[] EMAIL_STATUS_MAP = new Object[]{new String[]{EMAIL_STATUS__NA, Lang.set("N/A")}, new String[]{EMAIL_STATUS__TBS, Lang.set("Queueing")}, new String[]{EMAIL_STATUS__SENT, Lang.set("Sent")}};

    public VenueRequest() {
    }

    public VenueRequest(int venue_request_seq) {
        this.g_Venue_request_seq = venue_request_seq;
        this.load(null);
    }

    public int getVenue_request_seq() {
        return this.g_Venue_request_seq;
    }

    public int getVenue_seq() {
        return this.g_Venue_seq;
    }

    public String getStatus() {
        return this.g_Status;
    }

    public int getMember_seq() {
        return this.g_Member_seq;
    }

    public Timestamp getEntry_date() {
        return this.g_Entry_date;
    }

    public Timestamp getStart_time() {
        return this.g_Start_time;
    }

    public Timestamp getEnd_time() {
        return this.g_End_time;
    }

    public int getMember_group_seq() {
        return this.g_Member_group_seq;
    }

    public String getPurpose() {
        return this.g_Purpose;
    }

    public String getRemark() {
        return this.g_Remark;
    }

    public int getUser_num() {
        return this.g_User_num;
    }

    public String getEmail_status() {
        return this.g_Email_status;
    }

    public void resetForCopy() {
        this.g_Venue_request_seq = -1;
        this.g_Entry_date = null;
        this.g_Status = "";
    }

    public void newFromActivity(int venue_seq, int member_seq, Timestamp start_time, Timestamp end_time, int member_group_seq, int user_num) {
        this.g_Venue_seq = venue_seq;
        this.g_Member_seq = member_seq;
        this.g_Start_time = start_time;
        this.g_End_time = end_time;
        this.g_Member_group_seq = member_group_seq;
        this.g_User_num = user_num;
    }

    private void load(DBConn conn) {
        String sql = "select * from venue_request where venue_request_seq=?";
        RecordList r = DBUtil.run(sql, this.g_Venue_request_seq, conn);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Venue_seq = r.getI("venue_seq");
            this.g_Status = r.getS("status");
            this.g_Member_seq = r.getI("member_seq");
            this.g_Entry_date = r.getT("entry_date");
            this.g_Start_time = r.getT("start_time");
            this.g_End_time = r.getT("end_time");
            this.g_Member_group_seq = r.getI("member_group_seq");
            this.g_Purpose = r.getS("purpose");
            this.g_Remark = r.getS("remark");
            this.g_User_num = r.getI("user_num");
            this.g_Email_status = r.getS("email_status");
        }
    }

    public static int insert(int venue_seq, String status, int member_seq, Timestamp entry_date, Timestamp start_time, Timestamp end_time, int member_group_seq, String purpose, String remark, int user_num, RecordList request_equipment) {
        String sql = "insert into venue_request( venue_request_seq,venue_seq,status,member_seq,entry_date,start_time,end_time,member_group_seq,purpose,remark,user_num,email_status)values(?,?,?,?,?,?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int venue_request_seq = DBUtil.getNextValueFor("venue_request_seq", conn);
        String email_status = EMAIL_STATUS__NA;
        if (status.equals(STATUS__AP) && Config.getS(Config.enableEmail).equals(SystemCode.YN__Y)) {
            email_status = EMAIL_STATUS__TBS;
        }
        DBUtil.run(sql, new Object[]{new Integer(venue_request_seq), new Integer(venue_seq), status, new Integer(member_seq), entry_date, start_time, end_time, new Integer(member_group_seq), purpose, remark, new Integer(user_num), email_status}, conn);
        VenueRequestEquipment.update(venue_request_seq, request_equipment, conn);
        conn.commit();
        return conn.isSuccessful() ? venue_request_seq : -1;
    }

    public static int update(int venue_request_seq, int venue_seq, String status, int member_seq, Timestamp entry_date, Timestamp start_time, Timestamp end_time, int member_group_seq, String purpose, String remark, int user_num, RecordList request_equipment) {
        String sql = "update venue_request set venue_seq=?,status=?,member_seq=?,entry_date=?,start_time=?,end_time=?,member_group_seq=?,purpose=?,remark=?,user_num=?,email_status=? where venue_request_seq=?";
        String email_status = EMAIL_STATUS__NA;
        if ((status.equals(STATUS__AP) || status.equals(STATUS__RJ) || status.equals(STATUS__CL)) && Config.getS(Config.enableEmail).equals(SystemCode.YN__Y)) {
            email_status = EMAIL_STATUS__TBS;
        }
        DBConn conn = new DBConn();
        DBUtil.run(sql, new Object[]{new Integer(venue_seq), status, new Integer(member_seq), entry_date, start_time, end_time, new Integer(member_group_seq), purpose, remark, new Integer(user_num), email_status, new Integer(venue_request_seq)}, conn);
        VenueRequestEquipment.update(venue_request_seq, request_equipment, conn);
        conn.commit();
        return conn.isSuccessful() ? venue_request_seq : -1;
    }

    public static RecordList search(int venue_seq, String status, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"vr.venue_seq=?", "vr.status=?", "vr.start_time>=?", "vr.end_time<?"}, new Object[]{new Integer(venue_seq), status, start_date, TimeUtil.adjustDate(end_date, 1)});
        String sql = "select vr.venue_request_seq,vr.start_time as date,vr.start_time,vr.end_time,vr.user_num,vn.name as venue_name,mg.name as member_group_name,mc.name as purpose,mm.name_chi as member_name,vr.status from venue_request vr,venue vn,member mm,member_group mg,master_code mc where vr.venue_seq=vn.venue_seq and vr.member_group_seq=mg.member_group_seq and vr.member_seq=mm.member_seq and vr.purpose=mc.code" + clause.getConds() + " order by vr.start_time desc,vn.name" + " limit 1000";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            r.setS("status", Tools.getStatusName(STATUS_MAP, r.getS("status")));
            r.setS("start_time", TimeUtil.getStringByTime(r.getT("start_time")));
            r.setS("end_time", TimeUtil.getStringByTime(r.getT("end_time")));
            ++i;
        }
        return r;
    }

    public static RecordList getOverlappedRequests(int venue_request_seq, int venue_seq, Timestamp start_time, Timestamp end_time) {
        String sql = "select mc.name as purpose,vnr.start_time as start_time,vnr.end_time as end_time from venue_request vnr,master_code mc where vnr.venue_request_seq<>? and vnr.venue_seq=? and vnr.PURPOSE=mc.code and vnr.status<>'" + STATUS__CL + "'" + " and vnr.status<>'" + STATUS__RJ + "'" + " and(" + "  (?<=vnr.start_time and vnr.start_time<?)" + "  or" + "  (?<vnr.end_time and vnr.end_time<=?)" + "  or" + "  (vnr.start_time<=? and ?<=vnr.end_time)" + " )";
        return DBUtil.run(sql, new Object[]{new Integer(venue_request_seq), new Integer(venue_seq), start_time, end_time, start_time, end_time, start_time, end_time});
    }

    public static RecordList getAvailableEquipments(int venue_seq, int venue_request_seq, Timestamp start_time, Timestamp end_time) {
        String sql = "select venue_equipment_seq,venue_seq,name,desc,qty-coalesce(used.qty,0) as qty,unit from venue_equipment vne left join (select\t vnre.venue_equipment_seq\t,sum(vnre.qty) as qty\t from\t venue_request vnr\t,venue_request_equipment vnre\t,venue_equipment vne\t where   vnr.venue_request_seq<>?\t and vnre.venue_equipment_seq=vne.venue_equipment_seq\t and vne.venue_seq=" + Venue.FREE_EQUIPMENT_SEQ + "\t and vnr.venue_request_seq=vnre.venue_request_seq" + "   and vnr.status<>'" + STATUS__CL + "'" + "   and vnr.status<>'" + STATUS__RJ + "'" + "   and(" + "    (?<=vnr.start_time and vnr.start_time<?)" + "    or" + "    (?<vnr.end_time and vnr.end_time<=?)" + "    or" + "    (vnr.start_time<=? and ?<=vnr.end_time)" + "   ) group by vnre.venue_equipment_seq" + " ) as used on vne.venue_equipment_seq=used.venue_equipment_seq" + " where" + " (vne.venue_seq=? or vne.venue_seq=" + Venue.FREE_EQUIPMENT_SEQ + ")" + " and vne.status='" + SystemCode.STATUS__A + "'" + " order by vne.venue_seq vne.desc,vne.name";
        RecordList r = DBUtil.run(sql, new Object[]{venue_request_seq, start_time, end_time, start_time, end_time, start_time, end_time, venue_seq});
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            if (r.getI(VenueEquipment.VENUE_SEQ) == Venue.FREE_EQUIPMENT_SEQ) {
                r.setS(VenueEquipment.NAME, String.valueOf(r.getS(VenueEquipment.NAME)) + Lang.set("(Free Eq.)"));
            }
            ++i;
        }
        return r;
    }
}

