/*
 * Decompiled with CFR 0.152.
 */
package venue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import system.SystemCode;
import system.User;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.ScrollList2;
import ui.TableLayout;
import util.ComparableHashMap;
import util.RecordList;
import util.Validation;
import util.WinUtil;
import venue.Venue;
import venue.VenueEquipment;
import venue.VenueListDialog;

public class VenueInfoDialog
extends DataDialog {
    JTextField nameTF;
    ComboBoxCN statusCN;
    JTextArea descTA;
    JTextField user_capacityTF;
    JTextField request_beforeTF;
    private ScrollList2 itemSL;
    JButton add_itemB;
    JButton del_itemB;
    JButton saveB;
    JButton cancelB;
    private Venue g_Venue = null;
    private RecordList g_Items;
    private boolean g_isUpdate = true;
    private boolean g_isFreeEquipment = false;

    public VenueInfoDialog(DataDialog f, int venue_seq) {
        super(f, "Add Venue", false);
        if (venue_seq >= 0) {
            this.setTitle("Edit Venue");
            this.g_isUpdate = true;
        } else if (venue_seq == Venue.FREE_EQUIPMENT_SEQ) {
            this.setTitle("Edit Free Eq.");
            this.g_isFreeEquipment = true;
        } else {
            this.g_isUpdate = false;
        }
        this.init(venue_seq);
    }

    private void init(int venue_seq) {
        this.g_Venue = new Venue(venue_seq);
        VenueEquipment p = new VenueEquipment(venue_seq);
        this.g_Items = p.getItems();
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        if (!this.g_isFreeEquipment) {
            this.nameTF = new JTextField(this.g_Venue.getName());
            String defaultStatus = this.g_isUpdate ? this.g_Venue.getStatus() : SystemCode.STATUS__A;
            this.statusCN = new ComboBoxCN(SystemCode.getStatus(), defaultStatus);
            this.statusCN.hasNilItem(false);
            this.descTA = new JTextArea(this.g_Venue.getDesc());
            this.user_capacityTF = new JTextField(Integer.toString(this.g_Venue.getUser_capacity()));
            this.request_beforeTF = new JTextField(Integer.toString(this.g_Venue.getRequest_before()));
        }
        this.add_itemB = new JButton("Add Eq.");
        this.del_itemB = new JButton("Del Eq.");
        this.saveB = new JButton("Save");
        this.cancelB = new JButton("Cancel");
        this.saveB.setEnabled(User.hasPrivilege("venueModify"));
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        if (!this.g_isFreeEquipment) {
            int[] nArray = new int[4];
            nArray[0] = 100;
            nArray[1] = 240;
            nArray[2] = 120;
            t.getClass();
            nArray[3] = 0;
            t.addTable(nArray, new int[]{30, 60});
            JLabel jLabel = new JLabel("Venue");
            t.getClass();
            t.getClass();
            t.addCell(jLabel, 0, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.nameTF, 1, 0, 20, 0, 260, -1);
            JLabel jLabel2 = new JLabel("Status");
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(jLabel2, 2, 0, 1, 0, 60, -1);
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(this.statusCN, 3, 0, -1, 0, 80, -1);
            JLabel jLabel3 = new JLabel("Desc.");
            t.getClass();
            t.getClass();
            t.addCell(jLabel3, 0, 1, 1, 0);
            JScrollPane jScrollPane = new JScrollPane(this.descTA);
            t.getClass();
            t.addCell(jScrollPane, 1, 1, 20, 0, 420, 60);
            int[] nArray2 = new int[5];
            nArray2[0] = 100;
            nArray2[1] = 60;
            nArray2[2] = 230;
            nArray2[3] = 90;
            t.getClass();
            nArray2[4] = 0;
            t.addTable(nArray2, new int[]{30, 30});
            JLabel jLabel4 = new JLabel("Capacity");
            t.getClass();
            t.getClass();
            t.addCell(jLabel4, 0, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.user_capacityTF, 1, 0, 20, 0, 35, -1);
            JLabel jLabel5 = new JLabel("Seats");
            t.getClass();
            t.getClass();
            t.addCell(jLabel5, 2, 0, -1, 0);
            JLabel jLabel6 = new JLabel("Request Before");
            t.getClass();
            t.getClass();
            t.addCell(jLabel6, 0, 1, 1, -1);
            t.getClass();
            t.getClass();
            t.addCell(this.request_beforeTF, 1, 1, 20, -1, 35, -1);
            JLabel jLabel7 = new JLabel("Days");
            t.getClass();
            t.getClass();
            t.addCell(jLabel7, 2, 1, -1, -1);
        } else {
            int[] nArray = new int[5];
            nArray[0] = 100;
            nArray[1] = 60;
            nArray[2] = 230;
            nArray[3] = 90;
            t.getClass();
            nArray[4] = 0;
            t.addTable(nArray, new int[]{120, 30});
        }
        t.getClass();
        t.getClass();
        t.addCell(this.add_itemB, 3, 1, -1, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.del_itemB, 4, 1, -1, -1);
        this.itemSL = new ScrollList2(560, 300, this.g_Items, new int[]{145, 230, 60, 55, 80}, new String[]{"Eq. Name", "Desc.", "Qty", "Unit", "Status"}, new String[]{VenueEquipment.NAME, VenueEquipment.DESC, VenueEquipment.QTY, VenueEquipment.UNIT, VenueEquipment.STATUS}, new boolean[]{true, true, true, true, true});
        this.itemSL.setEditing_mode(true);
        ComboBoxNV item_status = new ComboBoxNV(SystemCode.getStatus(), "name", "code", "A");
        item_status.hasNilItem(false);
        this.itemSL.setComboxNVColumn(VenueEquipment.STATUS, item_status);
        this.itemSL.setBigDecimalTextFieldColumn(VenueEquipment.QTY);
        t.addYSpace(15);
        int[] nArray = new int[1];
        t.getClass();
        nArray[0] = 0;
        t.addTable(nArray, new int[]{300});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, -1, -1);
        t.addYSpace(15);
        t.addTable(new int[]{435, 70, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 1, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    private void setEventHandler() {
        this.add_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueInfoDialog.this.onAddItem(evt);
            }
        });
        this.del_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueInfoDialog.this.onDelItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueInfoDialog.this.onCancel(evt);
            }
        });
    }

    private void onAddItem(ActionEvent evt) {
        RecordList r = this.itemSL.getTableData();
        ComparableHashMap h = new ComparableHashMap();
        h.put(VenueEquipment.VENUE_EQUIPMENT_SEQ, new Integer(-1));
        h.put(VenueEquipment.VENUE_SEQ, new Integer(this.g_Venue.getVenue_seq()));
        h.put(VenueEquipment.NAME, "");
        h.put(VenueEquipment.DESC, "");
        h.put(VenueEquipment.QTY, new BigDecimal(1));
        h.put(VenueEquipment.UNIT, "pcs");
        h.put(VenueEquipment.STATUS, SystemCode.STATUS__A);
        r.add(h);
        this.itemSL.fireDataChanged();
    }

    private void onDelItem(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        RecordList v = this.itemSL.getTableData();
        v.remove(sel_row);
        this.itemSL.fireDataChanged();
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        if (this.g_Venue.getVenue_seq() != Venue.FREE_EQUIPMENT_SEQ) {
            validation.add(this.nameTF.getText(), "Name", "R");
            validation.add(this.user_capacityTF.getText(), "Capacity", "R,I,GTZ");
            validation.add(this.request_beforeTF.getText(), "Request Before", "R,I,GEZ");
        }
        RecordList items = this.itemSL.getTableData();
        int i = 0;
        while (i < items.size()) {
            items.setCurrentRow(i);
            validation.add(items.getS(VenueEquipment.NAME), "Item " + (i + 1) + " Eq. name", "R");
            validation.add(items.getD(VenueEquipment.QTY), "Item " + (i + 1) + " Qty", "R,F,GTZ");
            validation.add(items.getS(VenueEquipment.UNIT), "Item " + (i + 1) + " Unit", "R");
            ++i;
        }
        if (!validation.isValid()) {
            return false;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        if (this.g_isFreeEquipment) {
            Venue.updateFreeEquipment(items);
        } else if (this.g_isUpdate) {
            Venue.update(this.g_Venue.getVenue_seq(), this.nameTF.getText(), this.descTA.getText(), this.statusCN.getSelectedCode(), Integer.parseInt(this.user_capacityTF.getText()), Integer.parseInt(this.request_beforeTF.getText()), new String("N"), items);
        } else {
            Venue.insert(this.nameTF.getText(), this.descTA.getText(), this.statusCN.getSelectedCode(), Integer.parseInt(this.user_capacityTF.getText()), Integer.parseInt(this.request_beforeTF.getText()), new String("N"), items);
        }
        ((VenueListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

