/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import util.TimeUtil;

public class Validation {
    private Vector g_Data = null;
    private StringBuffer g_ErrMsg = new StringBuffer("");

    public Validation() {
        this.g_Data = new Vector();
    }

    public void add(String value, String name, String validator) {
        String[] term = new String[]{value, name, validator};
        this.g_Data.add(term);
    }

    public void add(int value, String name, String validator) {
        this.add(String.valueOf(value), name, validator);
    }

    public void add(double value, String name, String validator) {
        this.add(String.valueOf(value), name, validator);
    }

    public void add(boolean value, String name, String validator) {
        this.add(String.valueOf(value), name, validator);
    }

    public boolean isValid() {
        int data_size = this.g_Data.size();
        int i = 0;
        while (i < data_size) {
            String[] term = (String[])this.g_Data.get(i);
            if (term.length == 3) {
                this.check(term[0], term[1], term[2]);
            }
            ++i;
        }
        if (this.g_ErrMsg.length() != 0) {
            JOptionPane.showMessageDialog(null, this.g_ErrMsg.toString(), "Input data error", 1);
            return false;
        }
        return true;
    }

    public void check(String value, String name, String validator) {
        Pattern p;
        Matcher m;
        int tmp;
        if ((validator = "," + validator + ",").indexOf(",R,") != -1 && value.equals("")) {
            this.g_ErrMsg.append("Please enter " + name + "\n");
            return;
        }
        if (validator.indexOf(",D,") != -1 && !TimeUtil.isValidDateString(value) && !value.equals("")) {
            this.g_ErrMsg.append(String.valueOf(name) + " is not a valid date or is not the format dd/mm/yyyy" + "\n");
            return;
        }
        if (validator.indexOf(",T,") != -1 && !TimeUtil.isValidTimeString(value) && !value.equals("")) {
            this.g_ErrMsg.append(String.valueOf(name) + " is not a valid time or is not the format hh:mm" + "\n");
            return;
        }
        if (validator.indexOf(",I,") != -1 && !value.equals("")) {
            try {
                tmp = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.g_ErrMsg.append(String.valueOf(name) + " is not an integer" + "\n");
                return;
            }
        }
        if (validator.indexOf(",F,") != -1 && !value.equals("")) {
            try {
                double tmp2 = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                this.g_ErrMsg.append(String.valueOf(name) + " is not a decimal number" + "\n");
                return;
            }
        }
        if (validator.indexOf(",RT,") != -1) {
            if (!value.equals("true")) {
                this.g_ErrMsg.append(String.valueOf(name) + "\n");
            }
            return;
        }
        if (validator.indexOf(",GTZ,") != -1 && !value.equals("")) {
            try {
                double tmp3 = Double.parseDouble(value);
                if (tmp3 <= 0.0) {
                    this.g_ErrMsg.append(String.valueOf(name) + " must bigger than zero" + "\n");
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (validator.indexOf(",GEZ,") != -1 && !value.equals("")) {
            try {
                double tmp4 = Double.parseDouble(value);
                if (tmp4 < 0.0) {
                    this.g_ErrMsg.append(String.valueOf(name) + " must bigger than or equal to zero" + "\n");
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (validator.indexOf(",CBNVIR,") != -1 && !value.equals("")) {
            try {
                tmp = Integer.parseInt(value);
                if (tmp <= 0) {
                    this.g_ErrMsg.append("Please enter " + name + "\n");
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (validator.indexOf(",EMAIL,") != -1 && !value.equals("") && !(m = (p = Pattern.compile("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$")).matcher(value)).matches()) {
            this.g_ErrMsg.append(String.valueOf(name) + " is not a valid email address\n");
        }
        if (validator.indexOf(",EQ,") != -1 && !value.equals("")) {
            try {
                double tmp5 = Double.parseDouble(value);
                if (tmp5 != 0.0) {
                    this.g_ErrMsg.append(String.valueOf(name) + " must be the same" + "\n");
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }
}

