/*
 * Decompiled with CFR 0.152.
 */
package system;

import database.DBConn;
import database.DBUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import system.Lang;
import ui.DataDialog;
import ui.TableLayout;
import util.RecordList;
import util.WinUtil;

public class RunSQLDialog
extends DataDialog {
    private JButton runB;
    private JButton exitB;
    private JCheckBox allow_updateCB;
    private JTextArea sqlTA;

    public RunSQLDialog(JFrame f) {
        super(f, "Run SQL", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 500, 500, 10, 10);
        this.runB = new JButton("Run");
        this.exitB = new JButton("Exit");
        this.allow_updateCB = new JCheckBox("Allow to modify the database data");
        this.sqlTA = new JTextArea("");
        JScrollPane sqlSP = new JScrollPane(this.sqlTA);
        int[] nArray = new int[3];
        nArray[0] = 80;
        nArray[1] = 270;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30, 30});
        JLabel jLabel = new JLabel("Caution: ");
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel("Don't use without guidance.");
        t.getClass();
        t.addCell(jLabel2, 1, 0, -1, 0);
        t.getClass();
        t.addCell(this.allow_updateCB, 1, 1, -1, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.runB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.exitB, 2, 1, -1, 0, 115, -1);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{20, 20});
        JLabel jLabel3 = new JLabel("SQL Statement:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(sqlSP, 0, 1, -1, -1, 475, 365);
    }

    public void setEventHandler() {
        this.runB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunSQLDialog.this.onRun(evt);
            }
        });
        this.exitB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunSQLDialog.this.onExit(evt);
            }
        });
    }

    public void onRun(ActionEvent evt) {
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        String sqlstr = this.sqlTA.getText();
        String[] sqls = sqlstr.split(";");
        DBConn conn = new DBConn(false);
        int i = 0;
        while (i < sqls.length) {
            String sql = sqls[i].trim();
            RecordList r = null;
            if (sql.length() >= 1) {
                if (!this.allow_updateCB.isSelected() && !sql.startsWith("select")) {
                    WinUtil.showMessage(null, "Not allow to run SQL to modify the database");
                } else {
                    r = DBUtil.runSQL(sql, null, conn, true);
                }
                if (sql.startsWith("select")) {
                    r.showOutput(Lang.set("SQL Result"));
                }
            }
            ++i;
        }
        conn.commit();
        wait_dialog.dispose();
    }

    public void onExit(ActionEvent evt) {
        this.dispose();
    }
}

