/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import member.Member;
import system.Config;
import system.User;
import system.UserSession;
import ui.DataDialog;
import ui.TableLayout;
import util.Tools;
import util.Validation;

public class PasswordInfoDialog
extends DataDialog {
    private JPasswordField origPasswordTF;
    private JPasswordField newPasswordTF;
    private JPasswordField confirmPasswordTF;
    private JButton saveB;
    private JButton cancelB;

    public PasswordInfoDialog(JFrame frame) {
        super(frame, "Change Password", true);
        this.setLayout();
        this.setEventHandler();
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 250, 200, 20, 20);
        int[] nArray = new int[2];
        nArray[0] = 60;
        t.addTable(nArray, new int[]{30, 30, 30});
        this.origPasswordTF = new JPasswordField();
        this.newPasswordTF = new JPasswordField();
        this.confirmPasswordTF = new JPasswordField();
        JLabel jLabel = new JLabel("Current PW");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.origPasswordTF, 1, 0, 20, 0, 120, -1);
        JLabel jLabel2 = new JLabel("New PW");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.newPasswordTF, 1, 1, 20, 0, 120, -1);
        JLabel jLabel3 = new JLabel("Confirm PW");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.confirmPasswordTF, 1, 2, 20, 0, 120, -1);
        t.addYSpace(10);
        t.addTable(new int[]{100, 20, 80}, new int[]{20});
        this.saveB = new JButton("Save");
        this.cancelB = new JButton("Cancel");
        t.addCell(this.saveB, 0, 0, 1, 10);
        t.addCell(this.cancelB, 2, 0, -1, 10);
    }

    public void setEventHandler() {
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordInfoDialog.this.onCancel(evt);
            }
        });
    }

    public void onSave(ActionEvent evt) {
        Member m;
        User u;
        String origPassword = new String(this.origPasswordTF.getPassword());
        String newPassword = new String(this.newPasswordTF.getPassword());
        String confirmPassword = new String(this.confirmPasswordTF.getPassword());
        Validation validation = new Validation();
        validation.add(origPassword, "Current Password", "R");
        validation.add(newPassword, "New Password", "R");
        validation.add(confirmPassword, "Confirm Password", "R");
        validation.add(newPassword.equals(confirmPassword), "New Password and Confirm Password are not matched", "RT");
        String savedPassword = "";
        if (UserSession.getLoginUserSeq() == User.ADMIN_USER_SEQ) {
            savedPassword = Config.getS(Config.adminPwd);
        } else {
            u = new User(UserSession.getLoginUserSeq());
            m = new Member(u.getMember_seq());
            savedPassword = m.getPassword();
        }
        validation.add(Tools.md5(origPassword).equals(savedPassword), "Current Password is not correct", "RT");
        if (!validation.isValid()) {
            return;
        }
        if (UserSession.getLoginUserSeq() == User.ADMIN_USER_SEQ) {
            Config.setS(Config.adminPwd, Tools.md5(newPassword));
        } else {
            u = new User(UserSession.getLoginUserSeq());
            m = new Member(u.getMember_seq());
            Member.updatePassword(m.getMember_seq(), newPassword, null);
        }
        JOptionPane.showMessageDialog(null, "Password update successfully. Please use the new password at next login.");
        this.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

