/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import mainapp.MainFrame;
import system.Constants;
import system.User;
import ui.DataDialog;
import ui.TableLayout;
import util.Validation;

public class LoginDialog
extends DataDialog {
    private JTextField login_idTF;
    private JPasswordField passwordTF;
    private JButton loginB;
    private JButton cancelB;

    public LoginDialog(JFrame frame) {
        super(frame, "Login", true);
        this.setLayout();
        this.setEventHandler();
        this.setShow();
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 250, 180, 20, 20);
        int[] nArray = new int[2];
        nArray[0] = 60;
        t.addTable(nArray, new int[]{30, 30});
        this.login_idTF = new JTextField();
        this.passwordTF = new JPasswordField();
        JLabel jLabel = new JLabel("Login ID");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.login_idTF, 1, 0, 20, 0, 120, -1);
        JLabel jLabel2 = new JLabel("Password");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.passwordTF, 1, 1, 20, 0, 120, -1);
        t.addYSpace(10);
        t.addTable(new int[]{100, 20, 80}, new int[]{20});
        this.loginB = new JButton("Login");
        this.cancelB = new JButton("Exit");
        t.addCell(this.loginB, 0, 0, 1, 10);
        t.addCell(this.cancelB, 2, 0, -1, 10);
    }

    public void setEventHandler() {
        this.loginB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.onLogin(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.onCancel(evt);
            }
        });
    }

    public void onLogin(ActionEvent evt) {
        String login_id = this.login_idTF.getText();
        String password = new String(this.passwordTF.getPassword());
        Validation validation = new Validation();
        validation.add(login_id, "Login ID", "R");
        validation.add(password, "Password", "R");
        if (!validation.isValid()) {
            return;
        }
        if (User.login(login_id, password)) {
            MainFrame.initMainFrame();
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(null, "Login ID/Password is wrong, please retry.");
        }
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
        System.exit(0);
    }

    public void setShow() {
        if (!Constants.LOGIN_ID.equals("")) {
            if (User.login(Constants.LOGIN_ID, Constants.PASSWORD)) {
                MainFrame.initMainFrame();
            } else {
                JOptionPane.showMessageDialog(null, "Login ID/Password is wrong, please retry.");
                this.setVisible(true);
            }
        } else {
            this.setVisible(true);
        }
    }
}

