/*
 * Decompiled with CFR 0.152.
 */
package system;

import account.AccountMonth;
import database.DBUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import system.Config;
import system.Lang;
import system.SystemCode;
import system.User;
import ui.CheckBoxYN;
import ui.ComboBoxCN;
import ui.DataDialog;
import ui.DateTextField;
import ui.TableLayout;
import ui.TimeTextField;
import util.TimeUtil;
import util.Tools;
import util.Validation;
import util.WinUtil;

public class ConfigInfoDialog
extends DataDialog {
    private JTabbedPane gTP;
    private JButton saveB;
    private JButton cancelB;
    private int gWidth = 580;
    private int gHeight = 250;
    private SystemPanel gSystemPanel = new SystemPanel();
    private MemberPanel gMemberPanel = new MemberPanel();
    private VenuePanel gVenuePanel = new VenuePanel();
    private AccountPanel gAccountPanel = new AccountPanel();
    private EmailPanel gEmailPanel = new EmailPanel();

    public ConfigInfoDialog(JFrame frame) {
        super(frame, "Settings", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.gTP = new JTabbedPane();
        this.gTP.setSize(new Dimension(this.gWidth, this.gHeight));
        this.gTP.addTab(Lang.set(this.gSystemPanel.getName()), this.gSystemPanel);
        this.gTP.addTab(Lang.set(this.gMemberPanel.getName()), this.gMemberPanel);
        this.gTP.addTab(Lang.set(this.gVenuePanel.getName()), this.gVenuePanel);
        this.gTP.addTab(Lang.set(this.gAccountPanel.getName()), this.gAccountPanel);
        this.gTP.addTab(Lang.set(this.gEmailPanel.getName()), this.gEmailPanel);
        this.saveB = new JButton("Save");
        this.cancelB = new JButton("Cancel");
        this.saveB.setEnabled(User.hasPrivilege("configModify"));
        TableLayout t = new TableLayout(this, this.gWidth + 20, this.gHeight + 90, 5, 10);
        int[] nArray = new int[4];
        t.getClass();
        nArray[0] = 0;
        nArray[1] = 15;
        nArray[2] = 60;
        nArray[3] = 10;
        t.addTable(nArray, new int[]{this.gHeight + 10, 30});
        t.getClass();
        t.getClass();
        t.addCell(this.gTP, 0, 0, -1, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 1, -1, 0);
    }

    public void setEventHandler() {
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigInfoDialog.this.onCancel(evt);
            }
        });
    }

    private boolean onSave(ActionEvent evt) {
        int notValid = 0;
        if (!this.gSystemPanel.toValidate()) {
            ++notValid;
        }
        if (!this.gMemberPanel.toValidate()) {
            ++notValid;
        }
        if (!this.gVenuePanel.toValidate()) {
            ++notValid;
        }
        if (!this.gAccountPanel.toValidate()) {
            ++notValid;
        }
        if (!this.gEmailPanel.toValidate()) {
            ++notValid;
        }
        if (notValid > 0) {
            return false;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        this.gSystemPanel.save();
        this.gMemberPanel.save();
        this.gVenuePanel.save();
        this.gAccountPanel.save();
        this.gEmailPanel.save();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }

    private class AccountPanel
    extends TableLayout {
        private String gName;
        private JTextField gCompanyNameTF;
        private JTextField gReceiptIdFormatTF;
        private JTextField gReceiptEmailTF;
        private JTextField gVoucherIdFormatTF;
        private DateTextField gStartAcPeriodDT;
        private JTextField gCurrencyCodeTF;

        public AccountPanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gName = "Account";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gCompanyNameTF = new JTextField(Config.getS(Config.companyName));
            this.gReceiptIdFormatTF = new JTextField(Config.getS(Config.receiptIdFormat));
            this.gReceiptEmailTF = new JTextField(Config.getS(Config.receiptEmail));
            this.gVoucherIdFormatTF = new JTextField(Config.getS(Config.voucherIdFormat));
            this.gStartAcPeriodDT = new DateTextField(Config.getT(Config.startAcPeriod));
            this.gCurrencyCodeTF = new JTextField(Config.getS(Config.currencyCode));
            if (!AccountMonth.isEmpty()) {
                this.gStartAcPeriodDT.setEnabled(false);
            }
            this.addTable(new int[]{80, 0}, new int[]{30, 30, 30, 30, 30, 20, 20});
            this.addCell(new JLabel("Company Name"), 0, 0, 1, 0);
            this.addCell(this.gCompanyNameTF, 1, 0, 10, 0, 200, -1);
            this.addCell(new JLabel("Receipt ID*"), 0, 1, 1, 0);
            this.addCell(this.gReceiptIdFormatTF, 1, 1, 10, 0, 200, -1);
            this.addCell(new JLabel("Admin email"), 0, 2, 1, 0);
            this.addCell(this.gReceiptEmailTF, 1, 2, 10, 0, 200, -1);
            this.addCell(new JLabel("(Require Webtool and enable email)"), 1, 2, 220, 0);
            this.addCell(new JLabel("Voucher ID*"), 0, 3, 1, 0);
            this.addCell(this.gVoucherIdFormatTF, 1, 3, 10, 0, 200, -1);
            this.addCell(new JLabel("Start Date"), 0, 4, 1, 0);
            this.addCell(this.gStartAcPeriodDT, 1, 4, 10, 0);
            this.addCell(new JLabel("Currency"), 1, 4, 100, 0);
            this.addCell(this.gCurrencyCodeTF, 1, 4, 160, 0, 50, -1);
            this.addCell(new JLabel("*Can use variables [yyyy](4 digits Year),[yy](2 digits Year),[MM](Month)"), 0, 5, -1, 0);
            this.addCell(new JLabel("[#x](Auto increment no. with length x).E.g. [#3] means no.001-999"), 0, 6, -1, 0);
        }

        public void setEventHandler() {
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            validation.add(this.gCompanyNameTF.getText(), "[Account] Page: Company Name", "R");
            validation.add(this.gReceiptIdFormatTF.getText(), "[Account] Page: Receipt ID", "R");
            validation.add(this.gReceiptEmailTF.getText(), "[Account] Page: Receipt admin email", "EMAIL");
            validation.add(this.gVoucherIdFormatTF.getText(), "[Account] Page: Voucher ID", "R");
            validation.add(Tools.validateIdFormat(this.gReceiptIdFormatTF.getText()), "[Account] Page: Receipt ID format incorrect", "RT");
            validation.add(Tools.validateIdFormat(this.gVoucherIdFormatTF.getText()), "[Account] Page: Voucher ID format incorrect", "RT");
            validation.add(this.gStartAcPeriodDT.getInput(), "[Account] Page: Start A/C Date", "D");
            if (TimeUtil.isValidDateString(this.gStartAcPeriodDT.getInput())) {
                validation.add(this.gStartAcPeriodDT.getDate().equals(TimeUtil.getMonthStartDay(this.gStartAcPeriodDT.getDate())), "[Account] Page:Start A/C Date must be the first day of a month", "RT");
            }
            validation.add(this.gCurrencyCodeTF.getText(), "[Account] Page: Currency", "R");
            return validation.isValid();
        }

        public void save() {
            Config.setS(Config.companyName, this.gCompanyNameTF.getText());
            Config.setS(Config.receiptIdFormat, this.gReceiptIdFormatTF.getText());
            Config.setS(Config.receiptEmail, this.gReceiptEmailTF.getText());
            Config.setS(Config.voucherIdFormat, this.gVoucherIdFormatTF.getText());
            Config.setT(Config.startAcPeriod, this.gStartAcPeriodDT.getDate());
            Config.setS(Config.currencyCode, this.gCurrencyCodeTF.getText());
        }
    }

    private class EmailPanel
    extends TableLayout {
        private String gName;
        private CheckBoxYN gEnableEmailCB;
        private JTextField gEmailHostTF;
        private JTextField gEmailPortTF;
        private JTextField gEmailUserTF;
        private JPasswordField gEmailPwdTF;
        private JTextField gAdminEmailTF;

        public EmailPanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gName = "Email";
            this.setLayout();
            this.setEventHandler();
            this.onEnableEmail(null);
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gEnableEmailCB = new CheckBoxYN("", Config.getS(Config.enableEmail));
            this.gEmailHostTF = new JTextField(Config.getS(Config.emailHost));
            this.gEmailPortTF = new JTextField(String.valueOf(Config.getI(Config.emailPort)));
            this.gEmailUserTF = new JTextField(Config.getS(Config.emailUser));
            this.gEmailPwdTF = new JPasswordField(Config.getS(Config.emailPwd));
            this.gAdminEmailTF = new JTextField(Config.getS(Config.adminEmail));
            this.addTable(new int[]{80, 200, 80, 0}, new int[]{30, 30, 30, 30});
            this.addCell(new JLabel("Enable Email"), 0, 0, 1, 0);
            this.addCell(this.gEnableEmailCB, 1, 0, 10, 0);
            this.addCell(new JLabel("(Require to enable Webtool)"), 1, 0, 40, 0);
            this.addCell(new JLabel("SMTP Server"), 0, 1, 1, 0);
            this.addCell(this.gEmailHostTF, 1, 1, 10, 0, 200, -1);
            this.addCell(new JLabel("Port"), 2, 1, 1, 0);
            this.addCell(this.gEmailPortTF, 3, 1, 10, 0, 50, -1);
            this.addCell(new JLabel("User"), 0, 2, 1, 0);
            this.addCell(this.gEmailUserTF, 1, 2, 10, 0, 200, -1);
            this.addCell(new JLabel("Password"), 2, 2, 1, 0);
            this.addCell(this.gEmailPwdTF, 3, 2, 10, 0, 130, -1);
            this.addCell(new JLabel("System Admin Email"), 0, 3, 1, 0);
            this.addCell(this.gAdminEmailTF, 1, 3, 10, 0, 200, -1);
        }

        public void setEventHandler() {
            this.gEnableEmailCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EmailPanel.this.onEnableEmail(evt);
                }
            });
        }

        public void onEnableEmail(ActionEvent evt) {
            boolean b = this.gEnableEmailCB.isSelected();
            this.gEmailHostTF.setEnabled(b);
            this.gEmailPortTF.setEnabled(b);
            this.gEmailUserTF.setEnabled(b);
            this.gEmailPwdTF.setEnabled(b);
            this.gAdminEmailTF.setEnabled(b);
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            if (this.gEnableEmailCB.isSelected()) {
                validation.add(this.gEmailHostTF.getText(), "[Email] Page: SMTP Server", "R");
                validation.add(this.gEmailPortTF.getText(), "[Email] Page: Port", "R,I,GTZ");
                validation.add(this.gAdminEmailTF.getText(), "[Email] Page: System Admin Email", "R,EMAIL");
            }
            return validation.isValid();
        }

        public void save() {
            Config.setS(Config.enableEmail, this.gEnableEmailCB.getValue());
            Config.setS(Config.emailHost, this.gEmailHostTF.getText());
            Config.setI(Config.emailPort, Integer.parseInt(this.gEmailPortTF.getText()));
            Config.setS(Config.emailUser, this.gEmailUserTF.getText());
            Config.setS(Config.emailPwd, String.valueOf(this.gEmailPwdTF.getPassword()));
            Config.setS(Config.adminEmail, this.gAdminEmailTF.getText());
        }
    }

    private class MemberPanel
    extends TableLayout {
        private String gName;
        private JTextField gMemberIdFormatTF;
        private CheckBoxYN gMemberIdCheckDigitCB;
        private JTextField gMemberIdSeqTF;

        public MemberPanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gName = "Member";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gMemberIdFormatTF = new JTextField(Config.getS(Config.memberIdFormat));
            this.gMemberIdCheckDigitCB = new CheckBoxYN("Insert a Mod 11 check digit at the end of the new member id", Config.getS(Config.memberIdCheckDigit));
            this.gMemberIdSeqTF = new JTextField(String.valueOf(DBUtil.getCurValueFor("member_id_seq", null)));
            this.addTable(new int[]{100, 0}, new int[]{30, 30, 20, 30, 20, 20});
            this.addCell(new JLabel("ID format*"), 0, 0, 1, 0);
            this.addCell(this.gMemberIdFormatTF, 1, 0, 10, 0, 200, -1);
            this.addCell(this.gMemberIdCheckDigitCB, 1, 1, 10, 0);
            this.addCell(new JLabel("(If enabled, ID must not more than 10 English characters)"), 1, 2, 20, 0);
            this.addCell(new JLabel("ID start from"), 0, 3, 1, 0);
            this.addCell(this.gMemberIdSeqTF, 1, 3, 10, 0, 50, -1);
            this.addCell(new JLabel("*Can use variables [yyyy](4 digits Year),[yy](2 digits Year),[MM](Month)"), 0, 4, -1, 0);
            this.addCell(new JLabel("[#x](Auto increment no. with length x).E.g. [#3] means no.001-999"), 0, 5, -1, 0);
        }

        public void setEventHandler() {
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            validation.add(this.gMemberIdFormatTF.getText(), "[Member] Page: Member ID format", "R");
            validation.add(Tools.validateIdFormat(this.gMemberIdFormatTF.getText()), "[Member] Page: Member ID format", "RT");
            if (this.gMemberIdCheckDigitCB.isSelected()) {
                validation.add(Tools.validateMemberIdFormat(this.gMemberIdFormatTF.getText()), "[Member] Page: Member ID format is not compatible to check digit", "RT");
            }
            validation.add(this.gMemberIdSeqTF.getText(), "[Member] Page: Member ID start from", "R,I,GTZ");
            return validation.isValid();
        }

        public void save() {
            Config.setS(Config.memberIdFormat, this.gMemberIdFormatTF.getText());
            Config.setS(Config.memberIdCheckDigit, this.gMemberIdCheckDigitCB.getValue());
            DBUtil.setValueFor("member_id_seq", Integer.parseInt(this.gMemberIdSeqTF.getText()), null);
        }
    }

    private class SystemPanel
    extends TableLayout {
        private String gName;
        private JTextField gChurchNameTF;
        private ComboBoxCN gLangCN;
        private CheckBoxYN gAutoCheckUpdateCB;
        private JLabel gChurchP;
        private JButton gChurchPSelB;
        private String gChurchPTmpPath;
        private String gChurchPPath;
        private JLabel gMemberCardFrontP;
        private JButton gMemberCardFrontPSelB;
        private String gMemberCardFrontPTmpPath;
        private String gMemberCardFrontPPath;
        private JLabel gMemberCardBackP;
        private JButton gMemberCardBackPSelB;
        private String gMemberCardBackPTmpPath;
        private String gMemberCardBackPPath;

        public SystemPanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gChurchPTmpPath = "";
            this.gChurchPPath = "image/logo.jpg";
            this.gMemberCardFrontPTmpPath = "";
            this.gMemberCardFrontPPath = "image/card_front_bg.jpg";
            this.gMemberCardBackPTmpPath = "";
            this.gMemberCardBackPPath = "image/card_back_bg.jpg";
            this.gName = "System";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gChurchNameTF = new JTextField(Config.getS(Config.churchName));
            this.gLangCN = new ComboBoxCN(SystemCode.getLang(), Config.getS(Config.lang));
            this.gAutoCheckUpdateCB = new CheckBoxYN("Auto check updates", Config.getS(Config.autoCheckUpdate));
            this.gChurchP = new JLabel(Tools.getScaledImage(this.gChurchPPath, 240, 30));
            this.gChurchPSelB = new JButton("Open...");
            this.gMemberCardFrontP = new JLabel(Tools.getScaledImage(this.gMemberCardFrontPPath, 90, 60));
            this.gMemberCardFrontPSelB = new JButton("Front..");
            this.gMemberCardBackP = new JLabel(Tools.getScaledImage(this.gMemberCardBackPPath, 90, 60));
            this.gMemberCardBackPSelB = new JButton("Back..");
            this.gLangCN.hasNilItem(false);
            this.addTable(new int[]{80, 245, 80, 0}, new int[]{30, 30, 40, 30, 60});
            this.addCell(new JLabel("Church Name"), 0, 0, 1, 0);
            this.addCell(this.gChurchNameTF, 1, 0, 10, 0, 200, -1);
            this.addCell(new JLabel("Language"), 2, 0, 1, 0);
            this.addCell(this.gLangCN, 3, 0, 10, 0);
            this.addCell(new JLabel("Logo"), 0, 1, 1, 0);
            this.addCell(this.gChurchPSelB, 1, 1, 10, 0);
            this.addCell(new JLabel("Size: W:1200px H:150px"), 1, 1, 90, 0);
            this.addCell(this.gAutoCheckUpdateCB, 3, 1, 10, 0);
            this.addCell(this.gChurchP, 1, 2, 10, 0);
            this.addCell(new JLabel("Card Logo"), 0, 3, 1, 0);
            this.addCell(this.gMemberCardFrontPSelB, 1, 3, 10, 0);
            this.addCell(new JLabel("Size W:900px H:600px"), 1, 3, 90, 0);
            this.addCell(this.gMemberCardBackPSelB, 1, 3, 250, 0);
            this.addCell(new JLabel("Size W:900px H:600px"), 1, 3, 340, 0);
            this.addCell(this.gMemberCardFrontP, 1, 4, 10, 0);
            this.addCell(this.gMemberCardBackP, 1, 4, 250, 0);
        }

        public void setEventHandler() {
            this.gAutoCheckUpdateCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (SystemPanel.this.gAutoCheckUpdateCB.isSelected()) {
                        WinUtil.showMessage(null, "This feature will connect to Acts website to check updates. It is not recommend \nto do so in religion sensitive area in order to escape from the scanning.");
                    }
                }
            });
            this.gChurchPSelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SystemPanel.this.gChurchPTmpPath = SystemPanel.this.onChurchPhotoChoose(evt, SystemPanel.this.gChurchPTmpPath, SystemPanel.this.gChurchP, 240, 30);
                }
            });
            this.gMemberCardFrontPSelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SystemPanel.this.gMemberCardFrontPTmpPath = SystemPanel.this.onChurchPhotoChoose(evt, SystemPanel.this.gMemberCardFrontPTmpPath, SystemPanel.this.gMemberCardFrontP, 90, 60);
                }
            });
            this.gMemberCardBackPSelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SystemPanel.this.gMemberCardBackPTmpPath = SystemPanel.this.onChurchPhotoChoose(evt, SystemPanel.this.gMemberCardBackPTmpPath, SystemPanel.this.gMemberCardBackP, 90, 60);
                }
            });
        }

        private String onChurchPhotoChoose(ActionEvent evt, String tmpPath, JLabel photo, int width, int height) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            int option = chooser.showOpenDialog(this);
            if (option == 0) {
                tmpPath = chooser.getSelectedFile().getPath();
                photo.setIcon(Tools.getScaledImage(tmpPath, width, height));
            }
            return tmpPath;
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            validation.add(this.gChurchNameTF.getText(), "[System] Page: Church Name", "R");
            return validation.isValid();
        }

        public void save() {
            Config.setS(Config.churchName, this.gChurchNameTF.getText());
            Config.setS(Config.lang, this.gLangCN.getSelectedCode());
            Config.setS(Config.autoCheckUpdate, this.gAutoCheckUpdateCB.getValue());
            if (!this.gChurchPTmpPath.equals("")) {
                Tools.copyFile(this.gChurchPTmpPath, this.gChurchPPath);
            }
            if (!this.gMemberCardFrontPTmpPath.equals("")) {
                Tools.copyFile(this.gMemberCardFrontPTmpPath, this.gMemberCardFrontPPath);
            }
            if (!this.gMemberCardBackPTmpPath.equals("")) {
                Tools.copyFile(this.gMemberCardBackPTmpPath, this.gMemberCardBackPPath);
            }
        }
    }

    private class VenuePanel
    extends TableLayout {
        private String gName;
        private TimeTextField gVenueStartTimeTT;
        private TimeTextField gVenueEndTimeTT;
        private DateTextField gVenueRequestMaxDateDT;
        private JTextField gVenueRequestEmailTF;

        public VenuePanel() {
            super(ConfigInfoDialog.this.gWidth, ConfigInfoDialog.this.gHeight, 5, 10);
            this.gName = "Venue";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.gVenueStartTimeTT = new TimeTextField(Config.getT(Config.venueStartTime));
            this.gVenueEndTimeTT = new TimeTextField(Config.getT(Config.venueEndTime));
            this.gVenueRequestMaxDateDT = new DateTextField(Config.getT(Config.venueRequestMaxDate));
            this.gVenueRequestEmailTF = new JTextField(Config.getS(Config.venueRequestEmail));
            this.addTable(new int[]{80, 0}, new int[]{30, 30, 30});
            this.addCell(new JLabel("Open Time"), 0, 0, 1, 0);
            this.addCell(this.gVenueStartTimeTT, 1, 0, 10, 0);
            this.addCell(new JLabel("to"), 1, 0, 60, 0);
            this.addCell(this.gVenueEndTimeTT, 1, 0, 75, 0);
            this.addCell(new JLabel("(Limited on Webtool only)"), 1, 0, 125, 0);
            this.addCell(new JLabel("Allow Up to"), 0, 1, 1, 0);
            this.addCell(this.gVenueRequestMaxDateDT, 1, 1, 10, 0);
            this.addCell(new JLabel("(Limited on Webtool only)"), 1, 1, 100, 0);
            this.addCell(new JLabel("Admin email"), 0, 2, 1, 0);
            this.addCell(this.gVenueRequestEmailTF, 1, 2, 10, 0, 200, -1);
            this.addCell(new JLabel("(Require Webtool and enable email)"), 1, 2, 220, 0);
        }

        public void setEventHandler() {
        }

        public boolean toValidate() {
            Validation validation = new Validation();
            validation.add(this.gVenueStartTimeTT.getInput(), "[Venue]: Open Time(Start)", "R,T");
            validation.add(this.gVenueEndTimeTT.getInput(), "[Venue]: Open Time(End)", "R,T");
            validation.add(this.gVenueRequestMaxDateDT.getInput(), "[Venue]: Allow Up to", "R,D");
            validation.add(this.gVenueRequestEmailTF.getText(), "[Venue]: Venue admin email", "EMAIL");
            return validation.isValid();
        }

        public void save() {
            Config.setT(Config.venueStartTime, this.gVenueStartTimeTT.getTime("01/01/2000"));
            Config.setT(Config.venueEndTime, this.gVenueEndTimeTT.getTime("01/01/2000"));
            Config.setT(Config.venueRequestMaxDate, this.gVenueRequestMaxDateDT.getDate());
            Config.setS(Config.venueRequestEmail, this.gVenueRequestEmailTF.getText());
        }
    }
}

