/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBUtil;
import member.Member;
import member.MemberGroup;
import member.MemberRemark;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Lang;
import system.SystemCode;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class MemberReport {
    private int gMemberGroupSeq;
    private boolean gShowExpiredMember;
    private boolean gIsTemplate;

    public MemberReport() {
        this.gIsTemplate = true;
        this.genReport();
    }

    public MemberReport(int member_group_seq, boolean show_expired_member) {
        this.gMemberGroupSeq = member_group_seq;
        this.gShowExpiredMember = show_expired_member;
        this.genReport();
    }

    private void genReport() {
        RecordList remarkCols = MemberRemark.getRemarkCols();
        RecordList members = new RecordList();
        RecordList remarks = new RecordList();
        if (!this.gIsTemplate) {
            members = this.getMembers();
            remarks = this.getRemarks();
        }
        int prefix_col = 21;
        int[] widths = new int[prefix_col + remarkCols.size()];
        widths[0] = 32;
        widths[1] = 22;
        widths[2] = 45;
        widths[3] = 30;
        widths[4] = 12;
        widths[5] = 25;
        widths[6] = 70;
        widths[7] = 30;
        widths[8] = 30;
        widths[9] = 60;
        widths[10] = 25;
        widths[11] = 30;
        widths[12] = 30;
        widths[13] = 20;
        widths[14] = 25;
        widths[15] = 25;
        widths[16] = 35;
        widths[17] = 35;
        widths[18] = 20;
        widths[19] = 25;
        widths[20] = 25;
        int i = 0;
        while (i < remarkCols.size()) {
            widths[prefix_col + i] = 30;
            ++i;
        }
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4R, widths);
        if (this.gIsTemplate) {
            p.setReportEnd(false);
        } else {
            p.addHeader(Lang.set("Member Report"), new String[]{String.valueOf(Lang.set("Group: ")) + MemberGroup.getName(this.gMemberGroupSeq), Lang.set("Show inactive members: " + (this.gShowExpiredMember ? "Y" : "N"))});
        }
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("Member ID"), p.TL);
        p.addCell(1, row, Lang.set("Name 1"), p.TL);
        p.addCell(2, row, Lang.set("Name 2"), p.TL);
        p.addCell(3, row, Lang.set("Gov. ID"), p.TL);
        p.addCell(4, row, Lang.set("Gender"), p.TL);
        p.addCell(5, row, Lang.set("DOB"), p.TL);
        p.addCell(6, row, Lang.set("Address"), p.TL);
        p.addCell(7, row, Lang.set("Tel(1)"), p.TL);
        p.addCell(8, row, Lang.set("Tel(2)"), p.TL);
        p.addCell(9, row, Lang.set("Email"), p.TL);
        p.addCell(10, row, Lang.set("Occupation"), p.TL);
        p.addCell(11, row, Lang.set("Education"), p.TL);
        p.addCell(12, row, Lang.set("Hobbies"), p.TL);
        p.addCell(13, row, Lang.set("Marital status"), p.TL);
        p.addCell(14, row, Lang.set("Baptist Date"), p.TL);
        p.addCell(15, row, Lang.set("Join Church Date"), p.TL);
        p.addCell(16, row, Lang.set("Login ID"), p.TL);
        p.addCell(17, row, Lang.set("Password"), p.TL);
        p.addCell(18, row, Lang.set("Receipt Type"), p.TL);
        p.addCell(19, row, Lang.set("Start Date"), p.TL);
        p.addCell(20, row, Lang.set("Expired Date"), p.TL);
        int i2 = 0;
        while (i2 < remarkCols.size()) {
            p.addCell(prefix_col + i2, row, remarkCols.getS("name", i2), p.TL);
            ++i2;
        }
        i2 = 0;
        while (i2 < members.size()) {
            members.setCurrentRow(i2);
            p.addCell(0, ++row, members.getS("member_id"));
            p.addCell(1, row, members.getS("name_chi"));
            p.addCell(2, row, members.getS("name_eng"));
            p.addCell(3, row, members.getS("hkid"));
            p.addCell(4, row, SystemCode.getGender(members.getS("gender")));
            p.addCell(5, row, TimeUtil.getStringByDate(members.getT("dob")));
            p.addCell(6, row, members.getS("address"));
            p.addCell(7, row, members.getS("tel1"));
            p.addCell(8, row, members.getS("tel2"));
            p.addCell(9, row, members.getS("email"));
            p.addCell(10, row, members.getS("career"));
            p.addCell(11, row, members.getS("education"));
            p.addCell(12, row, members.getS("hobby"));
            p.addCell(13, row, SystemCode.getMartial_status(members.getS("marital_status")));
            p.addCell(14, row, TimeUtil.getStringByDate(members.getT("baptist_date")));
            p.addCell(15, row, TimeUtil.getStringByDate(members.getT("church_join_date")));
            p.addCell(16, row, members.getS("login_id"));
            p.addCell(17, row, Lang.set(members.getS("password").equals("") ? "Not Set" : "Set"));
            p.addCell(18, row, Lang.set(Tools.getStatusName(Member.RECEIPT_TYPE_MAP, members.getS("receipt_type"))));
            p.addCell(19, row, TimeUtil.getStringByDate(members.getT("start_date")));
            p.addCell(20, row, TimeUtil.getStringByDate(members.getT("end_date")));
            RecordList mrs = remarks.getGroupItems("member_seq", members.getI("member_seq"));
            int j = 0;
            while (j < remarkCols.size()) {
                int k = mrs.indexOf("code", remarkCols.getS("code", j));
                String r = k != -1 ? mrs.getS("remark", k) : "";
                p.addCell(prefix_col + j, row, r);
                ++j;
            }
            ++i2;
        }
        p.genPrintout();
    }

    private RecordList getMembers() {
        String sql = "select mb.*,mgm.start_date,mgm.end_date from member mb,member_group_member mgm where mgm.member_group_seq=?" + (this.gShowExpiredMember ? "" : " and mgm.end_date>=curdate()") + " and mgm.member_seq=mb.member_seq" + " order by mb.member_id";
        return DBUtil.run(sql, this.gMemberGroupSeq);
    }

    private RecordList getRemarks() {
        String sql = "select mbr.* from member_remark mbr,member_group_member mgm where mgm.member_group_seq=? and mgm.member_seq=mbr.member_seq";
        return DBUtil.run("select mbr.* from member_remark mbr,member_group_member mgm where mgm.member_group_seq=? and mgm.member_seq=mbr.member_seq", this.gMemberGroupSeq);
    }
}

