/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import member.Member;
import member.MemberListDialog;
import member.MemberRemark;
import system.Config;
import system.MasterCode;
import system.SystemCode;
import system.User;
import ui.ComboBoxCN;
import ui.DataDialog;
import ui.DateTextField;
import ui.ScrollList;
import ui.TableLayout;
import util.ComparableHashMap;
import util.RecordList;
import util.Tools;
import util.Validation;
import util.WinUtil;

public class MemberInfoDialog
extends DataDialog {
    private JTabbedPane gTP;
    private int gWidth = 580;
    private int gHeight = 530;
    private MainPanel gMainPanel;
    private RemarkPanel gRemarkPanel;
    private JTextField member_idTF;
    private JTextField name_chiTF;
    private JTextField name_engTF;
    private JTextField hkidTF;
    private JTextField tel1TF;
    private JTextField tel2TF;
    private JTextField emailTF;
    private JTextField careerTF;
    private JTextField educationTF;
    private JTextField hobbyTF;
    private JTextField login_idTF;
    private JTextField passwordTF;
    private ComboBoxCN genderCN;
    private ComboBoxCN marital_statusCN;
    private ComboBoxCN receipt_typeCN;
    private DateTextField dobDT;
    private DateTextField baptist_dateDT;
    private DateTextField church_join_dateDT;
    private JTextArea addressTA;
    private JLabel photoLB;
    private JButton genMemberIdB;
    private JButton photoChooseB;
    private JButton saveB;
    private JButton cancelB;
    private ScrollList gMemberRemarkSL;
    private JButton addRemarkB;
    private JButton delRemarkB;
    private Member g_Member = null;
    private RecordList g_MemberRemarks = null;
    private String g_Photo_path = "";
    private boolean g_isUpdate = false;

    public MemberInfoDialog(DataDialog f) {
        super(f, "Add Member", false);
        this.init(-1);
        this.g_isUpdate = false;
    }

    public MemberInfoDialog(DataDialog f, int member_seq) {
        super(f, "Edit Member", false);
        this.g_isUpdate = true;
        this.init(member_seq);
    }

    private void init(int member_seq) {
        this.g_Member = new Member(member_seq);
        MemberRemark mk = new MemberRemark(member_seq);
        this.g_MemberRemarks = mk.getItems();
        this.gMainPanel = new MainPanel();
        this.gRemarkPanel = new RemarkPanel();
        this.setLayout();
        this.setVisible(true);
    }

    private void setLayout() {
        this.gTP = new JTabbedPane();
        this.gTP.setSize(new Dimension(this.gWidth, this.gHeight));
        this.gTP.addTab(this.gMainPanel.getName(), this.gMainPanel);
        this.gTP.addTab(this.gRemarkPanel.getName(), this.gRemarkPanel);
        TableLayout t = new TableLayout(this, this.gWidth + 20, this.gHeight + 90, 5, 10);
        int[] nArray = new int[4];
        t.getClass();
        nArray[0] = 0;
        nArray[1] = 15;
        nArray[2] = 60;
        nArray[3] = 10;
        t.addTable(nArray, new int[]{this.gHeight + 10, 30});
        t.getClass();
        t.getClass();
        t.addCell(this.gTP, 0, 0, -1, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 1, -1, 0);
    }

    private void onSave(ActionEvent evt) {
        int mrx;
        Validation validation = new Validation();
        validation.add(this.dobDT.getInput(), "DOB", "D");
        validation.add(this.baptist_dateDT.getInput(), "Baptist date", "D");
        validation.add(this.emailTF.getText(), "Email", "EMAIL");
        String memberId = this.member_idTF.getText();
        validation.add(memberId, "Member ID", "R");
        if (!this.g_isUpdate && Config.getS(Config.memberIdCheckDigit).equals(SystemCode.YN__Y)) {
            if (!Tools.validateMemberIdForCheckDigit(memberId)) {
                validation.add(false, "Due to check digit is enabled, member id must be english characters and at most 10 characters", "RT");
            } else {
                memberId = String.valueOf(memberId) + Tools.genCheckDigit(memberId);
            }
        }
        RecordList ids = Member.getAllMemberIdLoginIds(this.g_Member.getMember_seq());
        validation.add(Member.isIdAllowed(ids, memberId), "Member ID is in use", "RT");
        String loginId = this.login_idTF.getText();
        if (!loginId.equals("")) {
            validation.add(Member.isIdAllowed(ids, loginId), "Login ID is in use", "RT");
        }
        if (this.receipt_typeCN.getSelectedCode().equals(Member.RECEIPT_TYPE__EMAIL)) {
            validation.add(!this.emailTF.getText().isEmpty(), "Please type in email for using email receipt", "RT");
        }
        validation.add((mrx = this.g_MemberRemarks.getColNonUniqueIndex(new String[]{MemberRemark.CODE})) == -1, "Remarks item " + (mrx + 1) + " is duplicated to others", "RT");
        int i = 0;
        while (i < this.g_MemberRemarks.size()) {
            validation.add(this.g_MemberRemarks.getS(MemberRemark.CODE, i), "Remark item " + (i + 1) + " value", "R");
            validation.add(this.g_MemberRemarks.getS(MemberRemark.REMARK, i), "Remark item " + (i + 1) + " value", "R");
            ++i;
        }
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        if (this.g_isUpdate) {
            Member.update(this.g_Member.getMember_seq(), memberId, this.name_chiTF.getText(), this.name_engTF.getText(), this.hkidTF.getText(), this.genderCN.getSelectedCode(), this.dobDT.getDate(), this.addressTA.getText(), this.tel1TF.getText(), this.tel2TF.getText(), this.emailTF.getText(), this.careerTF.getText(), this.educationTF.getText(), this.hobbyTF.getText(), this.marital_statusCN.getSelectedCode(), this.baptist_dateDT.getDate(), this.church_join_dateDT.getDate(), this.g_Photo_path, this.login_idTF.getText(), this.passwordTF.getText(), this.receipt_typeCN.getSelectedCode(), this.g_MemberRemarks);
        } else {
            Member.insert(memberId, this.name_chiTF.getText(), this.name_engTF.getText(), this.hkidTF.getText(), this.genderCN.getSelectedCode(), this.dobDT.getDate(), this.addressTA.getText(), this.tel1TF.getText(), this.tel2TF.getText(), this.emailTF.getText(), this.careerTF.getText(), this.educationTF.getText(), this.hobbyTF.getText(), this.marital_statusCN.getSelectedCode(), this.baptist_dateDT.getDate(), this.church_join_dateDT.getDate(), this.g_Photo_path, this.login_idTF.getText(), this.passwordTF.getText(), this.receipt_typeCN.getSelectedCode(), null, null, this.g_MemberRemarks);
        }
        ((MemberListDialog)this.getParent()).onSearch(null);
        this.dispose();
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }

    private class MainPanel
    extends TableLayout {
        private String gName;

        public MainPanel() {
            super(MemberInfoDialog.this.gWidth, MemberInfoDialog.this.gHeight, 5, 10);
            this.gName = "Basic";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        void setLayout() {
            MemberInfoDialog.this.member_idTF = new JTextField(MemberInfoDialog.this.g_Member.getMember_id());
            MemberInfoDialog.this.name_chiTF = new JTextField(MemberInfoDialog.this.g_Member.getName_chi());
            MemberInfoDialog.this.name_engTF = new JTextField(MemberInfoDialog.this.g_Member.getName_eng());
            MemberInfoDialog.this.hkidTF = new JTextField(MemberInfoDialog.this.g_Member.getHkid());
            MemberInfoDialog.this.tel1TF = new JTextField(MemberInfoDialog.this.g_Member.getTel1());
            MemberInfoDialog.this.tel2TF = new JTextField(MemberInfoDialog.this.g_Member.getTel2());
            MemberInfoDialog.this.emailTF = new JTextField(MemberInfoDialog.this.g_Member.getEmail());
            MemberInfoDialog.this.careerTF = new JTextField(MemberInfoDialog.this.g_Member.getCareer());
            MemberInfoDialog.this.educationTF = new JTextField(MemberInfoDialog.this.g_Member.getEducation());
            MemberInfoDialog.this.hobbyTF = new JTextField(MemberInfoDialog.this.g_Member.getHobby());
            MemberInfoDialog.this.login_idTF = new JTextField(MemberInfoDialog.this.g_Member.getLogin_id());
            MemberInfoDialog.this.passwordTF = new JTextField("");
            MemberInfoDialog.this.genderCN = new ComboBoxCN(SystemCode.getGender(), MemberInfoDialog.this.g_Member.getGender());
            MemberInfoDialog.this.marital_statusCN = new ComboBoxCN(SystemCode.getMartial_status(), MemberInfoDialog.this.g_Member.getMarital_status());
            MemberInfoDialog.this.receipt_typeCN = new ComboBoxCN(ComboBoxCN.buildItemsByMap(Member.RECEIPT_TYPE_MAP), MemberInfoDialog.this.g_Member.getReceipt_type().equals("") ? Member.RECEIPT_TYPE__PRINT : MemberInfoDialog.this.g_Member.getReceipt_type());
            MemberInfoDialog.this.receipt_typeCN.hasNilItem(false);
            MemberInfoDialog.this.dobDT = new DateTextField(MemberInfoDialog.this.g_Member.getDob());
            MemberInfoDialog.this.baptist_dateDT = new DateTextField(MemberInfoDialog.this.g_Member.getBaptist_date());
            MemberInfoDialog.this.church_join_dateDT = new DateTextField(MemberInfoDialog.this.g_Member.getChurch_join_date());
            MemberInfoDialog.this.addressTA = new JTextArea(MemberInfoDialog.this.g_Member.getAddress());
            String photo_location = "image/member_photo/" + MemberInfoDialog.this.g_Member.getMember_seq() + ".jpg";
            MemberInfoDialog.this.photoLB = new JLabel(Tools.getScaledImage(photo_location, 50, 60));
            MemberInfoDialog.this.genMemberIdB = new JButton("New");
            MemberInfoDialog.this.photoChooseB = new JButton("Photo");
            MemberInfoDialog.this.saveB = new JButton("Save");
            MemberInfoDialog.this.cancelB = new JButton("Cancel");
            MemberInfoDialog.this.photoChooseB.setEnabled(User.hasPrivilege("memberModify"));
            MemberInfoDialog.this.saveB.setEnabled(User.hasPrivilege("memberModify"));
            this.addTable(new int[]{80, 0}, new int[]{15});
            this.addCell(new JLabel("Personal Info"), 0, 0, -1, 0);
            this.addCell(new JSeparator(), 1, 0, 0, 0, 0, -1);
            this.addTable(new int[]{100, 170, 70, 100, 0}, new int[]{30, 30, 30, 30, 30, 30, 30});
            this.addCell(new JLabel("Member ID"), 0, 0, 1, 0);
            this.addCell(MemberInfoDialog.this.member_idTF, 1, 0, 20, 0, 110, -1);
            if (!MemberInfoDialog.this.g_isUpdate) {
                this.addCell(MemberInfoDialog.this.genMemberIdB, 1, 0, 135, 0);
            }
            this.addCell(new JLabel("Gender"), 2, 0, 1, 0);
            this.addCell(MemberInfoDialog.this.genderCN, 3, 0, 20, 0);
            this.addCell(MemberInfoDialog.this.photoLB, 4, 0, 52, -1, 50, 60);
            this.addCell(new JLabel("Name 1"), 0, 1, 1, 0);
            this.addCell(MemberInfoDialog.this.name_chiTF, 1, 1, 20, 0, 140, -1);
            this.addCell(new JLabel("Gov. ID"), 2, 1, 1, 0);
            this.addCell(MemberInfoDialog.this.hkidTF, 3, 1, 20, 0, 80, -1);
            this.addCell(new JLabel("Name 2"), 0, 2, 1, 0);
            this.addCell(MemberInfoDialog.this.name_engTF, 1, 2, 20, 0, 320, -1);
            this.addCell(MemberInfoDialog.this.photoChooseB, 4, 2, 40, 0);
            this.addCell(new JLabel("Size W:250px H:300px"), 4, 3, 1, 0);
            this.addCell(new JLabel("Marital status"), 0, 4, 1, 0);
            this.addCell(MemberInfoDialog.this.marital_statusCN, 1, 4, 20, 0);
            this.addCell(new JLabel("DOB"), 2, 4, 1, 0);
            this.addCell(MemberInfoDialog.this.dobDT, 3, 4, 20, 0);
            this.addCell(new JLabel("Occupation"), 0, 5, 1, 0);
            this.addCell(MemberInfoDialog.this.careerTF, 1, 5, 20, 0, 140, -1);
            this.addCell(new JLabel("Education"), 2, 5, 1, 0);
            this.addCell(MemberInfoDialog.this.educationTF, 3, 5, 20, 0, 190, -1);
            this.addCell(new JLabel("Hobbies"), 0, 6, 1, 0);
            this.addCell(MemberInfoDialog.this.hobbyTF, 1, 6, 20, 0, 430, -1);
            this.addTable(new int[]{80, 0}, new int[]{15});
            this.addCell(new JLabel("Contact Info"), 0, 0, -1, 0);
            this.addCell(new JSeparator(), 1, 0, 0, 0, 0, -1);
            this.addTable(new int[]{100, 170, 70, 100, 0}, new int[]{65, 30, 30});
            this.addCell(new JLabel("Address"), 0, 0, 1, -1);
            this.addCell(new JScrollPane(MemberInfoDialog.this.addressTA), 1, 0, 20, -1, 430, 60);
            this.addCell(new JLabel("Tel 1"), 0, 1, 1, 0);
            this.addCell(MemberInfoDialog.this.tel1TF, 1, 1, 20, 0, 90, -1);
            this.addCell(new JLabel("Tel 2"), 2, 1, 1, 0);
            this.addCell(MemberInfoDialog.this.tel2TF, 3, 1, 20, 0, 90, -1);
            this.addCell(new JLabel("Email"), 0, 2, 1, 0);
            this.addCell(MemberInfoDialog.this.emailTF, 1, 2, 20, 0, 430, -1);
            this.addTable(new int[]{80, 0}, new int[]{15});
            this.addCell(new JLabel("Religion Info"), 0, 0, -1, 0);
            this.addCell(new JSeparator(), 1, 0, 0, 0, 0, -1);
            this.addTable(new int[]{100, 170, 70, 100, 0}, new int[]{30});
            this.addCell(new JLabel("Baptist Date"), 0, 0, 1, 0);
            this.addCell(MemberInfoDialog.this.baptist_dateDT, 1, 0, 20, 0);
            this.addCell(new JLabel("Join Church Date"), 2, 0, 1, 0);
            this.addCell(MemberInfoDialog.this.church_join_dateDT, 3, 0, 20, 0);
            this.addTable(new int[]{80, 0}, new int[]{15});
            this.addCell(new JLabel("System Info"), 0, 0, -1, 0);
            this.addCell(new JSeparator(), 1, 0, 0, 0, 0, -1);
            this.addTable(new int[]{100, 170, 70, 100, 0}, new int[]{30, 30});
            this.addCell(new JLabel("Login ID"), 0, 0, 1, 0);
            this.addCell(MemberInfoDialog.this.login_idTF, 1, 0, 20, 0, 140, -1);
            this.addCell(new JLabel("Password"), 2, 0, 1, 0);
            this.addCell(MemberInfoDialog.this.passwordTF, 3, 0, 20, 0, 190, -1);
            this.addCell(new JLabel("Receipt method"), 0, 1, 1, 0);
            this.addCell(MemberInfoDialog.this.receipt_typeCN, 1, 1, 20, 0);
        }

        private void setEventHandler() {
            MemberInfoDialog.this.genMemberIdB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainPanel.this.onGenMemberID(evt);
                }
            });
            MemberInfoDialog.this.saveB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MemberInfoDialog.this.onSave(evt);
                }
            });
            MemberInfoDialog.this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MemberInfoDialog.this.onCancel(evt);
                }
            });
            MemberInfoDialog.this.photoChooseB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainPanel.this.onPhotoChoose(evt);
                }
            });
        }

        private void onGenMemberID(ActionEvent evt) {
            MemberInfoDialog.this.member_idTF.setText(Tools.getNextID(Config.getS(Config.memberIdFormat), "member_id_seq", ""));
        }

        private void onPhotoChoose(ActionEvent evt) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            int option = chooser.showOpenDialog(this);
            if (option == 0) {
                String path = chooser.getSelectedFile().getPath();
                MemberInfoDialog.this.g_Photo_path = path;
                MemberInfoDialog.this.photoLB.setIcon(Tools.getScaledImage(path, 50, 60));
            }
        }
    }

    private class RemarkPanel
    extends TableLayout {
        private String gName;

        public RemarkPanel() {
            super(MemberInfoDialog.this.gWidth, MemberInfoDialog.this.gHeight, 5, 10);
            this.gName = "Remark";
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            MemberInfoDialog.this.addRemarkB = new JButton("Add");
            MemberInfoDialog.this.delRemarkB = new JButton("Delete");
            MemberInfoDialog.this.addRemarkB.setEnabled(User.hasPrivilege("memberModify"));
            MemberInfoDialog.this.delRemarkB.setEnabled(User.hasPrivilege("memberModify"));
            MemberInfoDialog.this.gMemberRemarkSL = new ScrollList(540, 430, MemberInfoDialog.this.g_MemberRemarks, new int[]{100, 300}, new String[]{"Item", "Value"}, new String[]{MemberRemark.CODE, MemberRemark.REMARK}, new boolean[]{true, true});
            MemberInfoDialog.this.gMemberRemarkSL.setEditing_mode(true);
            ComboBoxCN remarkNV = new ComboBoxCN(MasterCode.getCodes("MEMBER_REMARK"), "");
            MemberInfoDialog.this.gMemberRemarkSL.setComboxNVColumn("code", remarkNV);
            this.addTable(new int[]{0}, new int[]{430});
            this.addCell(MemberInfoDialog.this.gMemberRemarkSL, 0, 0, -1, 0);
            this.addYSpace(15);
            this.addTable(new int[]{0, 15, 80, 10}, new int[]{30});
            this.addCell(MemberInfoDialog.this.addRemarkB, 0, 0, 1, 0);
            this.addCell(MemberInfoDialog.this.delRemarkB, 2, 0, -1, 0);
        }

        private void setEventHandler() {
            MemberInfoDialog.this.addRemarkB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RemarkPanel.this.onAddRemark(evt);
                }
            });
            MemberInfoDialog.this.delRemarkB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RemarkPanel.this.onDelRemark(evt);
                }
            });
        }

        private void onAddRemark(ActionEvent evt) {
            ComparableHashMap h = new ComparableHashMap();
            h.put(MemberRemark.MEMBER_REMARK_SEQ, new Integer(-1));
            h.put(MemberRemark.MEMBER_SEQ, new Integer(MemberInfoDialog.this.g_Member.getMember_seq()));
            h.put(MemberRemark.CODE, "");
            h.put(MemberRemark.REMARK, "");
            MemberInfoDialog.this.g_MemberRemarks.add(h);
            MemberInfoDialog.this.gMemberRemarkSL.fireDataChanged();
        }

        private void onDelRemark(ActionEvent evt) {
            int sel_row = MemberInfoDialog.this.gMemberRemarkSL.getSelectedRow();
            if (sel_row == -1) {
                return;
            }
            ArrayList v = MemberInfoDialog.this.gMemberRemarkSL.getTableData();
            v.remove(sel_row);
            MemberInfoDialog.this.gMemberRemarkSL.fireDataChanged();
        }
    }
}

