/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import member.Member;
import member.MemberReport;
import ui.DataDialog;
import ui.TableLayout;
import util.WinUtil;

public class MemberImportDialog
extends DataDialog {
    private JButton templateB;
    private JButton fileB;
    private JButton saveB;
    private JButton cancelB;
    private JTextArea messageTA;
    private File gFile;

    public MemberImportDialog(JFrame f) {
        super(f, "Import Member", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 500, 500, 10, 10);
        this.templateB = new JButton("Get Template");
        this.fileB = new JButton("Select");
        this.saveB = new JButton("Import");
        this.saveB.setEnabled(false);
        this.cancelB = new JButton("Cancel");
        this.messageTA = new JTextArea("");
        this.messageTA.setEditable(false);
        JScrollPane messageSP = new JScrollPane(this.messageTA);
        int[] nArray = new int[3];
        nArray[0] = 80;
        nArray[1] = 270;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30});
        JLabel jLabel = new JLabel("");
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel("");
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.templateB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.fileB, 2, 1, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 2, 2, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 3, -1, 0, 115, -1);
        String message = "Method: Get template first.\n          Then add member info and save as a new file.\n          Finally import the file.\nCaution 1. Don't change the sequence of columns\n        2. The member ID field is mandatory\n        3. Some fields are represented by code\n           [Marital Status: SI=Single, MA=Married ,DI=Divorce ,WI=Widow]\n           [Receipt Type: P=Print, E=Email]\n";
        this.messageTA.setText(message);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{20, 20});
        JLabel jLabel3 = new JLabel("Message:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(messageSP, 0, 1, -1, -1, 475, 285);
    }

    public void setEventHandler() {
        this.templateB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberImportDialog.this.onGetTemplate(evt);
            }
        });
        this.fileB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberImportDialog.this.onFileChoose(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberImportDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberImportDialog.this.onCancel(evt);
            }
        });
    }

    public void onGetTemplate(ActionEvent evt) {
        MemberReport p = new MemberReport();
    }

    public void onFileChoose(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            this.gFile = chooser.getSelectedFile();
            String warning_msg = Member.checkImport(chooser.getSelectedFile());
            if (warning_msg.equals("")) {
                warning_msg = "All data are valid, you can now press \"Import\"\n";
                this.fileB.setEnabled(false);
                this.saveB.setEnabled(true);
            } else {
                WinUtil.showMessage(this, "Data error found!\nPlease follow the message to correct them");
            }
            this.messageTA.setText(warning_msg);
        }
    }

    public void onSave(ActionEvent evt) {
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        Member.insertImport(this.gFile);
        wait_dialog.dispose();
        this.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

