/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.MemberCardPrintout;
import ui.DataDialog;
import ui.TableLayout;
import util.Validation;
import util.WinUtil;

public class MemberCardPrintoutDialog
extends DataDialog {
    private JTextField start_memberTF;
    private JTextField end_memberTF;
    private JButton printB;
    private JButton cancelB;
    private ArrayList gMember_seqs;

    public MemberCardPrintoutDialog(JFrame frame) {
        this(frame, new ArrayList());
    }

    public MemberCardPrintoutDialog(JFrame frame, ArrayList member_seqs) {
        super(frame, "Print Member Card", false);
        this.gMember_seqs = member_seqs;
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 250, 180, 20, 20);
        int[] nArray = new int[2];
        nArray[0] = 60;
        t.addTable(nArray, new int[]{40, 20});
        this.start_memberTF = new JTextField();
        this.end_memberTF = new JTextField();
        if (!this.gMember_seqs.isEmpty()) {
            this.start_memberTF.setEditable(false);
            this.end_memberTF.setEditable(false);
        }
        t.addCell(new JLabel("Member ID(Start):"), 0, 0, 0, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.start_memberTF, 1, 0, 20, 0, 70, -1);
        t.addCell(new JLabel("Member ID(End):"), 0, 1, 0, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.end_memberTF, 1, 1, 20, 0, 70, -1);
        t.addYSpace(10);
        t.addTable(new int[]{100, 20, 80}, new int[]{20});
        this.printB = new JButton("Run");
        this.cancelB = new JButton("Cancel");
        t.addCell(this.printB, 0, 0, 1, 0);
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    public void setEventHandler() {
        this.printB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberCardPrintoutDialog.this.onPrint(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberCardPrintoutDialog.this.onCancel(evt);
            }
        });
    }

    public void onPrint(ActionEvent evt) {
        if (this.gMember_seqs.isEmpty()) {
            Validation validation = new Validation();
            validation.add(this.start_memberTF.getText(), "Member ID (Start)", "R");
            validation.add(this.end_memberTF.getText(), "Member ID (End)", "R");
            if (!validation.isValid()) {
                return;
            }
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        MemberCardPrintout p = new MemberCardPrintout(this.start_memberTF.getText(), this.end_memberTF.getText(), this.gMember_seqs);
        p.genFile();
        wait_dialog.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

