/*
 * Decompiled with CFR 0.152.
 */
package mainapp;

import database.DBUtil;
import de.javasoft.plaf.synthetica.SyntheticaBlackMoonLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import mainapp.AboutAction;
import mainapp.AccountActivityReportAction;
import mainapp.AccountListAction;
import mainapp.AccountPeriodListAction;
import mainapp.ActivityListAction;
import mainapp.AttendanceReportAction;
import mainapp.CheckVersionAction;
import mainapp.ConfigInfoAction;
import mainapp.ImportMemberAction;
import mainapp.MasterCodeListAction;
import mainapp.MemberGroupAction;
import mainapp.MemberListAction;
import mainapp.MemberReportAction;
import mainapp.OfferingPrintAction;
import mainapp.PasswordInfoAction;
import mainapp.ReceiptListAction;
import mainapp.ReceiptPrintAction;
import mainapp.RunSQLAction;
import mainapp.SystemCloseAction;
import mainapp.UserListAction;
import mainapp.VenueListAction;
import mainapp.VenueRequestAction;
import mainapp.VenueRequestReportAction;
import mainapp.VouTemplateListAction;
import mainapp.VoucherListAction;
import mainapp.WindowCloseListener;
import system.CheckUpdateThread;
import system.Config;
import system.Constants;
import system.Lang;
import system.LoginDialog;
import system.SystemCode;
import system.SystemUpdate;
import system.User;
import util.WinUtil;

public class MainFrame
extends JFrame {
    public static String CONFIG;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SyntheticaBlackMoonLookAndFeel());
            SyntheticaLookAndFeel.setFont((String)"DialogInput", (int)12);
            String[] li = new String[]{"Licensee=Barry Leung", "LicenseRegistrationNumber=NCBL100310", "Product=Synthetica", "LicenseType=Non Commercial", "ExpireDate=--.--.----", "MaxVersion=2.999.999"};
            UIManager.put("Synthetica.license.info", li);
            UIManager.put("Synthetica.license.key", "C26ABB21-8E6909E2-8FA16620-4A49FFA9-5EEF7E0C");
        }
        catch (Exception li) {
            // empty catch block
        }
        if (args.length != 0) {
            String config = "config/" + args[0];
            File f = new File(config);
            if (!f.exists()) {
                WinUtil.showMessage(null, "Config file " + f.getAbsoluteFile() + " doesn't exist");
                System.exit(0);
            } else {
                CONFIG = config;
            }
        } else {
            CONFIG = "config/config.txt";
        }
        if (!DBUtil.isDBConnectable()) {
            JOptionPane.showMessageDialog(null, "Database connection failure on \"" + Constants.DB_TYPE + "\",\"" + Constants.DB_PATH + "\"", "Error", 1);
            System.exit(1);
        }
        SystemUpdate systemUpdate = new SystemUpdate();
        LoginDialog d = new LoginDialog(null);
    }

    public static void initMainFrame() {
        MainFrame mainFrame = new MainFrame();
        mainFrame.setIconImage(Toolkit.getDefaultToolkit().getImage("image/icon.png"));
        mainFrame.setVisible(true);
        CheckUpdateThread checkUpdate = new CheckUpdateThread(mainFrame);
        checkUpdate.start();
        WinUtil.setFixedWindow(mainFrame, 400, 200);
        mainFrame.setVisible(true);
        WinUtil.getWaitingDialog(null, "...", 0.0);
        JDialog d = new JDialog(mainFrame);
        d.setVisible(true);
        d.dispose();
    }

    public MainFrame() {
        try {
            JMenuItem memberList;
            JMenuBar mainMenuBar = new JMenuBar();
            this.setJMenuBar(mainMenuBar);
            this.setTitle("Acts");
            this.getContentPane().setLayout(null);
            this.addWindowListener(new WindowCloseListener(this));
            JMenu systemMenu = new JMenu(Lang.set(" System "));
            if (User.hasPrivilege("masterCodeRead")) {
                JMenuItem masterCodeListItem = new JMenuItem(Lang.set("Custom Code"));
                masterCodeListItem.addActionListener(new MasterCodeListAction(this));
                systemMenu.add(masterCodeListItem);
            }
            if (User.hasPrivilege("userRead")) {
                JMenuItem userListItem = new JMenuItem(Lang.set("User"));
                userListItem.addActionListener(new UserListAction(this));
                systemMenu.add(userListItem);
            }
            if (User.hasPrivilege("configRead")) {
                JMenuItem configInfoItem = new JMenuItem(Lang.set("Setting"));
                configInfoItem.addActionListener(new ConfigInfoAction(this));
                systemMenu.add(configInfoItem);
            }
            if (User.hasPrivilege("importData")) {
                JMenu importData = new JMenu(Lang.set("Import"));
                JMenuItem importMemberItem = new JMenuItem(Lang.set("Import Member"));
                importMemberItem.addActionListener(new ImportMemberAction(this));
                importData.add(importMemberItem);
                systemMenu.add(importData);
            }
            if (User.hasPrivilege("runSQL")) {
                JMenuItem runSQLItem = new JMenuItem(Lang.set("Run SQL"));
                runSQLItem.addActionListener(new RunSQLAction(this));
                systemMenu.add(runSQLItem);
            }
            JMenuItem passwordInfoItem = new JMenuItem(Lang.set("Change Password"));
            passwordInfoItem.addActionListener(new PasswordInfoAction(this));
            systemMenu.add(passwordInfoItem);
            JMenuItem closeItem = new JMenuItem(Lang.set("Exit"));
            closeItem.addActionListener(new SystemCloseAction(this));
            systemMenu.add(closeItem);
            mainMenuBar.add(systemMenu);
            JMenu memberMenu = new JMenu(Lang.set(" Member "));
            if (User.hasPrivilege("memberRead")) {
                memberList = new JMenuItem(Lang.set("Member"));
                memberList.addActionListener(new MemberListAction(this));
                memberMenu.add(memberList);
            }
            if (User.hasPrivilege("memberGroupRead")) {
                JMenuItem memberGroupList = new JMenuItem(Lang.set("Member Group"));
                memberGroupList.addActionListener(new MemberGroupAction(this));
                memberMenu.add(memberGroupList);
            }
            if (User.hasPrivilege("memberReport")) {
                memberList = new JMenuItem(Lang.set("Member Report"));
                memberList.addActionListener(new MemberReportAction(this));
                memberMenu.add(memberList);
            }
            if (memberMenu.getItemCount() != 0) {
                mainMenuBar.add(memberMenu);
            }
            JMenu attendenceMenu = new JMenu(Lang.set(" Activity "));
            if (User.hasPrivilege("venueRead")) {
                JMenuItem venueList = new JMenuItem(Lang.set("Venue"));
                venueList.addActionListener(new VenueListAction(this));
                attendenceMenu.add(venueList);
            }
            if (User.hasPrivilege("venueRequestRead")) {
                JMenuItem venueRequest = new JMenuItem(Lang.set("Venue Reservation"));
                venueRequest.addActionListener(new VenueRequestAction(this));
                attendenceMenu.add(venueRequest);
            }
            if (User.hasPrivilege("venueRequestReport")) {
                JMenuItem venueRequestReport = new JMenuItem(Lang.set("Venue Reservation Report"));
                venueRequestReport.addActionListener(new VenueRequestReportAction(this));
                attendenceMenu.add(venueRequestReport);
            }
            if (User.hasPrivilege("activityRead")) {
                JMenuItem activityList = new JMenuItem(Lang.set("Activity"));
                activityList.addActionListener(new ActivityListAction(this));
                attendenceMenu.add(activityList);
            }
            if (User.hasPrivilege("attendanceReport")) {
                JMenuItem attendanceReport = new JMenuItem(Lang.set("Attendance Report"));
                attendanceReport.addActionListener(new AttendanceReportAction(this));
                attendenceMenu.add(attendanceReport);
            }
            if (attendenceMenu.getItemCount() != 0) {
                mainMenuBar.add(attendenceMenu);
            }
            JMenu accountMenu = new JMenu(Lang.set(" Account "));
            if (User.hasPrivilege("receiptRead")) {
                JMenuItem receiptList = new JMenuItem(Lang.set("Receipt"));
                receiptList.addActionListener(new ReceiptListAction(this));
                accountMenu.add(receiptList);
            }
            if (User.hasPrivilege("receiptPrint")) {
                JMenu receiptPrint = new JMenu(Lang.set("Print Receipt"));
                JMenuItem receiptPrintM = new JMenuItem(Lang.set("Print Receipt"));
                receiptPrintM.addActionListener(new ReceiptPrintAction(this));
                receiptPrint.add(receiptPrintM);
                JMenuItem offeringPrintM = new JMenuItem(Lang.set("Print Donation Certificate"));
                offeringPrintM.addActionListener(new OfferingPrintAction(this));
                receiptPrint.add(offeringPrintM);
                accountMenu.add(receiptPrint);
            }
            if (User.hasPrivilege("voucherRead")) {
                JMenuItem voucherList = new JMenuItem(Lang.set("Voucher"));
                voucherList.addActionListener(new VoucherListAction(this));
                accountMenu.add(voucherList);
            }
            if (User.hasPrivilege("vouTemplateRead")) {
                JMenuItem vouTemplateList = new JMenuItem(Lang.set("Voucher Template"));
                vouTemplateList.addActionListener(new VouTemplateListAction(this));
                accountMenu.add(vouTemplateList);
            }
            if (User.hasPrivilege("accountRead")) {
                JMenuItem accountList = new JMenuItem(Lang.set("Account"));
                accountList.addActionListener(new AccountListAction(this));
                accountMenu.add(accountList);
            }
            if (User.hasPrivilege("voucherRead")) {
                JMenuItem accountPeriodList = new JMenuItem(Lang.set("Posting"));
                accountPeriodList.addActionListener(new AccountPeriodListAction(this));
                accountMenu.add(accountPeriodList);
            }
            if (User.hasPrivilege("accountActivityReport")) {
                JMenuItem accountActivityReport = new JMenuItem(Lang.set("Account Activity Report"));
                accountActivityReport.addActionListener(new AccountActivityReportAction(this));
                accountMenu.add(accountActivityReport);
            }
            if (accountMenu.getItemCount() != 0) {
                mainMenuBar.add(accountMenu);
            }
            JMenu helpMenu = new JMenu(Lang.set(" Help "));
            JMenuItem about = new JMenuItem(Lang.set("About"));
            about.addActionListener(new AboutAction(this));
            helpMenu.add(about);
            if (Config.getS(Config.autoCheckUpdate).equals(SystemCode.YN__Y)) {
                JMenuItem checkVersion = new JMenuItem(Lang.set("Check for Updates"));
                checkVersion.addActionListener(new CheckVersionAction(this));
                helpMenu.add(checkVersion);
            }
            mainMenuBar.add(helpMenu);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

