/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import database.DBUtil;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import member.MemberGroup;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Lang;
import system.MasterCode;
import util.RecordList;
import util.TimeUtil;

public class AttendanceReport {
    public ExcelCellFormat FORMAT_TOTAL = new ExcelCellFormat(ExcelCellFormat.INT, String.valueOf(ExcelFormat.BT) + ExcelFormat.BD);
    public ExcelCellFormat FORMAT_LATE_TIME = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.FCR);
    public ExcelCellFormat FORMAT_WFAR = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.WF) + ExcelFormat.AR);
    public ExcelCellFormat FORMAT_BT = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BT);
    public ExcelCellFormat FORMAT_BD = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BD);
    private String ATD__PRESENT = "O";
    private String ATD__LATE = "L";
    private String ATD__EXEMPT_PRESENT = "E";
    private String ATD__EXEMPT_LATE = "LE";
    private String ATD__ABSENT = "A";

    public AttendanceReport(String activity_type, Timestamp start_date, Timestamp end_date, RecordList member_groups, boolean show_time, boolean show_remark) {
        RecordList members = AttendanceReport.getMembers(member_groups, start_date, end_date);
        RecordList activities = AttendanceReport.getActivities(activity_type, start_date, end_date);
        RecordList attendances = AttendanceReport.getAttendances(activity_type, start_date, end_date);
        RecordList headcounts = AttendanceReport.getHeadcounts(activity_type, start_date, end_date);
        int prefix_col = 7;
        int[] widths = new int[prefix_col + activities.size()];
        widths[0] = 28;
        widths[1] = 22;
        widths[2] = 12;
        widths[3] = 12;
        widths[4] = 12;
        widths[5] = 12;
        widths[6] = 14;
        int i = 0;
        while (i < activities.size()) {
            widths[prefix_col + i] = 16;
            ++i;
        }
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4R, widths);
        p.addHeader(Lang.set("Attendance Report"), new String[]{String.valueOf(Lang.set("Category: ")) + MasterCode.getName(activity_type), String.valueOf(Lang.set("Date: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" to ") + TimeUtil.getStringByDate(end_date), String.valueOf(Lang.set("Total Acitivity: ")) + activities.size(), String.valueOf(Lang.set("Group: ")) + MemberGroup.getOneNameStringOfGroups(member_groups), show_time ? "" : Lang.set("Remark: O:Attend,L:Late,E:Exempt,LE:Late Exempt,Blank:Absent")});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("Member ID"), p.TL);
        p.addCell(1, row, Lang.set("Name"), p.TL);
        p.addCell(2, row, Lang.set("Attend"), p.TL);
        p.addCell(3, row, Lang.set("Ex."), p.TL);
        p.addCell(4, row, Lang.set("Abs."), p.TL);
        p.addCell(5, row, Lang.set("Late"), p.TL);
        p.addCell(6, row, Lang.set("Att%"), p.TL);
        int i2 = 0;
        while (i2 < activities.size()) {
            Timestamp date = activities.getT("date", i2);
            SimpleDateFormat df = new SimpleDateFormat("d MMM", Locale.ENGLISH);
            String d = df.format((Date)date, new StringBuffer(), new FieldPosition(2)).toString();
            p.addCell(prefix_col + i2, row, d, p.TL);
            ++i2;
        }
        i2 = 0;
        while (i2 < member_groups.size()) {
            int mg_seq = member_groups.getI("member_group_seq", i2);
            MemberGroup mg = new MemberGroup(mg_seq);
            String mg_name = mg.getName();
            RecordList mg_members = members.getGroupItems("member_group_seq", mg_seq);
            RecordList hcs = headcounts.getGroupItems("member_group_seq", mg_seq);
            int[] mg_activity_present = new int[activities.size()];
            int[] mg_activity_late = new int[activities.size()];
            int q = 0;
            while (q < activities.size()) {
                mg_activity_present[q] = 0;
                mg_activity_late[q] = 0;
                ++q;
            }
            p.addCell(0, row += 2, mg_name);
            int j = 0;
            while (j < mg_members.size()) {
                mg_members.setCurrentRow(j);
                int member_seq = mg_members.getI("member_seq");
                String member_id = mg_members.getS("member_id");
                String name_chi = mg_members.getS("name_chi");
                RecordList mg_member_atds = attendances.getGroupItems("member_seq", member_seq);
                p.addCell(0, ++row, member_id);
                p.addCell(1, row, name_chi);
                int present = 0;
                int exempt_present = 0;
                int late = 0;
                String atd_type = "";
                int q2 = 0;
                while (q2 < activities.size()) {
                    int activity_seq = activities.getI("activity_seq", q2);
                    int k = mg_member_atds.indexOf(new String[]{"activity_seq", "member_seq"}, new Integer[]{new Integer(activity_seq), new Integer(member_seq)});
                    if (k != -1) {
                        Timestamp in_time = mg_member_atds.getT("in_time", k);
                        String exempt = mg_member_atds.getS("exempt", k);
                        String remark = mg_member_atds.getS("remark", k);
                        if (exempt.equals("Y") && in_time == null) {
                            ++exempt_present;
                            atd_type = this.ATD__EXEMPT_PRESENT;
                        } else if (in_time != null) {
                            ++present;
                            int n = q2;
                            mg_activity_present[n] = mg_activity_present[n] + 1;
                            Timestamp late_time = activities.getT("late_time", q2);
                            if (in_time.after(late_time)) {
                                if (exempt.equals("Y")) {
                                    atd_type = this.ATD__EXEMPT_LATE;
                                } else {
                                    ++late;
                                    int n2 = q2;
                                    mg_activity_late[n2] = mg_activity_late[n2] + 1;
                                    atd_type = this.ATD__LATE;
                                }
                            } else {
                                atd_type = this.ATD__PRESENT;
                            }
                        } else {
                            atd_type = this.ATD__ABSENT;
                        }
                        String cell = "";
                        ExcelCellFormat cf = p.FORMAT_STRING;
                        if (show_time) {
                            if (atd_type.equals(this.ATD__LATE)) {
                                cf = this.FORMAT_LATE_TIME;
                            }
                            cell = TimeUtil.getStringByTime(in_time);
                        } else if (!atd_type.equals(this.ATD__ABSENT)) {
                            cell = atd_type;
                        }
                        if (show_remark && !remark.equals("")) {
                            cell = remark;
                        }
                        p.addCell(prefix_col + q2, row, cell, cf);
                    }
                    ++q2;
                }
                p.addCell(2, row, String.valueOf(present));
                p.addCell(3, row, String.valueOf(exempt_present));
                p.addCell(4, row, String.valueOf(activities.size() - present - exempt_present));
                p.addCell(5, row, String.valueOf(late));
                p.addCell(6, row, String.valueOf(String.valueOf(present * 100 / activities.size())) + "%");
                ++j;
            }
            p.addCell(0, ++row, Lang.set("Total Members:"), this.FORMAT_WFAR);
            p.addCell(1, row, String.valueOf(mg_members.size()));
            p.addCell(6, row, String.valueOf(mg_name) + Lang.set(" Taken:"), this.FORMAT_WFAR);
            q = 0;
            while (q < activities.size()) {
                p.addCell(prefix_col + q, row, mg_activity_present[q], this.FORMAT_BT);
                ++q;
            }
            p.addCell(6, ++row, String.valueOf(mg_name) + Lang.set(" Total Attend:"), this.FORMAT_WFAR);
            q = 0;
            while (q < activities.size()) {
                int s = hcs.indexOf("activity_seq", activities.getI("activity_seq", q));
                int hc = s == -1 ? 0 : hcs.getI("headcount", s);
                p.addCell(prefix_col + q, row, mg_activity_present[q] + hc, this.FORMAT_BD);
                ++q;
            }
            p.addCell(6, ++row, Lang.set("Late:"), this.FORMAT_WFAR);
            q = 0;
            while (q < activities.size()) {
                p.addCell(prefix_col + q, row, mg_activity_late[q]);
                ++q;
            }
            ++i2;
        }
        p.genPrintout();
    }

    private static RecordList getMembers(RecordList member_groups, Timestamp start_date, Timestamp end_date) {
        String sql = "select distinct mgm.member_group_seq,mb.member_seq,mb.member_id,mb.name_chi from  member mb,member_group_member mgm where mb.member_seq=mgm.member_seq and mgm.member_group_seq in" + DBUtil.getSQLInValues(member_groups.getCol("member_group_seq")) + " and mgm.start_date<=?" + " and mgm.end_date>=?" + " order by mb.name_chi";
        Object[] pvs = new Object[]{end_date, start_date};
        return DBUtil.run(sql, pvs);
    }

    private static RecordList getActivities(String activity_type, Timestamp start_date, Timestamp end_date) {
        String sql = "select activity_seq,date,late_time from activity where type=? and status=? and date>=? and date<=? order by date";
        Object[] pvs = new Object[]{activity_type, Activity.STATUS__CP, start_date, end_date};
        return DBUtil.run("select activity_seq,date,late_time from activity where type=? and status=? and date>=? and date<=? order by date", pvs);
    }

    private static RecordList getAttendances(String activity_type, Timestamp start_date, Timestamp end_date) {
        String sql = "select atv.activity_seq,atd.member_seq,atd.in_time,atd.exempt,atd.remark from activity atv,attendance atd where atv.activity_seq=atd.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=?";
        Object[] pvs = new Object[]{activity_type, Activity.STATUS__CP, start_date, end_date};
        return DBUtil.run("select atv.activity_seq,atd.member_seq,atd.in_time,atd.exempt,atd.remark from activity atv,attendance atd where atv.activity_seq=atd.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=?", pvs);
    }

    private static RecordList getHeadcounts(String activity_type, Timestamp start_date, Timestamp end_date) {
        String sql = "select atv.activity_seq,amg.member_group_seq,amg.headcount from activity atv,activity_member_group amg where atv.activity_seq=amg.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=?";
        Object[] pvs = new Object[]{activity_type, Activity.STATUS__CP, start_date, end_date};
        return DBUtil.run("select atv.activity_seq,amg.member_group_seq,amg.headcount from activity atv,activity_member_group amg where atv.activity_seq=amg.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=?", pvs);
    }
}

