/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import attendance.Attendance;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ui.DataDialog;
import ui.TableLayout;
import util.RecordList;
import util.TimeUtil;
import util.WinUtil;

public class AttendanceImportDialog
extends DataDialog {
    private JButton fileB;
    private JButton saveB;
    private JButton cancelB;
    private JTextArea messageTA;
    private Activity g_Activity = null;
    private RecordList g_Valid_records;

    public AttendanceImportDialog(DataDialog f, int activity_seq) {
        super(f, "Import Attendance", true);
        this.g_Activity = new Activity(activity_seq);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 500, 500, 10, 10);
        this.fileB = new JButton("Open File");
        this.saveB = new JButton("Import");
        this.saveB.setEnabled(false);
        this.cancelB = new JButton("Cancel");
        this.messageTA = new JTextArea("");
        this.messageTA.setEditable(false);
        JScrollPane messageSP = new JScrollPane(this.messageTA);
        int[] nArray = new int[3];
        nArray[0] = 80;
        nArray[1] = 270;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("Acitivty: ");
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel(this.g_Activity.getName());
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 1, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.fileB, 2, 0, -1, 0, 115, -1);
        JLabel jLabel3 = new JLabel("Date: ");
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        JLabel jLabel4 = new JLabel(TimeUtil.getStringByDate(this.g_Activity.getDate()));
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 1, 1, -1, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 2, 1, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 2, -1, 0, 115, -1);
        t.addYSpace(20);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{20, 20});
        JLabel jLabel5 = new JLabel("Messages:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(messageSP, 0, 1, -1, -1, 475, 315);
    }

    public void setEventHandler() {
        this.fileB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceImportDialog.this.onFileChoose(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceImportDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceImportDialog.this.onCancel(evt);
            }
        });
    }

    public void onFileChoose(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            Object[] obj = Attendance.checkImport(chooser.getSelectedFile(), this.g_Activity);
            String warning_msg = (String)obj[0];
            this.g_Valid_records = (RecordList)obj[1];
            if (warning_msg.equals("")) {
                warning_msg = "All Data are correct, you can click \"Import\"\n";
            } else {
                WinUtil.showMessage(this, "Data with error!\nIf you still want to import, you can click \"Import\"");
            }
            this.saveB.setEnabled(true);
            this.messageTA.setText(warning_msg);
        }
    }

    public void onSave(ActionEvent evt) {
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        Attendance.insertImport(this.g_Activity, this.g_Valid_records);
        wait_dialog.dispose();
        this.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

