/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import attendance.ActivityInfoDialog;
import attendance.AttendanceImportDialog;
import attendance.AttendanceListDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import system.MasterCode;
import system.User;
import ui.ComboBoxCN;
import ui.DataDialog;
import ui.DateTextField;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;

public class ActivityListDialog
extends DataDialog {
    private JButton searchB;
    private JButton addB;
    private JButton modifyB;
    private JButton importB;
    private JButton attendanceListB;
    private JButton copyB;
    private JTextField activity_idTF;
    private JTextField nameTF;
    private ComboBoxCN typeCN;
    private DateTextField start_dateDT;
    private DateTextField end_dateDT;
    private ScrollList listSL;
    private ArrayList g_List = Activity.search("", "", null, null);

    public ActivityListDialog(JFrame frame) {
        super(frame, "Activity List", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.nameTF = new JTextField();
        this.typeCN = new ComboBoxCN(MasterCode.getCodes("ACTIVITY"));
        this.start_dateDT = new DateTextField();
        this.end_dateDT = new DateTextField();
        this.searchB = new JButton("Search");
        this.addB = new JButton("Add");
        this.modifyB = new JButton("Edit/View");
        this.importB = new JButton("Import Att.");
        this.attendanceListB = new JButton("Att. List");
        this.copyB = new JButton("Copy");
        boolean canModify = User.hasPrivilege("activityModify");
        boolean canRead = User.hasPrivilege("activityRead");
        this.addB.setEnabled(canModify);
        this.modifyB.setEnabled(canRead);
        this.importB.setEnabled(canModify);
        this.attendanceListB.setEnabled(canRead);
        this.copyB.setEnabled(canModify);
        this.listSL = new ScrollList(560, 410, this.g_List, new int[]{110, 170, 85, 60, 75, 60}, new String[]{"Type", "Name", "Date", "Time", "Venue", "Status"}, new String[]{"type", "name", "date", "start_time", "venue", "status"}, new boolean[6]);
        this.listSL.setDateTextFieldColumn("date");
        this.listSL.setTimeTextFieldColumn("start_time", null);
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 250;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("Category");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.typeCN, 1, 0, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 3, 0, -1, 0, 115, -1);
        JLabel jLabel2 = new JLabel("Name");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, 1, 20, 0, 150, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.importB, 2, 1, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 3, 1, -1, 0, 115, -1);
        JLabel jLabel3 = new JLabel("Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDT, 1, 2, 20, 0);
        JLabel jLabel4 = new JLabel("to");
        t.getClass();
        t.addCell(jLabel4, 1, 2, 115, 0);
        t.getClass();
        t.addCell(this.end_dateDT, 1, 2, 140, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.attendanceListB, 2, 2, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.copyB, 3, 2, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{400});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    public void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityListDialog.this.onSearch(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityListDialog.this.onAdd(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityListDialog.this.onModify(evt);
            }
        });
        this.copyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityListDialog.this.onCopy(evt);
            }
        });
        this.importB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityListDialog.this.onImport(evt);
            }
        });
        this.attendanceListB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityListDialog.this.onShowAttendanceList(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        ArrayList v = Activity.search(this.nameTF.getText(), this.typeCN.getSelectedCode(), this.start_dateDT.getDate(), this.end_dateDT.getDate());
        this.listSL.refreshTable(v);
    }

    public void onAdd(ActionEvent evt) {
        ActivityInfoDialog d = new ActivityInfoDialog(this);
    }

    public void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int activity_seq = ArrayUtil.getInt("ACTIVITY_SEQ", selrow, this.listSL.getTableData());
            ActivityInfoDialog activityInfoDialog = new ActivityInfoDialog((DataDialog)this, activity_seq, true);
        }
    }

    public void onCopy(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int activity_seq = ArrayUtil.getInt("ACTIVITY_SEQ", selrow, this.listSL.getTableData());
            ActivityInfoDialog activityInfoDialog = new ActivityInfoDialog((DataDialog)this, activity_seq, false);
        }
    }

    public void onImport(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int activity_seq = ArrayUtil.getInt("ACTIVITY_SEQ", selrow, this.listSL.getTableData());
            AttendanceImportDialog attendanceImportDialog = new AttendanceImportDialog(this, activity_seq);
        }
    }

    public void onShowAttendanceList(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int activity_seq = ArrayUtil.getInt("ACTIVITY_SEQ", selrow, this.listSL.getTableData());
            AttendanceListDialog attendanceListDialog = new AttendanceListDialog(this, activity_seq);
        }
    }
}

