/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Voucher;
import account.VoucherInfoDialog;
import account.VoucherPrintout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import system.SystemCode;
import system.User;
import ui.DataDialog;
import ui.DateTextField;
import ui.ScrollList2;
import ui.TableLayout;
import util.RecordList;
import util.WinUtil;

public class VoucherListDialog
extends DataDialog {
    private JButton searchB;
    private JButton addB;
    private JButton modifyB;
    private JButton printB;
    private JTextField idTF;
    private JTextField ac_idTF;
    private DateTextField start_dateDT;
    private DateTextField end_dateDT;
    JCheckBox selectAllCB;
    private ScrollList2 listSL;
    private RecordList gList = Voucher.search("", "", null, null);

    public VoucherListDialog(JFrame frame) {
        super(frame, "Voucher List", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setLayout() {
        this.idTF = new JTextField();
        this.ac_idTF = new JTextField();
        this.start_dateDT = new DateTextField();
        this.end_dateDT = new DateTextField();
        this.searchB = new JButton("Search");
        this.addB = new JButton("Add");
        this.modifyB = new JButton("Edit/View");
        this.printB = new JButton("Print");
        this.selectAllCB = new JCheckBox("Select All", false);
        this.addB.setEnabled(User.hasPrivilege("voucherModify"));
        this.printB.setEnabled(User.hasPrivilege("voucherPrint"));
        boolean[] blArray = new boolean[5];
        blArray[4] = true;
        this.listSL = new ScrollList2(560, 410, this.gList, new int[]{170, 90, 170, 70, 55}, new String[]{"Voucher ID", "Date", "Amount", "Status", "Select"}, new String[]{"id", "date", "amount", "status", "selected"}, blArray);
        this.listSL.setDateTextFieldColumn("date");
        this.listSL.setBigDecimalTextFieldColumn("amount");
        this.listSL.setCheckBoxYNColumn("selected", "Y", "N");
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 240;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        int row = 0;
        JLabel jLabel = new JLabel("Voucher ID");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.idTF, 1, row, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, row, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 3, row, -1, 0, 115, -1);
        ++row;
        JLabel jLabel2 = new JLabel("A/C Code");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.ac_idTF, 1, row, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 3, row, -1, 0, 115, -1);
        ++row;
        JLabel jLabel3 = new JLabel("Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDT, 1, row, 20, 0);
        JLabel jLabel4 = new JLabel("to");
        t.getClass();
        t.addCell(jLabel4, 1, row, 115, 0);
        t.getClass();
        t.addCell(this.end_dateDT, 1, row, 140, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.selectAllCB, 2, row, -1, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.printB, 3, row, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{425});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    private void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherListDialog.this.onSearch(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherListDialog.this.onAdd(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherListDialog.this.onModify(evt);
            }
        });
        this.printB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherListDialog.this.onPrint(evt);
            }
        });
        this.selectAllCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherListDialog.this.onSelectAll(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        RecordList r = Voucher.search(this.idTF.getText(), this.ac_idTF.getText(), this.start_dateDT.getDate(), this.end_dateDT.getDate());
        this.listSL.refreshTable(r);
        this.selectAllCB.setSelected(false);
    }

    public void onAdd(ActionEvent evt) {
        VoucherInfoDialog d = new VoucherInfoDialog((DataDialog)this, -1, false);
    }

    private void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int ac_doc_seq = this.listSL.getTableData().getI("ac_doc_seq", selrow);
            VoucherInfoDialog voucherInfoDialog = new VoucherInfoDialog((DataDialog)this, ac_doc_seq, true);
        }
    }

    public void onPrint(ActionEvent evt) {
        ArrayList<Integer> ac_doc_seqs = new ArrayList<Integer>();
        int i = 0;
        while (i < this.listSL.getTableData().size()) {
            if (this.listSL.getTableData().getS("selected", i).equals("Y")) {
                int ac_doc_seq = this.listSL.getTableData().getI("ac_doc_seq", i);
                ac_doc_seqs.add(new Integer(ac_doc_seq));
            }
            ++i;
        }
        if (!ac_doc_seqs.isEmpty()) {
            DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
            VoucherPrintout p = new VoucherPrintout(ac_doc_seqs);
            p.genFile();
            wait_dialog.dispose();
        } else {
            WinUtil.showMessage(this, "Please select the entry boxes");
        }
    }

    public void onSelectAll(ActionEvent evt) {
        RecordList r = this.listSL.getTableData();
        int i = 0;
        while (i < r.size()) {
            r.setS("selected", this.selectAllCB.isSelected() ? SystemCode.YN__Y : SystemCode.YN__N, i);
            ++i;
        }
        this.listSL.refreshTable(r);
    }
}

