/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.VoucherItem;
import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import java.util.ArrayList;
import system.Lang;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class Voucher {
    private int g_Ac_doc_seq = -1;
    private String g_Id = "";
    private Timestamp g_Date = null;
    private String g_Status = "";
    public static String AC_DOC_SEQ = "ac_doc_seq";
    public static String ID = "id";
    public static String DATE = "date";
    public static String STATUS = "status";
    public static String STATUS__IP = "IP";
    public static String STATUS__CP = "CP";
    public static String STATUS__CL = "CL";
    public static Object[] STATUS_MAP = new Object[]{new String[]{STATUS__IP, Lang.set("Pending")}, new String[]{STATUS__CP, Lang.set("Confirm")}, new String[]{STATUS__CL, Lang.set("Cancel")}};

    public Voucher() {
    }

    public Voucher(int ac_doc_seq) {
        this.g_Ac_doc_seq = ac_doc_seq;
        this.load();
    }

    public int getAc_doc_seq() {
        return this.g_Ac_doc_seq;
    }

    public String getId() {
        return this.g_Id;
    }

    public Timestamp getDate() {
        return this.g_Date;
    }

    public String getStatus() {
        return this.g_Status;
    }

    private void load() {
        String sql = "select id,date,status from voucher where ac_doc_seq=?";
        RecordList r = DBUtil.run(sql, this.g_Ac_doc_seq);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Id = r.getS("id");
            this.g_Date = r.getT("date");
            this.g_Status = r.getS("status");
        }
    }

    public static int insert(String id, Timestamp date, String status, RecordList items) {
        String sql = "insert into voucher( ac_doc_seq,id,date,status)values(?,?,?,?)";
        DBConn conn = new DBConn();
        int ac_doc_seq = DBUtil.getNextValueFor("ac_doc_seq", conn);
        DBUtil.run(sql, new Object[]{new Integer(ac_doc_seq), id, date, status}, conn);
        VoucherItem.update(ac_doc_seq, items, conn);
        conn.commit();
        return conn.isSuccessful() ? ac_doc_seq : -1;
    }

    public static int update(int ac_doc_seq, String id, Timestamp date, String status, RecordList items) {
        String sql = "update voucher set id=?,date=?,status=? where ac_doc_seq=?";
        DBConn conn = new DBConn();
        DBUtil.run(sql, new Object[]{id, date, status, new Integer(ac_doc_seq)}, conn);
        VoucherItem.update(ac_doc_seq, items, conn);
        conn.commit();
        return conn.isSuccessful() ? ac_doc_seq : -1;
    }

    public static boolean existID(String id, int ac_doc_seq) {
        String sql = "select 'x' from voucher where id=? and ac_doc_seq<>?";
        RecordList r = DBUtil.run(sql, new Object[]{id, new Integer(ac_doc_seq)});
        return !r.isEmpty();
    }

    public static RecordList search(String id, String ac_id, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"lower(vo.ID) like lower(?)", "lower(ac.ID) like lower(?)", "vo.date>=?", "vo.date<?"}, new Object[]{Tools.pad(id), Tools.pad(ac_id), start_date, TimeUtil.adjustDate(end_date, 1)});
        String sql = "select vo.ac_doc_seq,vo.id,vo.date,vo.status,sum(voi.debit) as amount,'n' as selected from voucher vo,voucher_item voi,ac_master ac where vo.ac_doc_seq=voi.ac_doc_seq and voi.ac_seq=ac.ac_seq" + clause.getConds() + " group by vo.ac_doc_seq,vo.id,vo.date,vo.status" + " order by vo.date desc,vo.id desc" + " limit 1000";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            r.setS("status", Tools.getStatusName(STATUS_MAP, r.getS("status")));
            ++i;
        }
        return r;
    }

    public static RecordList getVouchers(ArrayList ac_doc_seqs) {
        String sql = "select ac_doc_seq,id,date from voucher where status<>'" + STATUS__CL + "'" + " and ac_doc_seq in" + DBUtil.getSQLInValues(ac_doc_seqs) + " order by date,id";
        return DBUtil.run(sql);
    }
}

