/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.VouTemplate;
import account.VouTemplateItem;
import account.VouTemplateListDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import system.SystemCode;
import ui.AutoComboBoxNV;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.ScrollList2;
import ui.TableLayout;
import util.ArrayUtil;
import util.ComparableHashMap;
import util.RecordList;
import util.Validation;
import util.WinUtil;

public class VouTemplateInfoDialog
extends DataDialog {
    private JTextField idTF;
    private JTextField ttl_debitTF;
    private JTextField ttl_creditTF;
    private ComboBoxCN statusCN;
    private AutoComboBoxNV add_ac_idNV;
    private JButton add_itemB;
    private JButton del_itemB;
    private JButton saveB;
    private JButton cancelB;
    private ScrollList2 itemSL;
    private VouTemplate g_VouTemplate = null;
    private RecordList g_Items;
    private boolean g_isUpdate = false;

    public VouTemplateInfoDialog(DataDialog f, int vou_template_seq) {
        super(f, "Add Voucher Template", false);
        if (vou_template_seq >= 0) {
            this.setTitle("Edit Voucher Template");
            this.g_isUpdate = true;
        } else {
            this.g_isUpdate = false;
        }
        this.init(vou_template_seq);
    }

    private void init(int vou_template_seq) {
        this.g_VouTemplate = new VouTemplate(vou_template_seq);
        VouTemplateItem p = new VouTemplateItem(vou_template_seq);
        this.g_Items = p.getItems();
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        this.idTF = new JTextField(this.g_VouTemplate.getId());
        this.statusCN = new ComboBoxCN(SystemCode.getStatus(), this.g_VouTemplate.getStatus());
        if (!this.g_isUpdate) {
            this.statusCN.setSelectedCode(SystemCode.STATUS__A);
        }
        this.add_ac_idNV = new AutoComboBoxNV(Account.getAllChildAccounts(), "name", "ac_seq", -1);
        this.add_itemB = new JButton("Add Item");
        this.del_itemB = new JButton("Del Item");
        this.saveB = new JButton("Save");
        this.cancelB = new JButton("Cancel");
        TableLayout t = new TableLayout(this, 700, 490, 5, 10);
        int[] nArray = new int[6];
        nArray[0] = 80;
        nArray[1] = 180;
        nArray[2] = 80;
        nArray[3] = 160;
        nArray[4] = 80;
        t.getClass();
        nArray[5] = 0;
        t.addTable(nArray, new int[]{30, 15, 30});
        JLabel jLabel = new JLabel("Name");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.idTF, 1, 0, 20, 0, 150, -1);
        JLabel jLabel2 = new JLabel("Status");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 4, 0, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 5, 0, 20, 0);
        JLabel jLabel3 = new JLabel("Add A/C");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        t.getClass();
        t.addCell(this.add_ac_idNV, 1, 2, 20, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.add_itemB, 4, 2, 1, 0);
        t.getClass();
        t.addCell(this.del_itemB, 5, 2, 10, 0);
        this.itemSL = new ScrollList2(660, 285, this.g_Items, new int[]{185, 200, 80, 55, 55}, new String[]{"A/C", "Remark", "Cheque#", "Debit", "Credit"}, new String[]{VouTemplateItem.AC_SEQ, VouTemplateItem.REMARK, VouTemplateItem.CHEQUE_NO, VouTemplateItem.DEBIT, VouTemplateItem.CREDIT}, new boolean[]{true, true, true, true, true});
        this.itemSL.setBigDecimalTextFieldColumn(VouTemplateItem.DEBIT);
        this.itemSL.setBigDecimalTextFieldColumn(VouTemplateItem.CREDIT);
        this.itemSL.setEditing_mode(true);
        ComboBoxNV item_acENV = new ComboBoxNV(Account.getAllChildAccounts(), "name", "ac_seq", -1);
        this.itemSL.setComboxNVColumn("ac_seq", item_acENV);
        this.ttl_debitTF = new JTextField(String.valueOf(this.g_Items.getColumnSum(VouTemplateItem.DEBIT)));
        this.ttl_debitTF.setEditable(false);
        this.ttl_creditTF = new JTextField(String.valueOf(this.g_Items.getColumnSum(VouTemplateItem.CREDIT)));
        this.ttl_creditTF.setEditable(false);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{290});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, -1, -1);
        t.addTable(new int[]{485, 100, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.ttl_debitTF, 1, 0, 1, 0, 75, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.ttl_creditTF, 2, 0, 1, 0, 75, -1);
        t.addYSpace(10);
        t.addTable(new int[]{525, 80, 80}, new int[]{30});
        t.getClass();
        t.addCell(this.saveB, 1, 0, 15, 0);
        t.getClass();
        t.addCell(this.cancelB, 2, 0, 10, 0);
    }

    private void setEventHandler() {
        this.add_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VouTemplateInfoDialog.this.onAddItem(evt);
            }
        });
        this.del_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VouTemplateInfoDialog.this.onDelItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VouTemplateInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VouTemplateInfoDialog.this.onCancel(evt);
            }
        });
        this.itemSL.addActionListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                VouTemplateInfoDialog.this.onTableChanged(e);
            }
        });
    }

    private void onAddItem(ActionEvent evt) {
        ArrayList acs = this.add_ac_idNV.getItems();
        int ac_seq = ArrayUtil.getInt("AC_SEQ", this.add_ac_idNV.getSelectedIndex(), acs);
        RecordList r = this.itemSL.getTableData();
        String last_remark = "";
        if (!r.isEmpty()) {
            last_remark = r.getS(VouTemplateItem.REMARK, r.size() - 1);
        }
        ComparableHashMap h = new ComparableHashMap();
        h.put(VouTemplateItem.VOU_TEMPLATE_ITEM_SEQ, new Integer(-1));
        h.put(VouTemplateItem.AC_SEQ, new Integer(ac_seq));
        h.put(VouTemplateItem.DEBIT, new BigDecimal(0));
        h.put(VouTemplateItem.CREDIT, new BigDecimal(0));
        h.put(VouTemplateItem.CHEQUE_NO, "");
        h.put(VouTemplateItem.REMARK, last_remark);
        r.add(h);
        this.itemSL.fireDataChanged();
    }

    private void onDelItem(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        this.itemSL.getTableData().remove(sel_row);
        this.itemSL.fireDataChanged();
        this.ttl_debitTF.setText(String.valueOf(this.itemSL.getTableData().getColumnSum(VouTemplateItem.DEBIT)));
        this.ttl_creditTF.setText(String.valueOf(this.itemSL.getTableData().getColumnSum(VouTemplateItem.CREDIT)));
    }

    private void onTableChanged(TableModelEvent e) {
        if (this.itemSL.getChangedColName(e).equals(VouTemplateItem.DEBIT)) {
            this.itemSL.getTableData().setD(VouTemplateItem.CREDIT, 0.0, e.getFirstRow());
            this.calTotal();
        } else if (this.itemSL.getChangedColName(e).equals(VouTemplateItem.CREDIT)) {
            this.itemSL.getTableData().setD(VouTemplateItem.DEBIT, 0.0, e.getFirstRow());
            this.calTotal();
        }
    }

    private void calTotal() {
        this.ttl_debitTF.setText(String.valueOf(this.itemSL.getTableData().getColumnSum(VouTemplateItem.DEBIT)));
        this.ttl_creditTF.setText(String.valueOf(this.itemSL.getTableData().getColumnSum(VouTemplateItem.CREDIT)));
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.idTF.getText(), "Tempate Name", "R");
        validation.add(this.statusCN.getSelectedIndex(), "Status", "CBNVIR");
        validation.add(!VouTemplate.existID(this.idTF.getText(), this.g_VouTemplate.getVou_template_seq()), "The name already exist, please use another one", "RT");
        RecordList items = this.itemSL.getTableData();
        validation.add(items.size(), "Item counts", "GTZ");
        int i = 0;
        while (i < items.size()) {
            items.setCurrentRow(i);
            int ac_seq = items.getI(VouTemplateItem.AC_SEQ);
            double debit = items.getD(VouTemplateItem.DEBIT);
            double credit = items.getD(VouTemplateItem.CREDIT);
            validation.add(ac_seq, "Item " + (i + 1) + " A/C", "CBNVIR");
            validation.add(debit, "Item " + (i + 1) + " debit amount", "F");
            validation.add(credit, "Item " + (i + 1) + " credit amount", "F");
            validation.add(debit + credit, "Item " + (i + 1) + " debit/credit amount", "F,GTZ");
            ++i;
        }
        if (!validation.isValid()) {
            return false;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        if (this.g_isUpdate) {
            VouTemplate.update(this.g_VouTemplate.getVou_template_seq(), this.idTF.getText(), this.statusCN.getSelectedCode(), items);
        } else {
            VouTemplate.insert(this.idTF.getText(), this.statusCN.getSelectedCode(), items);
        }
        ((VouTemplateListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

