/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import account.ReceiptInfoDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import system.User;
import ui.ComboBoxCN;
import ui.DataDialog;
import ui.DateTextField;
import ui.ScrollList2;
import ui.TableLayout;
import util.RecordList;
import util.WinUtil;

public class ReceiptListDialog
extends DataDialog {
    private JButton searchB;
    private JButton addB;
    private JButton modifyB;
    private JButton approveB;
    private JTextField offer_fromTF;
    private DateTextField start_dateDT;
    private DateTextField end_dateDT;
    private ComboBoxCN statusCN;
    private ScrollList2 listSL;
    private RecordList g_List = Receipt.search("", null, null, "", true);
    private RecordList g_ApproveList;

    public ReceiptListDialog(JFrame frame) {
        super(frame, "Receipt List", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.offer_fromTF = new JTextField();
        this.start_dateDT = new DateTextField();
        this.end_dateDT = new DateTextField();
        this.statusCN = new ComboBoxCN(ComboBoxCN.buildItemsByMap(Receipt.STATUS_MAP), "");
        this.searchB = new JButton("Search");
        this.addB = new JButton("Add");
        this.modifyB = new JButton("Edit/View");
        this.approveB = new JButton("Approve");
        this.addB.setEnabled(User.hasPrivilege("receiptModify"));
        this.approveB.setEnabled(User.hasPrivilege("receiptApprove"));
        this.listSL = new ScrollList2(560, 410, this.g_List, new int[]{85, 80, 200, 75, 75, 45}, new String[]{"Receipt ID", "Date", "From", "Amount", "Status", "Email"}, new String[]{"id", "date", "offer_from", "total", "status", "email_status"}, new boolean[6]);
        this.listSL.setDateTextFieldColumn("date");
        this.listSL.setBigDecimalTextFieldColumn("total");
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 250;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("From");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.offer_fromTF, 1, 0, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 3, 0, -1, 0, 115, -1);
        JLabel jLabel2 = new JLabel("Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDT, 1, 1, 20, 0);
        JLabel jLabel3 = new JLabel("to");
        t.getClass();
        t.addCell(jLabel3, 1, 1, 115, 0);
        t.getClass();
        t.addCell(this.end_dateDT, 1, 1, 140, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 3, 1, -1, 0, 115, -1);
        JLabel jLabel4 = new JLabel("Status");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 2, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 1, 2, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.approveB, 3, 2, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{400});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    private void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptListDialog.this.onSearch(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptListDialog.this.onAdd(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptListDialog.this.onModify(evt);
            }
        });
        this.approveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptListDialog.this.onApprove(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        RecordList r = Receipt.search(this.offer_fromTF.getText(), this.start_dateDT.getDate(), this.end_dateDT.getDate(), this.statusCN.getSelectedCode(), true);
        this.listSL.refreshTable(r);
    }

    public void onAdd(ActionEvent evt) {
        ReceiptInfoDialog d = new ReceiptInfoDialog(this, -1, false, false);
    }

    private void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int receipt_seq = this.listSL.getTableData().getI("receipt_seq", selrow);
            ReceiptInfoDialog receiptInfoDialog = new ReceiptInfoDialog(this, receipt_seq, true, false);
        }
    }

    public void onNextApprove(boolean skipAll) {
        if (!skipAll && this.g_ApproveList.getCurrentRow() < this.g_ApproveList.size() - 1) {
            this.g_ApproveList.setCurrentRow(this.g_ApproveList.getCurrentRow() + 1);
            ReceiptInfoDialog d = new ReceiptInfoDialog(this, this.g_ApproveList.getI("receipt_seq"), false, true);
        } else {
            this.onSearch(null);
        }
    }

    private void onApprove(ActionEvent evt) {
        this.g_ApproveList = Receipt.search("", null, null, Receipt.STATUS__WA, false);
        if (this.g_ApproveList.isEmpty()) {
            WinUtil.showMessage(this, "No waiting approval receipt");
            return;
        }
        this.g_ApproveList.setCurrentRow(-1);
        this.onNextApprove(false);
    }
}

