/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.AccountMonth;
import account.AccountPostingListDialog;
import account.AccountYear;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.TableLayout;
import util.TimeUtil;
import util.Validation;
import util.WinUtil;

public class AccountYearPostingDialog
extends DataDialog {
    JTextField nameTF;
    ComboBoxNV plr_acNV;
    JButton lockB;
    JButton unpostB;
    JButton postB;
    JButton cancelB;
    private Timestamp g_Start_date1;
    private Timestamp g_Start_date2;
    private boolean g_Posted = false;
    private boolean g_Consistence = false;
    private boolean g_Locked = false;
    private AccountYear g_AccountYear;

    public AccountYearPostingDialog(DataDialog f, Timestamp start_date1, Timestamp start_date2) {
        super(f, "Yearly Posting", false);
        this.g_Start_date1 = start_date1;
        this.g_Start_date2 = start_date2;
        this.g_Posted = AccountYear.isPosted(this.g_Start_date1, this.g_Start_date2);
        this.g_Consistence = AccountYear.isPostConsistence(this.g_Start_date1, this.g_Start_date2);
        int ac_year_seq = -1;
        if (this.g_Posted && this.g_Consistence) {
            ac_year_seq = AccountYear.getMonth_posted_ac_year_seq(this.g_Start_date1, this.g_Start_date2);
        }
        this.g_AccountYear = new AccountYear(ac_year_seq);
        this.g_Locked = this.g_AccountYear.getLock().equals("Y");
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.plr_acNV = new ComboBoxNV(Account.getAccountsOfPLRetainedGroup(), "name", "ac_seq", this.g_AccountYear.getPlr_ac_seq());
        this.nameTF = new JTextField(this.g_AccountYear.getName());
        this.lockB = new JButton(this.g_Locked ? "Unlock" : "Lock");
        this.unpostB = new JButton("Unpost");
        this.postB = new JButton("Post");
        this.cancelB = new JButton("Cancel");
        if (!this.g_Posted || !this.g_Consistence) {
            this.lockB.setEnabled(false);
        }
        if (this.g_Locked || !this.g_Posted || !this.g_Consistence) {
            this.unpostB.setEnabled(false);
        }
        if (this.g_Locked || !this.g_Consistence) {
            this.postB.setEnabled(false);
        }
        TableLayout t = new TableLayout(this, 370, 215, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 120;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30});
        String msg = !this.g_Consistence ? "Exist more than one yearly posting or monthly posting period are not in sequence" : "";
        int row = 0;
        JLabel jLabel = new JLabel("Fiscal Period");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, row, 1, 0);
        JLabel jLabel2 = new JLabel(String.valueOf(TimeUtil.getStringByDate(this.g_Start_date1)) + " to " + TimeUtil.getStringByDate(TimeUtil.getMonthEndDay(this.g_Start_date2)));
        t.getClass();
        t.addCell(jLabel2, 1, row, 20, 0);
        JLabel jLabel3 = new JLabel(msg);
        t.getClass();
        t.addCell(jLabel3, 1, ++row, 20, 0);
        ++row;
        JLabel jLabel4 = new JLabel("Fiscal Year Name");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, row, 20, 0, 200, -1);
        ++row;
        JLabel jLabel5 = new JLabel("Retained P&L A/C");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.plr_acNV, 1, row, 20, 0, 200, -1);
        t.addYSpace(15);
        t.addTable(new int[]{90, 90, 90, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.lockB, 0, 0, -1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.unpostB, 1, 0, -1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.postB, 2, 0, -1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 3, 0, -1, 0, 80, -1);
    }

    void setEventHandler() {
        this.lockB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountYearPostingDialog.this.onLock(evt);
            }
        });
        this.unpostB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountYearPostingDialog.this.onUnpost(evt);
            }
        });
        this.postB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountYearPostingDialog.this.onPost(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountYearPostingDialog.this.onCancel(evt);
            }
        });
    }

    void onLock(ActionEvent evt) {
        AccountYear.lock(this.g_AccountYear.getAc_year_seq(), this.g_Locked ? "N" : "Y");
        this.dispose();
        ((AccountPostingListDialog)this.getParent()).onSearch(null);
    }

    void onUnpost(ActionEvent evt) {
        AccountYear.unpost(this.g_AccountYear.getAc_year_seq(), AccountMonth.getAc_month_seq(this.g_Start_date2));
        this.dispose();
        ((AccountPostingListDialog)this.getParent()).onSearch(null);
    }

    void onPost(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.nameTF.getText(), "Fiscal Year Name", "R");
        validation.add(this.plr_acNV.getSelectedIntValue(), "Retained P&L A/C", "CBNVIR");
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        if (this.g_Posted) {
            AccountYear.update(this.g_AccountYear.getAc_year_seq(), this.nameTF.getText(), this.g_Start_date1, this.g_Start_date2, AccountMonth.getAc_month_seq(this.g_Start_date2), this.plr_acNV.getSelectedIntValue());
        } else {
            AccountYear.insert(this.nameTF.getText(), this.g_Start_date1, this.g_Start_date2, AccountMonth.getAc_month_seq(this.g_Start_date2), this.plr_acNV.getSelectedIntValue());
        }
        wait_dialog.dispose();
        this.dispose();
        ((AccountPostingListDialog)this.getParent()).onSearch(null);
    }

    void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

