/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.AccountInfoDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import system.User;
import ui.DataDialog;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;

public class AccountListDialog
extends DataDialog {
    private JButton searchB;
    private JButton addB;
    private JButton modifyB;
    private JTextField idTF;
    private JTextField nameTF;
    private ScrollList listSL;
    private ArrayList g_List = Account.search("", "");

    public AccountListDialog(JFrame frame) {
        super(frame, "Account List", false);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setLayout() {
        this.idTF = new JTextField();
        this.nameTF = new JTextField();
        this.searchB = new JButton("Search");
        this.addB = new JButton("Add");
        this.modifyB = new JButton("Edit/View");
        this.addB.setEnabled(User.hasPrivilege("accountModify"));
        this.modifyB.setEnabled(User.hasPrivilege("accountRead"));
        this.listSL = new ScrollList(560, 410, this.g_List, new int[]{80, 210, 60}, new String[]{"Code", "Name", "Type"}, new String[]{"id", "name", "type"}, new boolean[3]);
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[3];
        nArray[0] = 80;
        nArray[1] = 370;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("Code");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.idTF, 1, 0, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, 0, -1, 0, 115, -1);
        JLabel jLabel2 = new JLabel("Name");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, 1, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 2, 1, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 2, 2, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{425});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    private void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountListDialog.this.onSearch(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountListDialog.this.onAdd(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountListDialog.this.onModify(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        ArrayList v = Account.search(this.idTF.getText(), this.nameTF.getText());
        this.listSL.refreshTable(v);
    }

    public void onAdd(ActionEvent evt) {
        AccountInfoDialog d = new AccountInfoDialog((DataDialog)this, -1, false);
    }

    private void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int ac_seq = ArrayUtil.getInt("ac_seq", selrow, this.listSL.getTableData());
            AccountInfoDialog accountInfoDialog = new AccountInfoDialog((DataDialog)this, ac_seq, true);
        }
    }
}

