/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.AccountListDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import system.SystemCode;
import system.User;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.TableLayout;
import util.Validation;
import util.WinUtil;

public class AccountInfoDialog
extends DataDialog {
    ComboBoxNV parent_acNV;
    ComboBoxCN typeCN;
    JTextField idTF;
    JTextField nameTF;
    JCheckBox is_parentCB;
    JButton saveB;
    JButton cancelB;
    private Account g_Account = null;
    private boolean g_isUpdate = false;

    public AccountInfoDialog(DataDialog f, int ac_seq, boolean isUpdate) {
        super(f, "Add Account", false);
        if (isUpdate) {
            this.setTitle("Edit Account");
        }
        this.g_isUpdate = isUpdate;
        this.init(ac_seq);
    }

    private void init(int ac_seq) {
        this.g_Account = new Account(ac_seq);
        this.setEditLayout();
        this.setEventHandler();
        this.onSelectParentAccount(null);
        this.lockForExistChildAccount();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.parent_acNV = new ComboBoxNV(Account.getAllParentAccounts(), "name", "ac_seq", this.g_Account.getParent_ac_seq());
        this.typeCN = new ComboBoxCN(SystemCode.getAccount(), this.g_Account.getType());
        this.typeCN.getSelectedCode();
        this.idTF = new JTextField(this.g_Account.getId());
        this.nameTF = new JTextField(this.g_Account.getName());
        this.is_parentCB = new JCheckBox("Group A/C", this.g_Account.getIs_parent().equals("Y"));
        this.saveB = new JButton("Save");
        this.cancelB = new JButton("Cancel");
        this.saveB.setEnabled(User.hasPrivilege("accountModify"));
        TableLayout t = new TableLayout(this, 380, 220, 5, 10);
        int[] nArray = new int[3];
        nArray[0] = 80;
        nArray[1] = 180;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30});
        JLabel jLabel = new JLabel("Group A/C");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.parent_acNV, 1, 0, 20, 0, 170, -1);
        JLabel jLabel2 = new JLabel("Type");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.typeCN, 1, 1, 20, 0, 170, -1);
        JLabel jLabel3 = new JLabel("Code");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.idTF, 1, 2, 20, 0, 170, -1);
        t.getClass();
        t.addCell(this.is_parentCB, 2, 2, 20, 0);
        JLabel jLabel4 = new JLabel("Name");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 3, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, 3, 20, 0, 170, -1);
        t.addYSpace(15);
        t.addTable(new int[]{280, 15, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    void setEventHandler() {
        this.parent_acNV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountInfoDialog.this.onSelectParentAccount(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountInfoDialog.this.onCancel(evt);
            }
        });
    }

    void onSelectParentAccount(ActionEvent evt) {
        if (this.parent_acNV.isSelected()) {
            int ac_seq = this.parent_acNV.getSelectedIntValue();
            Account c = new Account(ac_seq);
            this.typeCN.setSelectedCode(c.getType());
            this.typeCN.setEnabled(false);
        } else {
            this.typeCN.setEnabled(true);
        }
    }

    void lockForExistChildAccount() {
        if (Account.existChild(this.g_Account.getAc_seq())) {
            this.parent_acNV.setEnabled(false);
            this.typeCN.setEnabled(false);
            this.is_parentCB.setEnabled(false);
        }
    }

    void onSave(ActionEvent evt) {
        int seq;
        Validation validation = new Validation();
        validation.add(this.typeCN.getSelectedCode(), "Type", "R");
        validation.add(this.idTF.getText(), "Code", "R");
        validation.add(this.nameTF.getText(), "Name", "R");
        if (!this.is_parentCB.isSelected()) {
            validation.add(this.parent_acNV.isSelected(), "Please choose the group a/c", "RT");
        }
        if (!((seq = Account.getAc_seq(this.idTF.getText())) == -1 || this.g_isUpdate && seq == this.g_Account.getAc_seq())) {
            validation.add(false, "Code " + this.idTF.getText() + " already exists", "RT");
        }
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        if (this.g_isUpdate) {
            Account.update(this.g_Account.getAc_seq(), this.idTF.getText(), this.is_parentCB.isSelected() ? "Y" : "N", this.nameTF.getText(), this.parent_acNV.getSelectedIntValue(), this.typeCN.getSelectedCode());
        } else {
            Account.insert(this.idTF.getText(), this.is_parentCB.isSelected() ? "Y" : "N", this.nameTF.getText(), this.parent_acNV.getSelectedIntValue(), this.typeCN.getSelectedCode());
        }
        ((AccountListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
    }

    void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

